package edu.sc.seis.TauP;

public class PierceTimeDist extends TimeDist {
    private final ArrivalPathSegment pathSeg;

    public PierceTimeDist(double p, double time, double dist, double depth, ArrivalPathSegment pathSeg) {
        super(p, time, dist, depth);
        this.pathSeg = pathSeg;
    }

    public double inboundAngle() {
        SeismicPhaseSegment phaseSegment = pathSeg.getPhaseSegment();
        VelocityModel vMod = phaseSegment.getTauModel().getVelocityModel();
        VelocityLayer vLayer;
        boolean inboundIsAbove = phaseSegment.isDownGoing;
        boolean outboundIsAbove = phaseSegment.isDownGoing;
        PhaseInteraction prevEndAction = phaseSegment.prevEndAction;
        if (getDepth() == pathSeg.getPathStart().getDepth()) {
            // check for underside reflection, etc
            if ( phaseSegment.isFlat) {
                if (prevEndAction == PhaseInteraction.DIFFRACT || prevEndAction == PhaseInteraction.TRANSUPDIFFRACT) {
                    inboundIsAbove = true;
                } else if (prevEndAction == PhaseInteraction.HEAD) {
                    inboundIsAbove = false;
                } else {
                    throw new RuntimeException("Unknown flat prevEndAction: "+prevEndAction);
                }
            }
            if (PhaseInteraction.isDowngoingActionBefore(prevEndAction)) {
                inboundIsAbove = true;
            } else {
                inboundIsAbove = false;
            }
        }
        try {
            if (inboundIsAbove) {
                int aboveLayerNum = vMod.layerNumberAbove(getDepth());
                vLayer = vMod.getVelocityLayer(aboveLayerNum);
            } else {
                int belowLayerNum = vMod.layerNumberBelow(getDepth());
                vLayer = vMod.getVelocityLayer(belowLayerNum);
            }
            double vel = vLayer.evaluateAt(getDepth(), pathSeg.isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY);
            double angle = Math.asin(vel * getP() / vMod.radiusOfEarth);
            return angle;
        } catch (NoSuchLayerException e) {
            // shoudl not happen
            throw new RuntimeException("Should not happen, but guess it did!", e);
        }
    }

}
