/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelMaterial;

public class PierceTimeDist
extends TimeDist {
    private final ArrivalPathSegment pathSeg;

    public PierceTimeDist(double p, double time, double dist, double depth, ArrivalPathSegment pathSeg) {
        super(p, time, dist, depth);
        this.pathSeg = pathSeg;
    }

    public double inboundAngle() {
        SeismicPhaseSegment phaseSegment = this.pathSeg.getPhaseSegment();
        VelocityModel vMod = phaseSegment.getTauModel().getVelocityModel();
        boolean inboundIsAbove = phaseSegment.isDownGoing;
        boolean outboundIsAbove = phaseSegment.isDownGoing;
        PhaseInteraction prevEndAction = phaseSegment.prevEndAction;
        if (this.getDepth() == this.pathSeg.getPathStart().getDepth()) {
            if (phaseSegment.isFlat) {
                if (prevEndAction == PhaseInteraction.DIFFRACT || prevEndAction == PhaseInteraction.TRANSUPDIFFRACT) {
                    inboundIsAbove = true;
                } else if (prevEndAction == PhaseInteraction.HEAD) {
                    inboundIsAbove = false;
                } else {
                    throw new RuntimeException("Unknown flat prevEndAction: " + String.valueOf((Object)prevEndAction));
                }
            }
            inboundIsAbove = PhaseInteraction.isDowngoingActionBefore(prevEndAction);
        }
        try {
            VelocityLayer vLayer;
            if (inboundIsAbove) {
                int aboveLayerNum = vMod.layerNumberAbove(this.getDepth());
                vLayer = vMod.getVelocityLayer(aboveLayerNum);
            } else {
                int belowLayerNum = vMod.layerNumberBelow(this.getDepth());
                vLayer = vMod.getVelocityLayer(belowLayerNum);
            }
            double vel = vLayer.evaluateAt(this.getDepth(), this.pathSeg.isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY);
            double angle = Math.asin(vel * this.getP() / vMod.radiusOfEarth);
            return angle;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen, but guess it did!", e);
        }
    }
}

