/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicLine;

public class EventAzimuth
extends LatLonable {
    double azimuth;
    LatLonLocatable evtLatLon;

    public EventAzimuth(LatLonLocatable evtLatLon, Double azimuth, Geodesic geodesic) {
        this.evtLatLon = evtLatLon;
        this.azimuth = azimuth;
        this.geodesic = geodesic;
    }

    @Override
    public double[] calcLatLon(double calcDist, double totalDist) {
        double[] out = new double[2];
        Location evtLoc = this.evtLatLon.asLocation();
        if (this.isGeodetic()) {
            GeodesicLine gLine = this.geodesic.ArcDirectLine(evtLoc.getLatitude(), evtLoc.getLongitude(), this.azimuth, calcDist);
            out[0] = gLine.Latitude();
            out[1] = gLine.Longitude();
        } else {
            out[0] = SphericalCoords.latFor(evtLoc.getLatitude(), evtLoc.getLongitude(), calcDist, this.azimuth);
            out[1] = SphericalCoords.lonFor(evtLoc.getLatitude(), evtLoc.getLongitude(), calcDist, this.azimuth);
        }
        return out;
    }
}

