/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.DistanceRay;
import net.sf.geographiclib.Geodesic;

public class DistanceGeodeticKmRay
extends DistanceRay {
    protected double kilometers;

    public DistanceGeodeticKmRay(double km, Geodesic geod) {
        this.kilometers = km;
        this.geodesic = geod;
    }

    @Override
    public double getDegrees(double radius) {
        return this.getRadians(radius) * 57.29577951308232;
    }

    @Override
    public double getRadians(double radius) {
        return this.kilometers / this.averageRadiusKm();
    }

    @Override
    public double getKilometers(double radius) {
        return this.kilometers;
    }

    public double averageRadiusKm() {
        double polarRadius = this.geodesic.EquatorialRadius() * (1.0 - this.geodesic.Flattening());
        double meanRadius = (2.0 * this.geodesic.EquatorialRadius() + polarRadius) / 3.0;
        return meanRadius / 1000.0;
    }
}

