/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import net.sf.geographiclib.Geodesic;

public enum DistAzPlanet {
    EARTH(Geodesic.WGS84.EquatorialRadius(), Geodesic.WGS84.Flattening()),
    MOON(1738100.0, 0.0058823529411764705),
    MARS(3396190.0, 0.0012),
    VENUS(6051800.0, 0.0),
    MERCURY(2439700.0, 9.0E-4),
    CERES(964300.0, 0.07518796992481203),
    JUPITER(1.42984E8, 0.06489292667099286),
    SATURN(1.20536E8, 0.0979431929480901),
    URANUS(5.1118E7, 0.02292526364053187),
    NEPTUNE(4.9528E7, 0.01708233686368295);

    private final double equitorialradius;
    private final double geodeticFlattening;

    private DistAzPlanet(double equitorialradius, double geodeticFlattening) {
        this.equitorialradius = equitorialradius;
        this.geodeticFlattening = geodeticFlattening;
    }

    private double equitorialradius() {
        return this.equitorialradius;
    }

    private double geodeticFlattening() {
        return this.geodeticFlattening;
    }

    public Geodesic createGeodesic() {
        return new Geodesic(this.equitorialradius, this.geodeticFlattening);
    }
}

