/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.dmc.seedcodec;

import edu.iris.dmc.seedcodec.SteimException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SteimFrameBlock {
    private int maxNumFrames = 0;
    private int numSamples = 0;
    private int steimVersion = 0;
    private int currentFrame = -1;
    private List<SteimFrame> steimFrameList = new ArrayList<SteimFrame>();
    SteimFrame currentSteimFrame = null;

    public SteimFrameBlock(int maxNumFrames, int steimVersion) {
        this.maxNumFrames = maxNumFrames;
        this.steimVersion = steimVersion;
    }

    public int getNumSamples() {
        return this.numSamples;
    }

    public int getSteimVersion() {
        return this.steimVersion;
    }

    public SteimFrame[] getSteimFrames() {
        return this.steimFrameList.toArray(new SteimFrame[0]);
    }

    @Deprecated
    public int numNonEmptyFrames() {
        return this.steimFrameList.size();
    }

    @Deprecated
    public void trimEmptyFrames() {
    }

    public byte[] getEncodedData() throws IOException {
        ByteArrayOutputStream encodedData = new ByteArrayOutputStream(this.getNumFrames() * 64);
        DataOutputStream intSerializer = new DataOutputStream(encodedData);
        for (SteimFrame frame : this.steimFrameList) {
            for (int j = 0; j < 16; ++j) {
                intSerializer.writeInt(frame.word[j]);
            }
        }
        return encodedData.toByteArray();
    }

    public int getNumFrames() {
        if (this.maxNumFrames == 0) {
            return this.steimFrameList.size();
        }
        return this.maxNumFrames;
    }

    protected boolean addEncodedWord(int word, int samples, int nibble) throws SteimException {
        if (this.currentSteimFrame == null) {
            if (this.maxNumFrames > 0 && this.currentFrame >= this.maxNumFrames) {
                throw new SteimException("Frame Block is full");
            }
            this.currentSteimFrame = new SteimFrame();
            this.currentSteimFrame.pos = 1;
            this.addEncodingNibble(0);
            this.steimFrameList.add(this.currentSteimFrame);
            ++this.currentFrame;
        }
        int pos = this.currentSteimFrame.pos;
        this.currentSteimFrame.word[pos] = word;
        this.addEncodingNibble(nibble);
        this.numSamples += samples;
        if (++pos > 15) {
            this.currentSteimFrame = null;
            if (this.maxNumFrames > 0 && this.currentFrame >= this.maxNumFrames - 1) {
                return true;
            }
        } else {
            this.currentSteimFrame.pos = pos;
        }
        return false;
    }

    protected void setXsubN(int word) {
        this.steimFrameList.get((int)0).word[2] = word;
    }

    private void addEncodingNibble(int bitFlag) {
        int offset = this.currentSteimFrame.pos;
        int shift = (15 - offset) * 2;
        this.currentSteimFrame.word[0] = this.currentSteimFrame.word[0] | bitFlag << shift;
    }

    private class SteimFrame {
        public int[] word = new int[16];
        public int pos = 0;

        private SteimFrame() {
        }

        public boolean isEmpty() {
            return this.word[0] == 0;
        }
    }
}

