/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class EventDescription {
    int irisFECode = -1;
    String text;
    String type;

    public EventDescription(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("description", reader);
        Attribute feCodeAttr = startE.getAttributeByName(new QName("http://service.iris.edu/fdsnws/event/1/", "FEcode"));
        if (feCodeAttr != null) {
            try {
                this.irisFECode = Integer.parseInt(feCodeAttr.getValue());
            }
            catch (NumberFormatException e) {
                throw new SeisFileException("Unable to parse FECode, expected integer but was: " + feCodeAttr.getValue(), e);
            }
        }
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("text")) {
                    this.text = StaxUtil.pullText(reader, "text");
                    continue;
                }
                if (elName.equals("type")) {
                    this.type = StaxUtil.pullText(reader, "type");
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public int getIrisFECode() {
        return this.irisFECode;
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public void setIrisFECode(int irisFECode) {
        this.irisFECode = irisFECode;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        return this.getType() + ": " + (this.getText() == null ? "" : this.getText());
    }
}

