/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.BoxArea;
import edu.sc.seis.seisFile.DonutArea;
import edu.sc.seis.seisFile.fdsnws.AbstractQueryParams;
import edu.sc.seis.seisFile.fdsnws.QueryLevel;
import java.time.Instant;

public class FDSNStationQueryParams
extends AbstractQueryParams
implements Cloneable {
    public static final String STARTTIME = "starttime";
    public static final String STARTTIME_SHORT = "start";
    public static final String ENDTIME = "endtime";
    public static final String ENDTIME_SHORT = "end";
    public static final String STARTBEFORE = "startbefore";
    public static final String STARTAFTER = "startafter";
    public static final String ENDBEFORE = "endbefore";
    public static final String ENDAFTER = "endafter";
    public static final String NETWORK = "network";
    public static final String NETWORK_SHORT = "net";
    public static final String STATION = "station";
    public static final String STATION_SHORT = "sta";
    public static final String LOCATION = "location";
    public static final String LOCATION_SHORT = "loc";
    public static final String CHANNEL = "channel";
    public static final String CHANNEL_SHORT = "cha";
    public static final String MINLATITUDE = "minlatitude";
    public static final String MINLATITUDE_SHORT = "minlat";
    public static final String MAXLATITUDE = "maxlatitude";
    public static final String MAXLATITUDE_SHORT = "maxlat";
    public static final String MINLONGITUDE = "minlongitude";
    public static final String MINLONGITUDE_SHORT = "minlon";
    public static final String MAXLONGITUDE = "maxlongitude";
    public static final String MAXLONGITUDE_SHORT = "maxlon";
    public static final String LATITUDE = "latitude";
    public static final String LATITUDE_SHORT = "lat";
    public static final String LONGITUDE = "longitude";
    public static final String LONGITUDE_SHORT = "lon";
    public static final String MINRADIUS = "minradius";
    public static final String MAXRADIUS = "maxradius";
    public static final String LEVEL = "level";
    public static final String INCLUDERESTRICTED = "includerestricted";
    public static final String INCLUDEAVAILABILITY = "includeavailability";
    public static final String MATCHTIMESERIES = "matchtimeseries";
    public static final String UPDATEDAFTER = "updatedafter";
    public static final String LEVEL_NETWORK = QueryLevel.network.name();
    public static final String LEVEL_STATION = QueryLevel.station.name();
    public static final String LEVEL_CHANNEL = QueryLevel.channel.name();
    public static final String LEVEL_RESPONSE = QueryLevel.response.name();
    public static final String STATION_SERVICE = "station";

    public FDSNStationQueryParams() {
        this("service.earthscope.org");
    }

    public FDSNStationQueryParams(String host) {
        super(host == null ? "service.earthscope.org" : host);
    }

    public FDSNStationQueryParams clone() {
        FDSNStationQueryParams out = new FDSNStationQueryParams(this.getHost());
        out.cloneNonParams(this);
        for (String key : this.params.keySet()) {
            out.setParam(key, (String)this.params.get(key));
        }
        return out;
    }

    public FDSNStationQueryParams setHost(String host) {
        this.host = host;
        return this;
    }

    public FDSNStationQueryParams setPort(int port) {
        this.port = port;
        return this;
    }

    public FDSNStationQueryParams clearStartTime() {
        this.clearParam(STARTTIME);
        return this;
    }

    public FDSNStationQueryParams setStartTime(Instant value) {
        this.setParam(STARTTIME, value);
        return this;
    }

    public FDSNStationQueryParams clearEndTime() {
        this.clearParam(ENDTIME);
        return this;
    }

    public FDSNStationQueryParams setEndTime(Instant value) {
        this.setParam(ENDTIME, value);
        return this;
    }

    public FDSNStationQueryParams clearStartBefore() {
        this.clearParam(STARTBEFORE);
        return this;
    }

    public FDSNStationQueryParams setStartBefore(Instant value) {
        this.setParam(STARTBEFORE, value);
        return this;
    }

    public FDSNStationQueryParams clearStartAfter() {
        this.clearParam(STARTAFTER);
        return this;
    }

    public FDSNStationQueryParams setStartAfter(Instant value) {
        this.setParam(STARTAFTER, value);
        return this;
    }

    public FDSNStationQueryParams clearEndBefore() {
        this.clearParam(ENDBEFORE);
        return this;
    }

    public FDSNStationQueryParams setEndBefore(Instant value) {
        this.setParam(ENDBEFORE, value);
        return this;
    }

    public FDSNStationQueryParams clearEndAfter() {
        this.clearParam(ENDAFTER);
        return this;
    }

    public FDSNStationQueryParams setEndAfter(Instant value) {
        this.setParam(ENDAFTER, value);
        return this;
    }

    public FDSNStationQueryParams clearNetwork() {
        this.clearParam(NETWORK);
        return this;
    }

    public FDSNStationQueryParams setNetwork(String[] value) {
        this.clearNetwork();
        for (String v : value) {
            this.appendToNetwork(v);
        }
        return this;
    }

    public FDSNStationQueryParams appendToNetwork(String value) {
        this.appendToParam(NETWORK, value);
        return this;
    }

    public FDSNStationQueryParams clearStation() {
        this.clearParam("station");
        return this;
    }

    public FDSNStationQueryParams setStation(String[] value) {
        this.clearStation();
        for (String v : value) {
            this.appendToStation(v);
        }
        return this;
    }

    public FDSNStationQueryParams appendToStation(String value) {
        this.appendToParam("station", value);
        return this;
    }

    public FDSNStationQueryParams clearLocation() {
        this.clearParam(LOCATION);
        return this;
    }

    public FDSNStationQueryParams setLocation(String[] value) {
        this.clearLocation();
        for (String v : value) {
            this.appendToLocation(v);
        }
        return this;
    }

    public FDSNStationQueryParams appendToLocation(String value) {
        if (value == null || "".equals(value.trim())) {
            value = "--";
        }
        this.appendToParam(LOCATION, value);
        return this;
    }

    public FDSNStationQueryParams clearChannel() {
        this.clearParam(CHANNEL);
        return this;
    }

    public FDSNStationQueryParams setChannel(String[] value) {
        this.clearChannel();
        for (String v : value) {
            this.appendToChannel(v);
        }
        return this;
    }

    public FDSNStationQueryParams appendToChannel(String value) {
        this.appendToParam(CHANNEL, value);
        return this;
    }

    public FDSNStationQueryParams clearMinLatitude() {
        this.clearParam(MINLATITUDE);
        return this;
    }

    public FDSNStationQueryParams setMinLatitude(float value) {
        this.setParam(MINLATITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearMaxLatitude() {
        this.clearParam(MAXLATITUDE);
        return this;
    }

    public FDSNStationQueryParams setMaxLatitude(float value) {
        this.setParam(MAXLATITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearMinLongitude() {
        this.clearParam(MINLONGITUDE);
        return this;
    }

    public FDSNStationQueryParams setMinLongitude(float value) {
        this.setParam(MINLONGITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearMaxLongitude() {
        this.clearParam(MAXLONGITUDE);
        return this;
    }

    public FDSNStationQueryParams setMaxLongitude(float value) {
        this.setParam(MAXLONGITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearLatitude() {
        this.clearParam(LATITUDE);
        return this;
    }

    public FDSNStationQueryParams setLatitude(float value) {
        this.setParam(LATITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearLongitude() {
        this.clearParam(LONGITUDE);
        return this;
    }

    public FDSNStationQueryParams setLongitude(float value) {
        this.setParam(LONGITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearMinRadius() {
        this.clearParam(MINRADIUS);
        return this;
    }

    public FDSNStationQueryParams setMinRadius(float value) {
        this.setParam(MINRADIUS, value);
        return this;
    }

    public FDSNStationQueryParams clearMaxRadius() {
        this.clearParam(MAXRADIUS);
        return this;
    }

    public FDSNStationQueryParams setMaxRadius(float value) {
        this.setParam(MAXRADIUS, value);
        return this;
    }

    public FDSNStationQueryParams clearLevel() {
        this.clearParam(LEVEL);
        return this;
    }

    public FDSNStationQueryParams setLevel(String value) {
        this.setParam(LEVEL, value);
        return this;
    }

    public FDSNStationQueryParams clearIncludeRestricted() {
        this.clearParam(INCLUDERESTRICTED);
        return this;
    }

    public FDSNStationQueryParams setIncludeRestricted(boolean value) {
        this.setParam(INCLUDERESTRICTED, value);
        return this;
    }

    public FDSNStationQueryParams clearIncludeAvailability() {
        this.clearParam(INCLUDEAVAILABILITY);
        return this;
    }

    public FDSNStationQueryParams setIncludeAvailability(boolean value) {
        this.setParam(INCLUDEAVAILABILITY, value);
        return this;
    }

    public FDSNStationQueryParams clearMatchTimeseries() {
        this.clearParam(MATCHTIMESERIES);
        return this;
    }

    public FDSNStationQueryParams setMatchTimeseries(boolean value) {
        this.setParam(MATCHTIMESERIES, value);
        return this;
    }

    public FDSNStationQueryParams clearUpdatedAfter() {
        this.clearParam(UPDATEDAFTER);
        return this;
    }

    public FDSNStationQueryParams setUpdatedAfter(Instant value) {
        this.setParam(UPDATEDAFTER, value);
        return this;
    }

    public FDSNStationQueryParams boxArea(BoxArea box) {
        return this.area(box.south, box.north, box.west, box.east);
    }

    public FDSNStationQueryParams area(float minLat, float maxLat, float minLon, float maxLon) {
        return this.setMinLatitude(minLat).setMaxLatitude(maxLat).setMinLongitude(minLon).setMaxLongitude(maxLon);
    }

    public FDSNStationQueryParams ring(float lat, float lon, float maxRadius) {
        return this.setLatitude(lat).setLongitude(lon).setMaxRadius(maxRadius);
    }

    public FDSNStationQueryParams donut(DonutArea donut) {
        return this.ring(donut.latitude, donut.longitude, donut.maxradius).setMinRadius(donut.minradius);
    }

    @Override
    public String getServiceName() {
        return "station";
    }
}

