/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.Outputs;
import edu.sc.seis.TauP.PhaseName;
import edu.sc.seis.TauP.PlotTicks;
import edu.sc.seis.TauP.ReflTransAxisType;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.cmdline.args.ColoringArgs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SvgUtil {
    public static void xyplotScriptBeginning(PrintWriter out, String toolName, List<String> cmdLineArgs, float pixelWidth, int plotOffset, List<String> colorList) {
        SvgUtil.xyplotScriptBeginning(out, toolName, cmdLineArgs, pixelWidth, plotOffset, colorList, "", null);
    }

    public static void xyplotScriptBeginning(PrintWriter out, String toolName, List<String> cmdLineArgs, float pixelWidth, int plotOffset, List<String> colorList, String extraCSS) {
        SvgUtil.xyplotScriptBeginning(out, toolName, cmdLineArgs, pixelWidth, plotOffset, colorList, extraCSS, null);
    }

    public static void xyplotScriptBeginning(PrintWriter out, String toolName, List<String> cmdLineArgs, float pixelWidth, int plotOffset, List<String> colorList, CharSequence extraCSS, double[] minmax) {
        SvgUtil.xyplotScriptBeginning(out, toolName, cmdLineArgs, pixelWidth, plotOffset, colorList, extraCSS, minmax, "");
    }

    public static void xyplotScriptBeginning(PrintWriter out, String toolName, List<String> cmdLineArgs, float pixelWidth, int plotOffset, List<String> colorList, CharSequence extraCSS, double[] minmax, CharSequence extraDefs) {
        StringBuffer css = new StringBuffer();
        css.append(String.valueOf(extraCSS) + "\n");
        StringBuffer stdcss = SvgUtil.loadStandardCSS();
        css.append(String.valueOf(stdcss) + "\n");
        css.append(String.valueOf(SvgUtil.createCSSColors("g.autocolor", List.of("stroke"), colorList)) + "\n");
        css.append(String.valueOf(SvgUtil.createCSSColors(".autocolor.phaselabel", List.of("fill"), colorList)) + "\n");
        css.append(String.valueOf(SvgUtil.createCSSColors(".autocolor.legend", List.of("fill"), colorList)) + "\n");
        out.println("<svg version=\"1.1\" baseProfile=\"full\" xmlns=\"http://www.w3.org/2000/svg\" ");
        out.println("     viewBox=\"" + -1 * plotOffset + " " + -1 * plotOffset + " " + (pixelWidth + (float)plotOffset) + " " + (pixelWidth + (float)plotOffset) + "\"");
        out.println("     >");
        out.println("  <metadata>");
        SvgUtil.taupMetadata(out, toolName, cmdLineArgs, minmax);
        out.println("  </metadata>");
        out.println("  <defs>");
        out.println("    <style type=\"text/css\"><![CDATA[");
        out.println(css);
        out.println("    ]]></style>");
        out.println("  <clipPath id=\"curve_clip\">");
        out.println("    <rect x=\"-1\" y=\"-1\" width=\"" + (pixelWidth - (float)(2 * plotOffset) + 1.0f) + "\" height=\"" + (pixelWidth - (float)(2 * plotOffset) + 1.0f) + "\"/>");
        out.println("  </clipPath>");
        if (extraDefs.length() > 0) {
            out.println(extraDefs);
        }
        out.println("  </defs>");
        out.println("<!-- draw axis and label distances.-->");
        out.println();
    }

    /*
     * WARNING - void declaration
     */
    public static void taupMetadata(PrintWriter out, String cmd, List<String> args, double[] minmax) {
        out.println("    <taup>");
        out.print("      <command>");
        out.print(cmd + " ");
        for (String string : args) {
            void var5_5;
            if (string.startsWith("--")) {
                String string2 = "&#45;&#45;" + string.substring(2);
            }
            out.print((String)var5_5 + " ");
        }
        out.println("</command>");
        out.println("      <version>" + BuildVersion.getVersion() + "</version>");
        out.println("      <a href=\"https://github.com/crotwell/TauP\">https://github.com/crotwell/TauP</a>");
        if (minmax != null && minmax.length == 4) {
            out.println("    <minmax xmin=\"" + minmax[0] + "\" xmax=\"" + minmax[1] + "\" ymin=\"" + minmax[2] + "\" ymax=\"" + minmax[3] + "\" />");
        }
        out.println("    </taup>");
    }

    public static void taupMetadataGMT(PrintWriter out, String cmd, List<String> args, double[] minmax) {
        out.println("#");
        out.println("# Generated by:");
        out.print("# ");
        out.print(cmd + " ");
        for (String s : args) {
            out.print(s + " ");
        }
        out.println();
        out.println("# The TauP Toolkit");
        out.println("# version " + BuildVersion.getVersion());
        out.println("# https://github.com/crotwell/TauP");
        out.println("#");
        out.println("# for use with GMT6, modern syntax");
        out.println("# https://docs.generic-mapping-tools.org/latest/reference/introduction.html#modern-and-classic-mode");
        out.println("#");
        if (minmax != null && minmax.length == 4) {
            out.println("#     xmin=\"" + minmax[0] + "\" xmax=\"" + minmax[1] + "\" ymin=\"" + minmax[2] + "\" ymax=\"" + minmax[3]);
        }
        out.println("#");
    }

    public static void createXYAxes(PrintWriter out, double minX, double maxX, int numXTicks, boolean xEndFixed, double minY, double maxY, int numYTicks, boolean yEndFixed, float pixelWidth, float margin, String title, String xLabel, String yLabel) {
        float plotWidth = pixelWidth - 2.0f * margin;
        float tick_length = 10.0f;
        float text_height = 12.0f;
        ArrayList<Double> xTicks = PlotTicks.getTicks(minX, maxX, numXTicks, xEndFixed);
        ArrayList<Double> yTicks = PlotTicks.getTicks(minY, maxY, numYTicks, yEndFixed);
        out.println("<text class=\"title\" x=\"" + (pixelWidth / 2.0f - margin) + "\" y=\"0\">" + title + "</text>");
        out.println("<g> <!-- y axis -->");
        int yLabel_y = Math.round(plotWidth / 2.0f);
        int yLabel_x = Math.round(-0.8f * margin);
        out.println("<g  >");
        out.println("  <text font-size=\"14\" transform=\"translate(" + yLabel_x + ", " + yLabel_y + ") rotate(-90 )\" dy=\".75em\" text-anchor=\"middle\" class=\"ylabel\" >" + yLabel + "</text>");
        out.println("</g>");
        out.println("<line  class=\"tick\" x1=\"0\" y1=\"0\" x2=\"0\" y2=\"" + plotWidth + "\" />");
        for (double tick : yTicks) {
            float tick_pixel = maxY > minY ? (float)((tick - minY) / (maxY - minY) * (double)plotWidth) : (float)((minY - tick) / (minY - maxY) * (double)plotWidth);
            String tick_text = "" + (float)tick;
            out.println("<text class=\"ytick\" font-size=\"12\" x=\"" + (-1.0f * tick_length - 2.0f) + "\" y=\"" + (plotWidth - tick_pixel) + "\">" + tick_text + "</text>");
            out.println("<line class=\"tick\" x1=\"0\" y1=\"" + (plotWidth - tick_pixel) + "\" x2=\"-" + tick_length + "\" y2=\"" + (plotWidth - tick_pixel) + "\" />");
        }
        out.println("</g> <!-- y axis end-->");
        out.println("<g> <!-- x axis -->");
        out.println("<text class=\"xlabel\" font-size=\"14\" x=\"" + plotWidth / 2.0f + "\" y=\"" + (2.2 * (double)text_height + (double)tick_length + (double)plotWidth) + "\">" + xLabel + "</text>");
        out.println("<line class=\"tick\" x1=\"0\" y1=\"" + plotWidth + "\" x2=\"" + plotWidth + "\" y2=\"" + plotWidth + "\" />");
        for (double tick : xTicks) {
            double tick_pixel = maxX > minX ? (tick - minX) / (maxX - minX) * (double)plotWidth : (minX - tick) / (minX - maxX) * (double)plotWidth;
            String tick_text = "" + (float)tick;
            out.println("<text class=\"xtick\" font-size=\"12\" x=\"" + tick_pixel + "\" y=\"" + (text_height + tick_length + plotWidth) + "\">" + tick_text + "</text>");
            out.println("<line class=\"tick\" x1=\"" + tick_pixel + "\" y1=\"" + plotWidth + "\" x2=\"" + tick_pixel + "\" y2=\"" + (plotWidth + tick_length) + "\" />");
        }
        out.println("</g> <!-- x axis end-->");
    }

    public static void createLegend(PrintWriter out, List<String> labels, List<String> labelClasses, String outerGcss, float xtrans, float ytrans) {
        int lineLength = 10;
        int font_size = 12;
        int yoffset = font_size + 2;
        out.println("<g class=\"legend " + outerGcss + "\" transform=\"translate(" + xtrans + "," + ytrans + ")\"> <!-- legend -->");
        for (int i = 0; i < labels.size(); ++i) {
            String labelCSS = "tick";
            int y = i * yoffset;
            if (i < labelClasses.size()) {
                labelCSS = labelClasses.get(i);
            }
            out.println("<g class=\"" + labelCSS + "\">");
            out.println("<line class=\"" + labelCSS + "\" x1=\"0\" y1=\"" + y + "\" x2=\"" + lineLength + "\" y2=\"" + y + "\" />");
            out.println("<text class=\"" + labelCSS + "\" font-size=\"" + font_size + "\" x=\"" + (lineLength + 1) + "\" y=\"" + y + "\">" + labels.get(i) + "</text>");
            out.println("</g>");
        }
        out.println("</g> <!-- legend end-->");
    }

    public static void createPhaseLegend(PrintWriter out, List<SeismicPhase> phaseList, String outerGcss, float xtrans, float ytrans) {
        ArrayList<String> phasenameList = new ArrayList<String>();
        ArrayList<String> phaseClassList = new ArrayList<String>();
        for (SeismicPhase p : phaseList) {
            phasenameList.add(p.getName());
            phaseClassList.add(SvgUtil.classForPhase(p.getName()));
        }
        SvgUtil.createLegend(out, phasenameList, phaseClassList, outerGcss, xtrans, ytrans);
    }

    public static void createTimeStepLegend(PrintWriter out, double timeStep, double maxTime, String outerGcss, float xtrans, float ytrans) {
        ArrayList<String> labelList = new ArrayList<String>();
        ArrayList<String> classList = new ArrayList<String>();
        int i = 0;
        while ((double)i < maxTime / timeStep) {
            double timeVal = (double)i * timeStep;
            labelList.add(Outputs.formatTimeNoPad(timeVal) + " s");
            classList.add(SvgUtil.formatTimeForCss(timeVal));
            ++i;
        }
        SvgUtil.createLegend(out, labelList, classList, outerGcss, xtrans, ytrans);
    }

    public static void createWavetypeLegend(PrintWriter out, boolean withBoth, float xtrans, float ytrans) {
        ArrayList<String> waveLabels = new ArrayList<String>();
        ArrayList<String> waveLabelClasses = new ArrayList<String>();
        waveLabels.add("P Wave");
        waveLabelClasses.add("pwave");
        waveLabels.add("S Wave");
        waveLabelClasses.add("swave");
        if (withBoth) {
            waveLabels.add("Both");
            waveLabelClasses.add("both_p_swave");
        }
        SvgUtil.createLegend(out, waveLabels, waveLabelClasses, "", xtrans, ytrans);
    }

    public static StringBuffer createCSSColors(String selector, List<String> cssAttrList, List<String> colors) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < colors.size(); ++i) {
            out.append("        " + selector + " > :nth-child(" + colors.size() + "n+" + (i + 1) + ") {\n");
            for (String cssAttr : cssAttrList) {
                out.append("            " + cssAttr + ": " + colors.get(i) + ";\n");
            }
            out.append("        }\n");
        }
        return out;
    }

    public static StringBuffer createReflTransCSSColors() {
        StringBuffer out = new StringBuffer();
        HashMap<ReflTransAxisType, String> colors = new HashMap<ReflTransAxisType, String>();
        colors.put(ReflTransAxisType.Rpp, "blue");
        colors.put(ReflTransAxisType.RppEnergy, (String)colors.get((Object)ReflTransAxisType.Rpp));
        colors.put(ReflTransAxisType.RppPhase, (String)colors.get((Object)ReflTransAxisType.Rpp));
        colors.put(ReflTransAxisType.Rps, "green");
        colors.put(ReflTransAxisType.RpsEnergy, (String)colors.get((Object)ReflTransAxisType.Rps));
        colors.put(ReflTransAxisType.RpsPhase, (String)colors.get((Object)ReflTransAxisType.Rps));
        colors.put(ReflTransAxisType.Rsp, "mediumslateblue");
        colors.put(ReflTransAxisType.RspEnergy, (String)colors.get((Object)ReflTransAxisType.Rsp));
        colors.put(ReflTransAxisType.RspPhase, (String)colors.get((Object)ReflTransAxisType.Rsp));
        colors.put(ReflTransAxisType.Rss, "red");
        colors.put(ReflTransAxisType.RssEnergy, (String)colors.get((Object)ReflTransAxisType.Rss));
        colors.put(ReflTransAxisType.RssPhase, (String)colors.get((Object)ReflTransAxisType.Rss));
        colors.put(ReflTransAxisType.Rshsh, "orange");
        colors.put(ReflTransAxisType.RshshEnergy, (String)colors.get((Object)ReflTransAxisType.Rshsh));
        colors.put(ReflTransAxisType.RshshPhase, (String)colors.get((Object)ReflTransAxisType.Rshsh));
        colors.put(ReflTransAxisType.Tpp, "cyan");
        colors.put(ReflTransAxisType.TppEnergy, (String)colors.get((Object)ReflTransAxisType.Tpp));
        colors.put(ReflTransAxisType.TppPhase, (String)colors.get((Object)ReflTransAxisType.Tpp));
        colors.put(ReflTransAxisType.Tps, "gold");
        colors.put(ReflTransAxisType.TpsEnergy, (String)colors.get((Object)ReflTransAxisType.Tps));
        colors.put(ReflTransAxisType.TpsPhase, (String)colors.get((Object)ReflTransAxisType.Tps));
        colors.put(ReflTransAxisType.Tsp, "magenta");
        colors.put(ReflTransAxisType.TspEnergy, (String)colors.get((Object)ReflTransAxisType.Tsp));
        colors.put(ReflTransAxisType.TspPhase, (String)colors.get((Object)ReflTransAxisType.Tsp));
        colors.put(ReflTransAxisType.Tss, "grey");
        colors.put(ReflTransAxisType.TssEnergy, (String)colors.get((Object)ReflTransAxisType.Tss));
        colors.put(ReflTransAxisType.TssPhase, (String)colors.get((Object)ReflTransAxisType.Tss));
        colors.put(ReflTransAxisType.Tshsh, "violet");
        colors.put(ReflTransAxisType.TshshEnergy, (String)colors.get((Object)ReflTransAxisType.Tshsh));
        colors.put(ReflTransAxisType.TshshPhase, (String)colors.get((Object)ReflTransAxisType.Tshsh));
        colors.put(ReflTransAxisType.FreeRecFuncPr, "darkblue");
        colors.put(ReflTransAxisType.FreeRecFuncSvr, "firebrick");
        colors.put(ReflTransAxisType.FreeRecFuncPz, "cyan");
        colors.put(ReflTransAxisType.FreeRecFuncSvz, "magenta");
        colors.put(ReflTransAxisType.FreeRecFuncSh, "red");
        colors.put(ReflTransAxisType.RpAngle, "blue");
        colors.put(ReflTransAxisType.RsAngle, "firebrick");
        colors.put(ReflTransAxisType.TpAngle, "darkblue");
        colors.put(ReflTransAxisType.TsAngle, "magenta");
        ArrayList<ReflTransAxisType> allCoeff = new ArrayList<ReflTransAxisType>();
        allCoeff.addAll(ReflTransAxisType.allDisplacement);
        allCoeff.addAll(ReflTransAxisType.allEnergy);
        allCoeff.addAll(ReflTransAxisType.allFreeRF);
        allCoeff.addAll(ReflTransAxisType.allAngle);
        allCoeff.addAll(ReflTransAxisType.allPhase);
        for (ReflTransAxisType rt : allCoeff) {
            out.append("        ." + rt.name() + " {\n");
            out.append("          stroke: " + (String)colors.get((Object)rt) + ";\n");
            out.append("        }\n");
            out.append("        ." + rt.name() + ".label {\n");
            out.append("          stroke: " + (String)colors.get((Object)rt) + ";\n");
            out.append("          fill: " + (String)colors.get((Object)rt) + ";\n");
            out.append("        }\n");
            out.append("        .legend ." + rt.name() + " {\n");
            out.append("          stroke: " + (String)colors.get((Object)rt) + ";\n");
            out.append("          fill: " + (String)colors.get((Object)rt) + ";\n");
            out.append("        }\n");
            out.append("        .legend ." + rt.name() + " text {\n");
            out.append("          fill: " + (String)colors.get((Object)rt) + ";\n");
            out.append("          stroke: transparent;\n");
            out.append("        }\n");
        }
        return out;
    }

    public static StringBuffer loadStandardCSS() {
        StringBuffer out;
        block4: {
            out = new StringBuffer();
            String packageName = "/edu/sc/seis/TauP/svg";
            String filename = "standard_svg_plot.css";
            try {
                Class<?> c = Class.forName("edu.sc.seis.TauP.SvgUtil");
                InputStream in = c.getResourceAsStream(packageName + "/" + filename);
                if (in != null) {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        out.append(line + "\n");
                    }
                    break block4;
                }
                throw new RuntimeException("Standard CSS file not found in jar: " + packageName + "/" + filename);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return out;
    }

    public static StringBuffer createSurfaceWaveCSS(List<PhaseName> phaseNames) {
        StringBuffer out = new StringBuffer();
        for (PhaseName phase : phaseNames) {
            if (!phase.getName().endsWith("kmps")) continue;
            out.append("        ." + SvgUtil.classForPhase(phase.getName()) + " {\n");
            out.append("          stroke-width: 5px;\n");
            out.append("        }\n");
        }
        return out;
    }

    public static String classForPhase(String phase) {
        return "phase_" + phase;
    }

    public static StringBuffer createPhaseColorCSS(List<PhaseName> phaseNames, ColoringArgs coloringArgs) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < phaseNames.size(); ++i) {
            String color = coloringArgs.colorForIndex(i);
            PhaseName phaseName = phaseNames.get(i);
            String phaseClass = SvgUtil.classForPhase(phaseName.getName());
            out.append("        ." + phaseClass + " {\n");
            out.append("          stroke: " + color + ";\n");
            out.append("        }\n");
            out.append("        circle." + phaseClass + " {\n");
            out.append("          fill: " + color + ";\n");
            out.append("          stroke: " + color + ";\n");
            out.append("        }\n");
            out.append("        ." + phaseClass + ".label {\n");
            out.append("          stroke: " + color + ";\n");
            out.append("          fill: " + color + ";\n");
            out.append("        }\n");
            out.append("        .legend ." + phaseClass + " line {\n");
            out.append("          stroke: " + color + ";\n");
            out.append("        }\n");
            out.append("        .legend ." + phaseClass + " text {\n");
            out.append("          fill: " + color + ";\n");
            out.append("          stroke: transparent;\n");
            out.append("        }\n");
            out.append("        .label text." + phaseClass + "{\n");
            out.append("          font: bold ;\n");
            out.append("          fill: " + color + ";\n");
            out.append("          stroke: transparent;\n");
            out.append("        }\n");
        }
        return out;
    }

    public static StringBuffer createNoneColorCSS(ColoringArgs coloringArgs) {
        String color = "darkgrey";
        StringBuffer extrtaCSS = new StringBuffer();
        HashMap<String, String> colors = coloringArgs.getWavetypeColors();
        for (String wavetype : colors.keySet()) {
            extrtaCSS.append("        polyline." + wavetype + " {\n");
            extrtaCSS.append("            stroke: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        circle." + wavetype + " {\n");
            extrtaCSS.append("            stroke: " + color + ";\n");
            extrtaCSS.append("            fill: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        ." + wavetype + ".label {\n");
            extrtaCSS.append("          stroke: " + color + ";\n");
            extrtaCSS.append("          fill: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        .legend ." + wavetype + " {\n");
            extrtaCSS.append("          stroke: " + color + ";\n");
            extrtaCSS.append("          fill: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        .legend ." + wavetype + " text {\n");
            extrtaCSS.append("          fill: " + color + ";\n");
            extrtaCSS.append("          stroke: transparent;\n");
            extrtaCSS.append("        }\n");
        }
        return extrtaCSS;
    }

    public static String formatTimeForCss(double timeVal) {
        return "time_" + Outputs.formatTimeNoPad(timeVal).trim().replaceAll("\\.", "_");
    }

    public static StringBuffer createTimeStepColorCSS(float timestep, float maxTime, ColoringArgs coloringArgs) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while ((float)i * timestep <= maxTime) {
            String timeLabel = SvgUtil.formatTimeForCss((float)i * timestep);
            String color = coloringArgs.colorForIndex(i);
            out.append("        ." + timeLabel + " {\n");
            out.append("          stroke: " + color + ";\n");
            out.append("        }\n");
            out.append("        circle." + timeLabel + " {\n");
            out.append("          stroke: " + color + ";\n");
            out.append("          fill: " + color + ";\n");
            out.append("        }\n");
            out.append("        ." + timeLabel + ".label {\n");
            out.append("          stroke: " + color + ";\n");
            out.append("          fill: " + color + ";\n");
            out.append("        }\n");
            out.append("        .legend ." + timeLabel + " {\n");
            out.append("          stroke: " + color + ";\n");
            out.append("          fill: " + color + ";\n");
            out.append("        }\n");
            out.append("        .legend ." + timeLabel + " text {\n");
            out.append("          fill: " + color + ";\n");
            out.append("          stroke: transparent;\n");
            out.append("        }\n");
            ++i;
        }
        return out;
    }

    public static void startAutocolorG(PrintWriter writer) {
        writer.println("  <g class=\"autocolor\" >");
    }

    public static void endAutocolorG(PrintWriter writer) {
        writer.println("  </g> <!-- end autocolor -->");
    }

    public static StringBuffer resizeLabels(int fontSize) {
        StringBuffer extrtaCSS = new StringBuffer();
        extrtaCSS.append("        text.label {\n");
        extrtaCSS.append("            font-size: " + fontSize + "px;\n");
        extrtaCSS.append("        }\n");
        extrtaCSS.append("        g.phasename text {\n");
        extrtaCSS.append("            font-size: " + fontSize + "px;\n");
        extrtaCSS.append("        }\n");
        return extrtaCSS;
    }

    public static StringBuffer createWaveTypeColorCSS(ColoringArgs coloringArgs) {
        StringBuffer extrtaCSS = new StringBuffer();
        HashMap<String, String> colors = coloringArgs.getWavetypeColors();
        for (String wavetype : colors.keySet()) {
            String color = colors.get(wavetype);
            extrtaCSS.append("        g." + wavetype + " polyline {\n");
            extrtaCSS.append("            stroke: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        g." + wavetype + " circle {\n");
            extrtaCSS.append("            stroke: " + color + ";\n");
            extrtaCSS.append("            fill: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        polyline." + wavetype + " {\n");
            extrtaCSS.append("            stroke: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        circle." + wavetype + " {\n");
            extrtaCSS.append("            stroke: " + color + ";\n");
            extrtaCSS.append("            fill: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        ." + wavetype + ".label {\n");
            extrtaCSS.append("          stroke: " + color + ";\n");
            extrtaCSS.append("          fill: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        .legend ." + wavetype + " {\n");
            extrtaCSS.append("          stroke: " + color + ";\n");
            extrtaCSS.append("          fill: " + color + ";\n");
            extrtaCSS.append("        }\n");
            extrtaCSS.append("        .legend ." + wavetype + " text {\n");
            extrtaCSS.append("          fill: " + color + ";\n");
            extrtaCSS.append("          stroke: transparent;\n");
            extrtaCSS.append("        }\n");
        }
        return extrtaCSS;
    }
}

