/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.LinearInterpolation;
import edu.sc.seis.TauP.NoArrivalException;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.PhaseInteraction;
import edu.sc.seis.TauP.ProtoSeismicPhase;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseFactory;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.ShadowZone;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauBranch;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import edu.sc.seis.TauP.VelocityModelMaterial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleContigSeismicPhase
extends SimpleSeismicPhase {
    ProtoSeismicPhase proto;
    public transient boolean DEBUG;
    public transient boolean verbose = false;
    protected TauModel tMod;
    protected double sourceDepth;
    protected double receiverDepth;
    protected double[] dist;
    protected double[] time;
    protected double[] rayParams;
    protected double minRayParam;
    protected double maxRayParam;
    protected int maxRayParamIndex;
    protected int minRayParamIndex;
    protected double minDistance;
    protected double maxDistance;
    protected String name;
    protected String puristName;
    protected double refineDistToleranceRadian = 8.552113334772214E-5;
    protected int maxRecursion = 5;

    public SimpleContigSeismicPhase(ProtoSeismicPhase proto, double[] rayParams, double[] time, double[] dist, double minRayParam, double maxRayParam, int minRayParamIndex, int maxRayParamIndex, double minDistance, double maxDistance, boolean debug) {
        if (proto == null) {
            throw new IllegalArgumentException("proto cannot be null");
        }
        try {
            if (proto.isSuccessful()) {
                proto.validateSegList();
            }
        }
        catch (TauModelException e) {
            throw new RuntimeException(this.getName() + " fail validation:", e);
        }
        this.proto = proto;
        this.DEBUG = debug;
        this.name = proto.getName();
        this.tMod = proto.tMod;
        this.puristName = proto.getPuristName();
        this.sourceDepth = this.tMod != null ? this.tMod.getSourceDepth() : -1.0;
        this.receiverDepth = proto.receiverDepth;
        this.rayParams = rayParams;
        this.time = time;
        this.dist = dist;
        this.minRayParam = minRayParam;
        this.maxRayParam = maxRayParam;
        this.minRayParamIndex = minRayParamIndex;
        this.maxRayParamIndex = maxRayParamIndex;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
    }

    @Override
    public boolean phasesExistsInModel() {
        return this.getMaxRayParam() >= 0.0;
    }

    @Override
    public Arrival getEarliestArrival(double degrees) {
        return Arrival.getEarliestArrival(DistanceRay.ofDegrees(degrees).calcSimplePhase(this));
    }

    @Override
    public TauModel getTauModel() {
        return this.tMod;
    }

    @Override
    public double getMinDistanceDeg() {
        return this.getMinDistance() * 180.0 / Math.PI;
    }

    @Override
    public double getMinDistance() {
        return this.minDistance;
    }

    @Override
    public double getMaxDistanceDeg() {
        return this.getMaxDistance() * 180.0 / Math.PI;
    }

    @Override
    public double getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public double getMaxRayParam() {
        return this.maxRayParam;
    }

    @Override
    public double getMinRayParam() {
        return this.minRayParam;
    }

    @Override
    public int getMaxRayParamIndex() {
        return this.maxRayParamIndex;
    }

    @Override
    public int getMinRayParamIndex() {
        return this.minRayParamIndex;
    }

    @Override
    public double getMinTime() {
        if (this.time.length == 0) {
            return -1.0;
        }
        double v = this.time[0];
        for (double d : this.time) {
            v = Math.min(v, d);
        }
        return v;
    }

    @Override
    public double getMaxTime() {
        if (this.time.length == 0) {
            return -1.0;
        }
        double v = this.time[0];
        for (double d : this.time) {
            v = Math.max(v, d);
        }
        return v;
    }

    public ProtoSeismicPhase getProto() {
        return this.proto;
    }

    @Override
    public boolean isFail() {
        return this.proto.isFail;
    }

    @Override
    public String failReason() {
        return this.proto.failReason;
    }

    public TauModel gettMod() {
        return this.tMod;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPuristName() {
        return this.puristName;
    }

    @Override
    public double getSourceDepth() {
        return this.sourceDepth;
    }

    @Override
    public double getReceiverDepth() {
        return this.receiverDepth;
    }

    @Override
    public List<List<SeismicPhaseSegment>> getListPhaseSegments() {
        return List.of(this.getPhaseSegments());
    }

    public List<SeismicPhaseSegment> getPhaseSegments() {
        return Collections.unmodifiableList(this.proto.segmentList);
    }

    @Override
    public int countFlatLegs() {
        return this.proto.countFlatLegs();
    }

    @Override
    public double getRayParams(int i) {
        return this.rayParams[i];
    }

    @Override
    public double[] getRayParams() {
        return (double[])this.rayParams.clone();
    }

    @Override
    public double getDist(int i) {
        return this.dist[i];
    }

    @Override
    public double[] getDist() {
        return (double[])this.dist.clone();
    }

    @Override
    public double getTime(int i) {
        return this.time[i];
    }

    @Override
    public double[] getTime() {
        return (double[])this.time.clone();
    }

    @Override
    public double getTau(int i) {
        return this.time[i] - this.rayParams[i] * this.dist[i];
    }

    @Override
    public double[] getTau() {
        double[] tau = new double[this.dist.length];
        for (int i = 0; i < this.dist.length; ++i) {
            tau[i] = this.time[i] - this.rayParams[i] * this.dist[i];
        }
        return tau;
    }

    @Override
    public boolean hasArrivals() {
        return this.dist != null && this.dist.length != 0;
    }

    @Override
    public List<ShadowZone> getShadowZones() {
        return new ArrayList<ShadowZone>();
    }

    @Override
    public List<Arrival> calcTimeExactDistance(double searchDist) {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (int rayNum = 0; rayNum < this.dist.length - 1; ++rayNum) {
            if (searchDist == this.dist[rayNum + 1] && rayNum + 1 != this.dist.length - 1 || !((this.dist[rayNum] - searchDist) * (searchDist - this.dist[rayNum + 1]) >= 0.0) || this.rayParams[rayNum] == this.rayParams[rayNum + 1] && this.getMaxRayParam() > this.getMinRayParam()) continue;
            if (this.DEBUG) {
                Alert.debug("SeismicPhase " + this.name + ", found arrival:\ndist " + (float)(57.29577951308232 * this.dist[rayNum]) + " " + (float)(57.29577951308232 * searchDist) + " " + (float)(57.29577951308232 * this.dist[rayNum + 1]));
                Alert.debug("time " + this.time[rayNum] + " --  " + this.time[rayNum + 1]);
            }
            arrivals.add(this.refineArrival(rayNum, searchDist, this.refineDistToleranceRadian, this.maxRecursion));
        }
        return arrivals;
    }

    @Override
    public Arrival createArrivalAtIndex(int rayNum) {
        double dRPdDist = 0.0;
        if (rayNum < 0 || rayNum >= this.rayParams.length) {
            throw new ArrayIndexOutOfBoundsException("ask for raynum=" + rayNum + ", but array is length " + this.rayParams.length);
        }
        if (this.rayParams.length > 1) {
            dRPdDist = rayNum == 0 ? (this.getRayParams(rayNum) - this.getRayParams(rayNum + 1)) / (this.getDist(rayNum) - this.getDist(rayNum + 1)) : (rayNum == this.rayParams.length - 1 ? (this.getRayParams(rayNum) - this.getRayParams(rayNum - 1)) / (this.getDist(rayNum) - this.getDist(rayNum - 1)) : ((this.getRayParams(rayNum) - this.getRayParams(rayNum - 1)) / (this.getDist(rayNum) - this.getDist(rayNum - 1)) + (this.getRayParams(rayNum) - this.getRayParams(rayNum + 1)) / (this.getDist(rayNum) - this.getDist(rayNum + 1))) / 2.0);
        }
        return new Arrival(this, this, this.getTime(rayNum), this.getDist(rayNum), this.getRayParams(rayNum), rayNum, dRPdDist);
    }

    public Arrival refineArrival(int rayNum, double distRadian, double distTolRadian, int maxRecursion) {
        Arrival left = this.createArrivalAtIndex(rayNum);
        Arrival right = this.createArrivalAtIndex(rayNum + 1);
        return this.refineArrival(left, right, distRadian, distTolRadian, maxRecursion);
    }

    public Arrival refineArrival(Arrival leftEstimate, Arrival rightEstimate, double searchDist, double distTolRadian, int maxRecursion) {
        Arrival linInterp = this.linearInterpArrival(searchDist, leftEstimate, rightEstimate);
        if (maxRecursion <= 0 || this.countFlatLegs() > 0) {
            return linInterp;
        }
        if (leftEstimate.getRayParam() == rightEstimate.getRayParam()) {
            return linInterp;
        }
        if (linInterp.getRayParam() == leftEstimate.getRayParam()) {
            return leftEstimate;
        }
        if (linInterp.getRayParam() == rightEstimate.getRayParam()) {
            return rightEstimate;
        }
        if (this.DEBUG) {
            Alert.debug("Phase: " + String.valueOf(this));
            Alert.debug("Refine: " + maxRecursion + "\nleft:  " + String.valueOf(leftEstimate) + "\nright: " + String.valueOf(rightEstimate) + "\nlinInterp: " + String.valueOf(linInterp));
        }
        if (leftEstimate.getRayParam() < this.minRayParam || this.maxRayParam < leftEstimate.getRayParam()) {
            throw new IllegalArgumentException("Left Ray param " + leftEstimate.getRayParam() + " is outside range for this phase: " + this.getName() + " min=" + this.minRayParam + " max=" + this.maxRayParam);
        }
        if (rightEstimate.getRayParam() < this.minRayParam || this.maxRayParam < rightEstimate.getRayParam()) {
            throw new IllegalArgumentException("Right Ray param " + rightEstimate.getRayParam() + " is outside range for this phase: " + this.getName() + " min=" + this.minRayParam + " max=" + this.maxRayParam);
        }
        try {
            Arrival shoot = this.shootRay(linInterp.getRayParam());
            double distError = Math.abs(shoot.getDist() - linInterp.getDist());
            if ((leftEstimate.getDist() - searchDist) * (searchDist - shoot.getDist()) > 0.0) {
                if (distError < distTolRadian) {
                    return this.linearInterpArrival(searchDist, leftEstimate, shoot);
                }
                return this.refineArrival(leftEstimate, shoot, searchDist, distTolRadian, maxRecursion - 1);
            }
            if (distError < distTolRadian) {
                return this.linearInterpArrival(searchDist, shoot, rightEstimate);
            }
            return this.refineArrival(shoot, rightEstimate, searchDist, distTolRadian, maxRecursion - 1);
        }
        catch (SlownessModelException | TauModelException e) {
            throw new RuntimeException("Should not happen: " + this.getName(), e);
        }
    }

    @Override
    public SimpleContigSeismicPhase interpolatePhase(double maxDeltaDeg) {
        return this.interpolateSimplePhase(maxDeltaDeg);
    }

    @Override
    public SimpleContigSeismicPhase interpolateSimplePhase(double maxDeltaDeg) {
        int numToAdd = 0;
        double maxDeltaRadian = maxDeltaDeg * (Math.PI / 180);
        for (int i = 0; i < this.rayParams.length - 1; ++i) {
            if (!(Math.abs(this.dist[i] - this.dist[i + 1]) > maxDeltaRadian)) continue;
            numToAdd += (int)Math.ceil(Math.abs(this.dist[i + 1] - this.dist[i]) / maxDeltaRadian) - 1;
        }
        double[] out_rayParams = new double[this.rayParams.length + numToAdd];
        double[] out_dist = new double[this.rayParams.length + numToAdd];
        double[] out_time = new double[this.rayParams.length + numToAdd];
        int shift = 0;
        for (int i = 0; i < this.rayParams.length - 1; ++i) {
            out_dist[i + shift] = this.dist[i];
            out_rayParams[i + shift] = this.rayParams[i];
            out_time[i + shift] = this.time[i];
            int numRPs = (int)Math.ceil(Math.abs(this.dist[i + 1] - this.dist[i]) / maxDeltaRadian);
            double deltaDist = (this.dist[i + 1] - this.dist[i]) / (double)numRPs;
            for (int j = 1; j < numRPs; ++j) {
                List<Arrival> aList = DistanceRay.ofExactRadians(this.dist[i] + (double)j * deltaDist).calcSimplePhase(this);
                for (Arrival a : aList) {
                    if (!(this.rayParams[i + 1] <= a.getRayParam()) || !(a.getRayParam() <= this.rayParams[i])) continue;
                    out_dist[i + ++shift] = a.getDist();
                    out_time[i + shift] = a.getTime();
                    out_rayParams[i + shift] = a.getRayParam();
                    break;
                }
                if (!aList.isEmpty()) continue;
                throw new RuntimeException("Bad calc for interp " + j + " " + (this.dist[i] + (double)j * deltaDist) * 57.29577951308232 + " for " + this.getName());
            }
        }
        out_dist[this.rayParams.length - 1 + shift] = this.dist[this.rayParams.length - 1];
        out_rayParams[this.rayParams.length - 1 + shift] = this.rayParams[this.rayParams.length - 1];
        out_time[this.rayParams.length - 1 + shift] = this.time[this.rayParams.length - 1];
        SimpleContigSeismicPhase out = new SimpleContigSeismicPhase(this.proto, out_rayParams, out_time, out_dist, this.minRayParam, this.maxRayParam, this.minRayParamIndex, this.maxRayParamIndex, this.minDistance, this.maxDistance, false);
        if (shift != numToAdd) {
            throw new RuntimeException("shifty not numAdd " + shift + " " + numToAdd);
        }
        return out;
    }

    @Override
    public Arrival shootRay(double rayParam) throws SlownessModelException, TauModelException {
        if (this.countFlatLegs() > 0 && rayParam != this.getMinRayParam()) {
            throw new TauModelException("Unable to shoot ray in non-body, head, diffracted waves: " + this.getName());
        }
        if (rayParam < this.minRayParam || this.maxRayParam < rayParam) {
            throw new TauModelException("Ray param " + rayParam + " is outside range for this phase: " + this.getName() + " min=" + this.minRayParam + " max=" + this.maxRayParam);
        }
        int rayParamIndex = -1;
        for (rayParamIndex = 0; rayParamIndex < this.rayParams.length - 1 && this.rayParams[rayParamIndex + 1] >= rayParam; ++rayParamIndex) {
        }
        List<TauBranch> branchList = SeismicPhaseFactory.calcBranchSeqForRayparam(this.proto, rayParam);
        TimeDist sum = new TimeDist(rayParam, 0.0, 0.0, this.getSourceDepth());
        ArrayList<TimeDist> pierce = new ArrayList<TimeDist>();
        pierce.add(sum);
        for (TauBranch tb : branchList) {
            TimeDist td = tb.calcTimeDist(rayParam, true);
            sum = sum.add(td);
            pierce.add(sum);
        }
        double dRPdDist = (rayParam - this.rayParams[rayParamIndex]) / (sum.getDistRadian() - this.dist[rayParamIndex]);
        Arrival a = new Arrival(this, this, pierce, rayParamIndex, dRPdDist);
        return a;
    }

    private Arrival linearInterpArrival(double searchDist, Arrival left, Arrival right) {
        double dRPdDist;
        double arrivalTime;
        if (left.getDist() == searchDist) {
            return left;
        }
        if (right.getDist() == searchDist) {
            return right;
        }
        double arrivalRayParam = (searchDist - right.getDist()) * (left.getRayParam() - right.getRayParam()) / (left.getDist() - right.getDist()) + right.getRayParam();
        if (this.maxRayParam == this.minRayParam) {
            arrivalTime = LinearInterpolation.linearInterp(left.getDist(), left.getTime(), right.getDist(), right.getTime(), searchDist);
            dRPdDist = 0.0;
        } else if (Math.abs(searchDist - left.getDist()) < Math.abs(searchDist - right.getDist())) {
            arrivalTime = left.getTime() + arrivalRayParam * (searchDist - left.getDist());
            dRPdDist = (left.getRayParam() - arrivalRayParam) / (left.getDist() - searchDist);
        } else {
            arrivalTime = right.getTime() + arrivalRayParam * (searchDist - right.getDist());
            dRPdDist = (right.getRayParam() - arrivalRayParam) / (right.getDist() - searchDist);
        }
        if (Double.isNaN(arrivalTime)) {
            throw new RuntimeException("Time is NaN, search " + searchDist + " leftDist " + left.getDist() + " leftTime " + left.getTime() + "  rightDist " + right.getDist() + "  rightTime " + right.getTime());
        }
        return new Arrival(this, this, arrivalTime, searchDist, arrivalRayParam, left.getRayParamIndex(), dRPdDist);
    }

    @Override
    public double calcRayParamForTakeoffAngle(double takeoffDegree) throws NoArrivalException {
        double rayParam;
        if (takeoffDegree < 0.0 || takeoffDegree > 180.0) {
            throw new IllegalArgumentException("Takeoff angle should be 0 to 180, but was " + takeoffDegree);
        }
        if (this.getPhaseSegments().isEmpty()) {
            throw new NoArrivalException("No phase segments for " + this.getName());
        }
        boolean firstIsPWave = this.getInitialPhaseSegment().isPWave;
        try {
            rayParam = SimpleContigSeismicPhase.calcRayParamForTakeoffAngleInModel(takeoffDegree, firstIsPWave, this.tMod, this.getInitialPhaseSegment().isDownGoing);
        }
        catch (NoSuchLayerException | SlownessModelException e) {
            throw new RuntimeException("Should not happen", e);
        }
        return rayParam;
    }

    public static double calcRayParamForTakeoffAngleInModel(double takeoffDegree, boolean isPWave, TauModel tMod, boolean isDownGoing) throws NoSuchLayerException, SlownessModelException {
        SlownessLayer sLayer;
        int layerNum;
        if (isDownGoing && takeoffDegree > 90.0 || !isDownGoing && takeoffDegree < 90.0) {
            throw new SlownessModelException("Phase downgoing and takeoff different up/down " + isDownGoing + " " + takeoffDegree);
        }
        if (isDownGoing) {
            layerNum = tMod.getSlownessModel().layerNumberBelow(tMod.getSourceDepth(), isPWave);
            sLayer = tMod.getSlownessModel().getSlownessLayer(layerNum, isPWave);
        } else {
            layerNum = tMod.getSlownessModel().layerNumberAbove(tMod.getSourceDepth(), isPWave);
            sLayer = tMod.getSlownessModel().getSlownessLayer(layerNum, isPWave);
        }
        double rayParam = sLayer.evaluateAt_bullen(tMod.getSourceDepth(), tMod.radiusOfEarth) * Math.sin(takeoffDegree * (Math.PI / 180));
        return rayParam;
    }

    @Override
    public double calcRayParamForIncidentAngle(double incidentDegree) throws NoArrivalException {
        double rayParam;
        if (incidentDegree < 0.0 || incidentDegree > 180.0) {
            throw new IllegalArgumentException("Takeoff angle should be 0 to 180, but was " + incidentDegree);
        }
        if (this.getPhaseSegments().isEmpty()) {
            throw new NoArrivalException("No phase segments for " + this.getName());
        }
        boolean firstIsPWave = this.getFinalPhaseSegment().isPWave;
        try {
            rayParam = SimpleContigSeismicPhase.calcRayParamForIncidentAngleInModel(incidentDegree, firstIsPWave, this.getProto(), this.getFinalPhaseSegment().isDownGoing);
        }
        catch (NoSuchLayerException | SlownessModelException e) {
            throw new RuntimeException("Should not happen", e);
        }
        return rayParam;
    }

    public static double calcRayParamForIncidentAngleInModel(double incidentDegree, boolean isPWave, ProtoSeismicPhase proto, boolean isDownGoing) throws NoSuchLayerException, SlownessModelException {
        SlownessLayer sLayer;
        int layerNum;
        if (isDownGoing && incidentDegree < 90.0 || !isDownGoing && incidentDegree > 90.0) {
            throw new SlownessModelException("Phase ends downgoing and incident different up/down " + isDownGoing + " " + incidentDegree);
        }
        if (!isDownGoing) {
            layerNum = proto.tMod.getSlownessModel().layerNumberBelow(proto.receiverDepth, isPWave);
            sLayer = proto.tMod.getSlownessModel().getSlownessLayer(layerNum, isPWave);
        } else {
            layerNum = proto.tMod.getSlownessModel().layerNumberAbove(proto.receiverDepth, isPWave);
            sLayer = proto.tMod.getSlownessModel().getSlownessLayer(layerNum, isPWave);
        }
        double rayParam = sLayer.evaluateAt_bullen(proto.receiverDepth, proto.tMod.radiusOfEarth) * Math.sin(incidentDegree * (Math.PI / 180));
        return rayParam;
    }

    @Override
    public double velocityAtSource() {
        try {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            VelocityModelMaterial firstLeg = this.getInitialPhaseSegment().isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY;
            double takeoffVelocity = this.getInitialPhaseSegment().isDownGoing ? vMod.evaluateBelow(this.sourceDepth, firstLeg) : vMod.evaluateAbove(this.sourceDepth, firstLeg);
            return takeoffVelocity;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    @Override
    public double velocityAtReceiver() {
        try {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            VelocityModelMaterial lastLeg = this.getPhaseSegments().get((int)(this.getPhaseSegments().size() - 1)).isPWave ? VelocityModelMaterial.P_VELOCITY : VelocityModelMaterial.S_VELOCITY;
            double incidentVelocity = this.getPhaseSegments().get((int)(this.getPhaseSegments().size() - 1)).isDownGoing ? vMod.evaluateAbove(this.receiverDepth, lastLeg) : vMod.evaluateBelow(this.receiverDepth, lastLeg);
            return incidentVelocity;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    @Override
    public double densityAtSource() {
        try {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            double rho = this.getInitialPhaseSegment().isDownGoing ? vMod.evaluateAbove(this.sourceDepth, VelocityModelMaterial.DENSITY) : vMod.evaluateBelow(this.sourceDepth, VelocityModelMaterial.DENSITY);
            return rho;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    @Override
    public double densityAtReceiver() {
        try {
            VelocityModel vMod = this.getTauModel().getVelocityModel();
            double rho = this.getFinalPhaseSegment().isDownGoing ? vMod.evaluateAbove(this.receiverDepth, VelocityModelMaterial.DENSITY) : vMod.evaluateBelow(this.receiverDepth, VelocityModelMaterial.DENSITY);
            return rho;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    @Override
    public double calcTakeoffAngleDegree(double arrivalRayParam) {
        return this.calcTakeoffAngle(arrivalRayParam) * 57.29577951308232;
    }

    @Override
    public double calcTakeoffAngle(double arrivalRayParam) {
        if (this.name.endsWith("kmps")) {
            return 0.0;
        }
        double takeoffAngle = Math.asin(this.velocityAtSource() * arrivalRayParam / (this.getTauModel().getRadiusOfEarth() - this.sourceDepth));
        if (!Double.isFinite(takeoffAngle) && Math.abs(this.velocityAtSource() * arrivalRayParam - (this.getTauModel().getRadiusOfEarth() - this.sourceDepth)) < 0.05) {
            takeoffAngle = 1.5707963267948966;
        }
        if (!this.getInitialPhaseSegment().isDownGoing) {
            takeoffAngle = Math.PI - takeoffAngle;
        }
        return takeoffAngle;
    }

    @Override
    public double calcIncidentAngleDegree(double arrivalRayParam) {
        return this.calcIncidentAngle(arrivalRayParam) * 57.29577951308232;
    }

    @Override
    public double calcIncidentAngle(double arrivalRayParam) {
        if (this.name.endsWith("kmps")) {
            return 0.0;
        }
        double incidentAngle = Math.asin(this.velocityAtReceiver() * arrivalRayParam / (this.getTauModel().getRadiusOfEarth() - this.receiverDepth));
        if (!Double.isFinite(incidentAngle) && Math.abs(this.velocityAtSource() * arrivalRayParam - (this.getTauModel().getRadiusOfEarth() - this.receiverDepth)) < 0.05) {
            incidentAngle = 1.5707963267948966;
        }
        if (this.getFinalPhaseSegment().isDownGoing) {
            incidentAngle = Math.PI - incidentAngle;
        }
        return incidentAngle;
    }

    @Override
    public boolean sourceSegmentIsPWave() {
        return this.getInitialPhaseSegment().isPWave;
    }

    @Override
    public SeismicPhaseSegment getInitialPhaseSegment() {
        return this.getPhaseSegments().get(0);
    }

    @Override
    public SeismicPhaseSegment getFinalPhaseSegment() {
        return this.getPhaseSegments().get(this.getPhaseSegments().size() - 1);
    }

    @Override
    public boolean finalSegmentIsPWave() {
        return this.getPhaseSegments().get((int)(this.getPhaseSegments().size() - 1)).isPWave;
    }

    @Override
    public List<TimeDist> interpPierceTimeDist(Arrival currArrival) throws TauModelException {
        double distB;
        double distA;
        double distRatio;
        double distRayParam;
        double branchDist = 0.0;
        double branchTime = 0.0;
        ArrayList<TimeDist> pierce = new ArrayList<TimeDist>();
        int rayNum = 0;
        int i = 0;
        while (i < this.tMod.rayParams.length - 1 && this.tMod.rayParams[i] >= currArrival.getRayParam()) {
            rayNum = i++;
        }
        double negMulDist = 1.0;
        if (currArrival.isLongWayAround()) {
            negMulDist = -1.0;
        }
        if (currArrival.getRayParamIndex() == this.rayParams.length - 1) {
            distRayParam = this.rayParams[currArrival.getRayParamIndex()];
            distRatio = 1.0;
        } else {
            double rayParamA = this.rayParams[currArrival.getRayParamIndex()];
            double rayParamB = this.rayParams[currArrival.getRayParamIndex() + 1];
            distA = this.dist[currArrival.getRayParamIndex()];
            distB = this.dist[currArrival.getRayParamIndex() + 1];
            distRatio = (currArrival.getDist() - distA) / (distB - distA);
            distRayParam = distRatio * (rayParamB - rayParamA) + rayParamA;
        }
        if (this.getName().endsWith("kmps")) {
            pierce.add(new TimeDist(distRayParam, 0.0, 0.0, 0.0));
        } else {
            pierce.add(new TimeDist(distRayParam, 0.0, 0.0, this.tMod.getSourceDepth()));
        }
        SeismicPhaseSegment prevSeg = null;
        for (SeismicPhaseSegment seg : this.getPhaseSegments()) {
            double prevBranchTime;
            boolean isPWave = seg.isPWave;
            int indexIncr = seg.isDownGoing ? 1 : -1;
            int finish = seg.endBranch + indexIncr;
            if (seg.isFlat) {
                double refractDist = (currArrival.getDist() - this.dist[0]) / (double)this.countFlatLegs();
                double refractTime = refractDist * currArrival.getRayParam();
                pierce.add(new TimeDist(distRayParam, branchTime + refractTime, negMulDist * (branchDist + refractDist), seg.getDepthRange()[0]));
                branchDist += refractDist;
                prevBranchTime = branchTime;
                branchTime += refractTime;
            } else {
                List<TauBranch> branchList = SeismicPhaseFactory.calcBranchSeqForRayparam(this.proto, distRayParam, seg, prevSeg);
                for (TauBranch tauBranch : branchList) {
                    double timeB;
                    double timeA;
                    double turnDepth;
                    if (seg.isFlat) {
                        double refractDist = (currArrival.getDist() - this.dist[0]) / (double)this.countFlatLegs();
                        double refractTime = refractDist * currArrival.getRayParam();
                        pierce.add(new TimeDist(distRayParam, branchTime + refractTime, negMulDist * (branchDist + refractDist), seg.getDepthRange()[0]));
                        branchDist += refractDist;
                        prevBranchTime = branchTime;
                        branchTime += refractTime;
                        continue;
                    }
                    try {
                        turnDepth = distRayParam > tauBranch.getTopRayParam() ? tauBranch.getTopDepth() : (distRayParam <= tauBranch.getBotRayParam() ? tauBranch.getBotDepth() : this.tMod.getSlownessModel().findDepth(distRayParam, tauBranch.getTopDepth(), tauBranch.getBotDepth(), isPWave));
                    }
                    catch (SlownessModelException e) {
                        throw new TauModelException("SeismicPhase.calcPierce: Caught SlownessModelException. ", e);
                    }
                    if (this.countFlatLegs() > 0) {
                        distA = tauBranch.getDist(rayNum);
                        timeA = tauBranch.time[rayNum];
                        distB = tauBranch.getDist(rayNum);
                        timeB = tauBranch.time[rayNum];
                    } else {
                        distA = tauBranch.getDist(rayNum);
                        timeA = tauBranch.time[rayNum];
                        distB = tauBranch.getDist(rayNum + 1);
                        timeB = tauBranch.time[rayNum + 1];
                    }
                    branchDist += distRatio * (distB - distA) + distA;
                    prevBranchTime = branchTime;
                    branchTime += distRatio * (timeB - timeA) + timeA;
                    double branchDepth = seg.isDownGoing ? Math.min(tauBranch.getBotDepth(), turnDepth) : Math.min(tauBranch.getTopDepth(), turnDepth);
                    if (Math.abs(prevBranchTime - branchTime) > 1.0E-10) {
                        pierce.add(new TimeDist(distRayParam, branchTime, negMulDist * branchDist, branchDepth));
                        if (!this.DEBUG) continue;
                        Alert.debug("------->  add pierce " + String.valueOf(tauBranch));
                        Alert.debug(" branchTime=" + branchTime + " branchDist=" + branchDist + " branchDepth=" + branchDepth);
                        Alert.debug("incrementTime = " + distRatio * (timeB - timeA) + " timeB=" + timeB + " timeA=" + timeA);
                        continue;
                    }
                    if (!this.DEBUG) continue;
                    Alert.debug("Time inc in branch tiny:  branchTime=" + branchTime + " branchDist=" + branchDist + " branchDepth=" + branchDepth);
                }
            }
            prevSeg = seg;
        }
        return pierce;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double calcTstar(Arrival currArrival) {
        double tstar = 0.0;
        TauModel tMod = this.getTauModel();
        VelocityModel vMod = tMod.getVelocityModel();
        List<ArrivalPathSegment> pathSegList = currArrival.getPathSegments();
        TimeDist prev = new TimeDist();
        try {
            for (ArrivalPathSegment pseg : pathSegList) {
                for (TimeDist td : pseg.getPath()) {
                    double Q;
                    double timeInc = td.getTime() - prev.getTime();
                    if (pseg.getPhaseSegment().isFlat) {
                        if (pseg.getPhaseSegment().prevEndAction == PhaseInteraction.DIFFRACT || pseg.getPhaseSegment().prevEndAction == PhaseInteraction.TRANSUPDIFFRACT) {
                            Q = vMod.evaluateAbove(td.getDepth(), pseg.isPWave ? VelocityModelMaterial.Q_P : VelocityModelMaterial.Q_S);
                        } else {
                            if (pseg.getPhaseSegment().prevEndAction != PhaseInteraction.HEAD) throw new RuntimeException("tstar unknown for flat for prevendaction= " + String.valueOf((Object)pseg.getPhaseSegment().prevEndAction));
                            Q = vMod.evaluateBelow(td.getDepth(), pseg.isPWave ? VelocityModelMaterial.Q_P : VelocityModelMaterial.Q_S);
                        }
                    } else {
                        Q = td.getDepth() == pseg.getPhaseSegment().getBotDepth() ? vMod.evaluateAbove(td.getDepth(), pseg.isPWave ? VelocityModelMaterial.Q_P : VelocityModelMaterial.Q_S) : vMod.evaluateBelow(td.getDepth(), pseg.isPWave ? VelocityModelMaterial.Q_P : VelocityModelMaterial.Q_S);
                    }
                    if (Q <= 0.0) {
                        throw new RuntimeException("Q <= 0 for " + this.getName() + " " + String.valueOf(td) + "   depthrange: " + pseg.getPhaseSegment().getDepthRange()[0] + " " + pseg.getPhaseSegment().getDepthRange()[1]);
                    }
                    tstar += timeInc / Q;
                    prev = td;
                }
            }
            return tstar;
        }
        catch (NoSuchLayerException e) {
            throw new RuntimeException("Can't find vel layer for tau branch? depth", e);
        }
    }

    @Override
    public int getNumRays() {
        return this.getRayParams().length;
    }

    @Override
    public boolean isAllPWave() {
        for (SeismicPhaseSegment seg : this.getPhaseSegments()) {
            if (seg.isPWave) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllSWave() {
        for (SeismicPhaseSegment seg : this.getPhaseSegments()) {
            if (!seg.isPWave) continue;
            return false;
        }
        return true;
    }

    @Override
    public double calcEnergyFluxFactorReflTranPSV(Arrival arrival) throws VelocityModelException {
        double reflTranValue = 1.0;
        boolean calcSH = false;
        SeismicPhaseSegment prevSeg = this.getPhaseSegments().get(0);
        for (SeismicPhaseSegment seg : this.getPhaseSegments().subList(1, this.getPhaseSegments().size())) {
            reflTranValue *= prevSeg.calcEnergyFluxFactorReflTran(arrival, seg.isPWave, calcSH);
            prevSeg = seg;
        }
        return reflTranValue *= prevSeg.calcEnergyFluxFactorReflTran(arrival, prevSeg.isPWave, calcSH);
    }

    @Override
    public double calcEnergyFluxFactorReflTranSH(Arrival arrival) throws VelocityModelException {
        double reflTranValue = 1.0;
        boolean isAllS = this.isAllSWave();
        if (!isAllS) {
            return 0.0;
        }
        boolean calcSH = true;
        SeismicPhaseSegment prevSeg = this.getPhaseSegments().get(0);
        for (SeismicPhaseSegment seg : this.getPhaseSegments().subList(1, this.getPhaseSegments().size())) {
            reflTranValue *= prevSeg.calcEnergyFluxFactorReflTran(arrival, seg.isPWave, calcSH);
            prevSeg = seg;
        }
        return reflTranValue *= prevSeg.calcEnergyFluxFactorReflTran(arrival, prevSeg.isPWave, calcSH);
    }

    public static List<TimeDist> removeDuplicatePathPoints(List<TimeDist> inPath) {
        ArrayList<TimeDist> outPath = new ArrayList<TimeDist>();
        if (!inPath.isEmpty()) {
            TimeDist prev = inPath.get(0);
            outPath.add(prev);
            for (TimeDist td : inPath) {
                if (td.equals(prev)) continue;
                outPath.add(td);
                prev = td;
            }
        }
        return outPath;
    }

    @Override
    public String describe() {
        String desc = this.getName() + (String)(this.getName().equals(this.getPuristName()) ? "" : " (" + this.getPuristName() + ")") + ":\n";
        return desc + SeismicPhase.baseDescribe(this) + "\n" + SeismicPhaseSegment.segmentDescribe(this.getPhaseSegments());
    }

    @Override
    public String describeShort() {
        String desc = this.getName() + (String)(this.getName().equals(this.getPuristName()) ? "" : " (" + this.getPuristName() + ")") + " source: " + this.getSourceDepth() + " km, receiver: " + this.getReceiverDepth() + " km";
        return desc;
    }

    @Override
    public String toString() {
        String desc = this.name + ": ";
        for (SeismicPhaseSegment seg : this.getPhaseSegments()) {
            desc = desc + seg.legName + " ";
        }
        desc = desc + "\n";
        desc = desc + this.proto.branchNumSeqStr();
        desc = desc + "\n";
        desc = desc + "minRayParam=" + this.minRayParam + " maxRayParam=" + this.maxRayParam;
        desc = desc + "\n";
        desc = desc + "minDistance=" + this.minDistance * 180.0 / Math.PI + " maxDistance=" + this.maxDistance * 180.0 / Math.PI;
        return desc;
    }

    @Override
    public void dump() {
        for (int j = 0; j < this.dist.length; ++j) {
            System.out.println(j + "  " + this.dist[j] + "  " + this.rayParams[j]);
        }
    }
}

