/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import java.util.List;

public enum ReflTransAxisType {
    Rpp,
    Rps,
    Rsp,
    Rss,
    Tpp,
    Tps,
    Tsp,
    Tss,
    Rshsh,
    Tshsh,
    RppEnergy,
    TppEnergy,
    RpsEnergy,
    TpsEnergy,
    RspEnergy,
    TspEnergy,
    RssEnergy,
    TssEnergy,
    RshshEnergy,
    TshshEnergy,
    RppPhase,
    TppPhase,
    RpsPhase,
    TpsPhase,
    RspPhase,
    TspPhase,
    RssPhase,
    TssPhase,
    RshshPhase,
    TshshPhase,
    RpAngle,
    RsAngle,
    TpAngle,
    TsAngle,
    FreeRecFuncPr,
    FreeRecFuncSvr,
    FreeRecFuncPz,
    FreeRecFuncSvz,
    FreeRecFuncSh;

    public static final List<ReflTransAxisType> inpwave;
    public static final List<ReflTransAxisType> insvwave;
    public static final List<ReflTransAxisType> allSh;
    public static final List<ReflTransAxisType> allPSv;
    public static final List<ReflTransAxisType> allDisplacement;
    public static final List<ReflTransAxisType> allFreeRF;
    public static final List<ReflTransAxisType> allAngle;
    public static final List<ReflTransAxisType> allEnergy;
    public static final List<ReflTransAxisType> allPhase;

    public static String labelFor(ReflTransAxisType axisType) {
        switch (axisType) {
            case Rpp: 
            case Rps: 
            case Tpp: 
            case Tps: 
            case Rsp: 
            case Rss: 
            case Tsp: 
            case Tss: 
            case Rshsh: 
            case Tshsh: {
                return axisType.name() + " Displacement";
            }
            case RppEnergy: 
            case RpsEnergy: 
            case TppEnergy: 
            case TpsEnergy: 
            case RspEnergy: 
            case RssEnergy: 
            case TspEnergy: 
            case TssEnergy: 
            case RshshEnergy: 
            case TshshEnergy: {
                return axisType.name().replace("Energy", " Energy");
            }
            case RppPhase: 
            case RpsPhase: 
            case TppPhase: 
            case TpsPhase: 
            case RspPhase: 
            case RssPhase: 
            case TspPhase: 
            case TssPhase: 
            case RshshPhase: 
            case TshshPhase: {
                return axisType.name().replace("Phase", " Phase");
            }
            case FreeRecFuncPr: 
            case FreeRecFuncPz: 
            case FreeRecFuncSvr: 
            case FreeRecFuncSvz: 
            case FreeRecFuncSh: {
                return "Free Surface Factor " + axisType.name().replace("FreeRecFunc", "");
            }
            case RpAngle: 
            case RsAngle: 
            case TpAngle: 
            case TsAngle: {
                return axisType.name().replace("Angle", " Angle");
            }
        }
        return axisType.name();
    }

    static {
        inpwave = List.of(Rpp, Rps, Tpp, Tps);
        insvwave = List.of(Rsp, Rss, Tsp, Tss);
        allSh = List.of(Rshsh, Tshsh);
        allPSv = List.of(Rpp, Rps, Tpp, Tps, Rsp, Rss, Tsp, Tss);
        allDisplacement = List.of(Rpp, Rps, Tpp, Tps, Rsp, Rss, Tsp, Tss, Rshsh, Tshsh);
        allFreeRF = List.of(FreeRecFuncPr, FreeRecFuncSvr, FreeRecFuncPz, FreeRecFuncSvz, FreeRecFuncSh);
        allAngle = List.of(RpAngle, RsAngle, TpAngle, TsAngle);
        allEnergy = List.of(RppEnergy, TppEnergy, RpsEnergy, TpsEnergy, RspEnergy, TspEnergy, RssEnergy, TssEnergy, RshshEnergy, TshshEnergy);
        allPhase = List.of(RppPhase, TppPhase, RpsPhase, TpsPhase, RspPhase, TspPhase, RssPhase, TssPhase, RshshPhase, TshshPhase);
    }
}

