/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import java.util.ArrayList;

public class PlotTicks {
    public static ArrayList<Double> getTicks(double start, double stop, int count, boolean startStopFixed) {
        double fstop;
        double fstart;
        double step;
        ArrayList<Double> ticks = new ArrayList<Double>();
        if (start < stop) {
            step = PlotTicks.calculateStep(stop - start, count - 1);
            if (startStopFixed) {
                fstart = start;
                fstop = stop;
            } else {
                fstart = Math.ceil(start / step) * step;
                fstop = Math.floor(stop / step) * step;
            }
        } else if (start > stop) {
            step = PlotTicks.calculateStep(start - stop, count - 1);
            if (startStopFixed) {
                fstart = stop;
                fstop = start;
            } else {
                fstart = Math.ceil(stop / step) * step;
                fstop = Math.floor(start / step) * step;
            }
        } else {
            return ticks;
        }
        if (Math.abs(fstop - fstart) < 1.0E-15) {
            ticks.add(fstart);
            ticks.add((fstart + fstop) / 2.0);
            ticks.add(fstop);
        } else {
            for (double val = fstart; val <= fstop + step / 2.0; val += step) {
                if (Math.abs(val) < 5.552E-17) {
                    val = 0.0;
                }
                ticks.add(val);
            }
        }
        return ticks;
    }

    public static double calculateStep(double range, int minNumTicks) {
        double evenTen = Math.pow(10.0, Math.floor(Math.log10(range)));
        if (range / (evenTen / 2.0) >= (double)minNumTicks) {
            return evenTen;
        }
        if (range / (evenTen / 5.0) >= (double)minNumTicks) {
            return evenTen / 5.0;
        }
        return evenTen / 10.0;
    }
}

