/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.BranchDescription;
import edu.sc.seis.TauP.PhaseRange;
import edu.sc.seis.TauP.SegmentDescription;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.ShadowZone;
import edu.sc.seis.TauP.SphericalCoords;
import java.util.ArrayList;
import java.util.List;

public class PhaseDescription {
    String name;
    String puristname;
    float sourcedepth;
    float receiverdepth;
    String fail;
    PhaseRange minexists;
    PhaseRange maxexists;
    List<ShadowZone> shadow = new ArrayList<ShadowZone>();
    List<SegmentDescription> segments = new ArrayList<SegmentDescription>();

    public PhaseDescription(SeismicPhase phase) {
        this.name = phase.getName();
        this.puristname = phase.getPuristName();
        this.sourcedepth = (float)phase.getSourceDepth();
        this.receiverdepth = (float)phase.getReceiverDepth();
        if (phase.isFail()) {
            this.fail = phase.failReason();
            this.minexists = null;
            this.maxexists = null;
        } else {
            this.minexists = new PhaseRange();
            this.maxexists = new PhaseRange();
            this.minexists.dist = (float)phase.getMinDistanceDeg();
            this.minexists.modulodist = (float)SphericalCoords.distanceTrim180(phase.getMinDistanceDeg());
            this.minexists.rayparameter = (float)(phase.getMinRayParam() / 57.29577951308232);
            this.minexists.time = (float)phase.getMinTime();
            this.maxexists.dist = (float)phase.getMaxDistanceDeg();
            this.maxexists.modulodist = (float)SphericalCoords.distanceTrim180(phase.getMaxDistanceDeg());
            this.maxexists.rayparameter = (float)(phase.getMaxRayParam() / 57.29577951308232);
            this.maxexists.time = (float)phase.getMaxTime();
            this.shadow = phase.getShadowZones();
            this.segments = new ArrayList<SegmentDescription>();
            for (List<SeismicPhaseSegment> segList : phase.getListPhaseSegments()) {
                SegmentDescription segDesc = new SegmentDescription();
                segDesc.minrayparam = (float)(segList.get(segList.size() - 1).getMinRayParam() / 57.29577951308232);
                segDesc.maxrayparam = (float)(segList.get(segList.size() - 1).getMaxRayParam() / 57.29577951308232);
                for (SeismicPhaseSegment segment : segList) {
                    BranchDescription b = segment.describe();
                    segDesc.branchseq.add(b);
                }
                this.segments.add(segDesc);
            }
        }
    }
}

