/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import net.sf.geographiclib.GeodesicLine;

public class DistAzKarney {
    public static GeodesicData calc(LatLonLocatable loc1, LatLonLocatable loc2) {
        return DistAzKarney.calc(loc1.asLocation(), loc2.asLocation());
    }

    public static GeodesicData calc(LatLonLocatable loc1, LatLonLocatable loc2, Geodesic planetGeodesic) {
        return DistAzKarney.calc(loc1.asLocation(), loc2.asLocation(), planetGeodesic);
    }

    public static GeodesicData calc(Location loc1, Location loc2) {
        return DistAzKarney.calc(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
    }

    public static GeodesicData calc(Location loc1, Location loc2, Geodesic planetGeodesic) {
        return DistAzKarney.calc(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude(), planetGeodesic);
    }

    public static GeodesicData calc(double lat1, double lon1, double lat2, double lon2) {
        return DistAzKarney.calc(lat1, lon1, lat2, lon2, Geodesic.WGS84);
    }

    public static GeodesicData calc(double lat1, double lon1, double lat2, double lon2, Geodesic planetGeodesic) {
        return planetGeodesic.Inverse(lat1, lon1, lat2, lon2);
    }

    public static GeodesicData calcLocationDeg(Location a, double azimuth, double degrees, Geodesic geod) {
        GeodesicLine line = new GeodesicLine(geod, a.getLatitude(), a.getLongitude(), azimuth);
        GeodesicData geodesicData = line.ArcPosition(degrees);
        return geodesicData;
    }

    public static GeodesicData calcLocationKm(Location a, double kilometers, double azimuth, Geodesic geod) {
        GeodesicLine line = new GeodesicLine(geod, a.getLatitude(), a.getLongitude(), azimuth);
        GeodesicData geodesicData = line.Position(kilometers * 1000.0);
        return geodesicData;
    }
}

