type Nullable<T> = T | null | undefined
declare const __doNotImplementIt: unique symbol
type __doNotImplementIt = typeof __doNotImplementIt
export namespace com.oregondsp.signalProcessing {
    class HammingWindow extends com.oregondsp.signalProcessing.Window {
        constructor(N: number);
    }
}
export namespace com.oregondsp.signalProcessing {
    class HanningWindow extends com.oregondsp.signalProcessing.Window {
        constructor(N: number);
    }
}
export namespace com.oregondsp.signalProcessing {
    class Sequence {
        private constructor();
        get array(): Float32Array;
        set array(value: Float32Array);
        static Sequence_fromArray(x: Float32Array): com.oregondsp.signalProcessing.Sequence;
        static Sequence_ofSize(N: number): com.oregondsp.signalProcessing.Sequence;
        alias(N: number): void;
        getForIndex(index: number): number;
        reverse(): void;
        rmean(): void;
        circularShift(shift: number): void;
        zeroShift(shift: number): void;
        decimate(decrate: number): void;
        stretch(rate: number): void;
        timesEquals(f: number): void;
        pad(n: number): void;
        static get Companion(): {
            aliasArray(src: Float32Array, dst: Float32Array): void;
            reverseArray(y: Float32Array): void;
            rmeanArray(y: Float32Array): void;
            circularShiftArray(y: Float32Array, shift: number): void;
            zeroShiftArray(y: Float32Array, shift: number): void;
            decimateArray(y: Float32Array, decrate: number, ydecimated: Float32Array): void;
            stretchArray(y: Float32Array, rate: number, ystretched: Float32Array): void;
            timesEqualsArray(y: Float32Array, f: number): void;
            padArray(y: Float32Array, ypadded: Float32Array): void;
        };
    }
}
export namespace com.oregondsp.signalProcessing {
    class Window {
        constructor(N: number);
        protected get w(): Float32Array;
        protected set w(value: Float32Array);
        static Window_fromArray(w: Float32Array): com.oregondsp.signalProcessing.Window;
        length(): number;
        timesEquals(x: Float32Array): void;
        get array(): Float32Array;
        windowArray(x: Float32Array, index: number, y: Float32Array): void;
    }
}
export namespace com.oregondsp.signalProcessing.fft {
    class CDFT {
        private constructor();
        static CDFT_ofLogSize(log2N: number): com.oregondsp.signalProcessing.fft.CDFT;
        evaluateCDFT(xr: Float32Array, xi: Float32Array, Xr: Float32Array, Xi: Float32Array): void;
        evaluateInverseCDFT(Xr: Float32Array, Xi: Float32Array, xr: Float32Array, xi: Float32Array): void;
        static CDFT_ofArrays(xr: Float32Array, xi: Float32Array, yr: Float32Array, yi: Float32Array, log2N: number): com.oregondsp.signalProcessing.fft.CDFT;
        evaluate(): void;
        evaluateInverse(): void;
        static get Companion(): {
            dftProduct(Xr: Float32Array, Xi: Float32Array, Yr: Float32Array, Yi: Float32Array, sign: number): void;
        };
    }
}
export namespace com.oregondsp.signalProcessing.fft {
    class RDFT {
        constructor(log2N: number);
        evaluate(x: Float32Array, X: Float32Array): void;
        evaluateInverse(X: Float32Array, x: Float32Array): void;
        static get Companion(): {
            dftProduct(kernel: Float32Array, transform: Float32Array, sign: number): void;
        };
    }
}
export namespace com.oregondsp.signalProcessing.filter {
    class LagrangePolynomial {
        constructor(x: Float64Array, y: Float64Array);
        order(): number;
        evaluateAt(xp: number): number;
        ChebyshevNodes(a: number, b: number, n: number): Float64Array;
        static get Companion(): {
            BarycentricWeights(z: Float64Array): Float64Array;
        };
    }
}
export namespace com.oregondsp.signalProcessing.filter {
    class Polynomial {
        private constructor();
        get a(): Float64Array;
        set a(value: Float64Array);
        get _order(): number;
        set _order(value: number);
        static Polynomial_ofArray(a: Float64Array): com.oregondsp.signalProcessing.filter.Polynomial;
        static Polynomial_ofPolynomial(B: com.oregondsp.signalProcessing.filter.Polynomial): com.oregondsp.signalProcessing.filter.Polynomial;
        static Polynomial_ofDegree(order: number): com.oregondsp.signalProcessing.filter.Polynomial;
        static Polynomial_ofConstant(c: number): com.oregondsp.signalProcessing.filter.Polynomial;
        trim(): void;
        order(): number;
        coefficients(): Float64Array;
        plusReal(c: number): com.oregondsp.signalProcessing.filter.Polynomial;
        plusEqualsReal(c: number): void;
        plusPolynomial(B: com.oregondsp.signalProcessing.filter.Polynomial): com.oregondsp.signalProcessing.filter.Polynomial;
        plusEqualsPolynomial(B: com.oregondsp.signalProcessing.filter.Polynomial): void;
        minusReal(c: number): com.oregondsp.signalProcessing.filter.Polynomial;
        minusEqualsReal(c: number): void;
        minusPolynomial(B: com.oregondsp.signalProcessing.filter.Polynomial): com.oregondsp.signalProcessing.filter.Polynomial;
        minusEqualsPolynomial(B: com.oregondsp.signalProcessing.filter.Polynomial): void;
        timesReal(c: number): com.oregondsp.signalProcessing.filter.Polynomial;
        timesEqualsReal(c: number): void;
        timesPolynomial(B: com.oregondsp.signalProcessing.filter.Polynomial): com.oregondsp.signalProcessing.filter.Polynomial;
        timesEqualsPolynomial(B: com.oregondsp.signalProcessing.filter.Polynomial): void;
        overReal(c: number): com.oregondsp.signalProcessing.filter.Polynomial;
        overEqualsReal(c: number): void;
        overEqualsPolynomial(B: com.oregondsp.signalProcessing.filter.Polynomial): com.oregondsp.signalProcessing.filter.Rational;
        derivative(): com.oregondsp.signalProcessing.filter.Polynomial;
        evaluateReal(x: number): number;
        evaluateComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
        groupDelay(omega: number): number;
        discreteTimeGroupDelay(Omega: number): number;
        reflectionCoefficients(): Float64Array;
        toString(): string;
    }
}
export namespace com.oregondsp.signalProcessing.filter {
    class Rational {
        private constructor();
        static Rational_ofArrays(num: Float64Array, denom: Float64Array): com.oregondsp.signalProcessing.filter.Rational;
        static Rational_ofPolynomials(N: com.oregondsp.signalProcessing.filter.Polynomial, D: com.oregondsp.signalProcessing.filter.Polynomial): com.oregondsp.signalProcessing.filter.Rational;
        static Rational_ofRational(R: com.oregondsp.signalProcessing.filter.Rational): com.oregondsp.signalProcessing.filter.Rational;
        static Rational_ofConstant(c: number): com.oregondsp.signalProcessing.filter.Rational;
        order(): Int32Array;
        numerator(): com.oregondsp.signalProcessing.filter.Polynomial;
        denominator(): com.oregondsp.signalProcessing.filter.Polynomial;
        canonicalForm(): number;
        timesEqualsReal(A: number): void;
        timesEqualsPolynomial(P: com.oregondsp.signalProcessing.filter.Polynomial): void;
        timesEqualsRational(R: com.oregondsp.signalProcessing.filter.Rational): void;
        evaluateReal(x: number): number;
        evaluateComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
        mapRational(S: com.oregondsp.signalProcessing.filter.Rational): com.oregondsp.signalProcessing.filter.Rational;
        residueForReal(pole: number): number;
        residueForComplex(pole: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
        groupDelay(omega: number): number;
        discreteTimeGroupDelay(Omega: number): number;
        toString(): string;
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir {
    class ComplexAnalyticSignal {
        constructor(realSignal: Float32Array);
        get envelope(): Float32Array;
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir {
    class Interpolator {
        constructor(rate: number, designFactor: number, blockSize: number);
        interpolate(block: Float32Array, interpolatedBlock: Float32Array): void;
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir {
    class OverlapAdd {
        private constructor();
        static OverlapAdd_ofArray(H: Float32Array, blockSize: number): com.oregondsp.signalProcessing.filter.fir.OverlapAdd;
        static OverlapAdd_ofArrayOverlapAdd(H: Float32Array, master: com.oregondsp.signalProcessing.filter.fir.OverlapAdd): com.oregondsp.signalProcessing.filter.fir.OverlapAdd;
        filter(src: Float32Array, sptr: number, dst: Float32Array, dptr: number): void;
        flush(dst: Float32Array, dptr: number): void;
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    class CenteredDifferentiator extends com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeIII {
        constructor(N: number, delta: number, OmegaP: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    class CenteredHilbertTransform extends com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeIII {
        constructor(N: number, Omega1: number, Omega2: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    class EquirippleBandpass extends com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeI {
        constructor(N: number, OmegaS1: number, Ws1: number, OmegaP1: number, OmegaP2: number, Wp: number, OmegaS2: number, Ws2: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    abstract class EquirippleFIRFilter {
        constructor(numBands: number, N: number, Nc: number);
        protected get numBands(): number;
        protected set numBands(value: number);
        protected get N(): number;
        protected set N(value: number);
        protected get Nc(): number;
        protected set Nc(value: number);
        protected get bands(): Array<Float64Array>;
        protected set bands(value: Array<Float64Array>);
        get _coefficients(): Nullable<Float32Array>;
        set _coefficients(value: Nullable<Float32Array>);
        getCoefficients(): Float32Array;
        protected get implementation(): Nullable<com.oregondsp.signalProcessing.filter.fir.OverlapAdd>;
        protected set implementation(value: Nullable<com.oregondsp.signalProcessing.filter.fir.OverlapAdd>);
        protected createGrid(): any/* com.oregondsp.signalProcessing.filter.fir.equiripple.DesignGrid */;
        generateCoefficients(): void;
        getImplementation(blockSize: number): com.oregondsp.signalProcessing.filter.fir.OverlapAdd;
        filter(x: Float32Array): Float32Array;
        protected LTE(x: number, y: number): boolean;
        static get Companion(): {
            get MACHINETOLERANCE(): number;
        };
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    class EquirippleHalfBand {
        constructor(N: number, OmegaP: number);
        getCoefficients(): Float32Array;
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    class EquirippleHighpass extends com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeI {
        constructor(N: number, OmegaS: number, Ws: number, OmegaP: number, Wp: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    class EquirippleLowpass extends com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeI {
        constructor(N: number, OmegaP: number, Wp: number, OmegaS: number, Ws: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    abstract class FIRTypeI extends com.oregondsp.signalProcessing.filter.fir.equiripple.EquirippleFIRFilter {
        constructor(numBands: number, nHalf: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    abstract class FIRTypeII extends com.oregondsp.signalProcessing.filter.fir.equiripple.EquirippleFIRFilter {
        constructor(numBands: number, nHalf: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    abstract class FIRTypeIII extends com.oregondsp.signalProcessing.filter.fir.equiripple.EquirippleFIRFilter {
        constructor(numBands: number, nHalf: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    abstract class FIRTypeIV extends com.oregondsp.signalProcessing.filter.fir.equiripple.EquirippleFIRFilter {
        constructor(numBands: number, nHalf: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    class StaggeredDifferentiator extends com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeIV {
        constructor(N: number, delta: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.fir.equiripple {
    class StaggeredHilbertTranform extends com.oregondsp.signalProcessing.filter.fir.equiripple.FIRTypeIV {
        constructor(N: number, OmegaP: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.iir {
    class Allpass {
        constructor(filterorder: number);
        protected get k(): Float64Array;
        protected set k(value: Float64Array);
        protected get order(): number;
        protected set order(value: number);
        protected get state(): Float64Array;
        protected set state(value: Float64Array);
        protected get T(): com.oregondsp.signalProcessing.filter.Rational;
        protected set T(value: com.oregondsp.signalProcessing.filter.Rational);
        static Allpass_ofPolynomial(A: com.oregondsp.signalProcessing.filter.Polynomial): com.oregondsp.signalProcessing.filter.iir.Allpass;
        static Allpass_ofArray(k: Float64Array): com.oregondsp.signalProcessing.filter.iir.Allpass;
        initialize(): void;
        filterSingle(x: number): number;
        filter(x: Float32Array): void;
        evaluate(omega: number): com.oregondsp.signalProcessing.filter.iir.Complex;
        groupDelay(Omega: number): number;
        protected constructRationalRepresentation(): void;
        rationalRepresentation(): com.oregondsp.signalProcessing.filter.Rational;
        toString(): string;
    }
}
export namespace com.oregondsp.signalProcessing.filter.iir {
    class AnalogPrototype {
        constructor();
        protected get sections(): any/* kotlin.collections.ArrayList<com.oregondsp.signalProcessing.filter.Rational> */;
        protected set sections(value: any/* kotlin.collections.ArrayList<com.oregondsp.signalProcessing.filter.Rational> */);
        protected get T(): com.oregondsp.signalProcessing.filter.Rational;
        addSection(R: com.oregondsp.signalProcessing.filter.Rational): void;
        nSections(): number;
        getSection(index: number): com.oregondsp.signalProcessing.filter.Rational;
        lptolp(omega0: number): com.oregondsp.signalProcessing.filter.iir.AnalogPrototype;
        lptohp(omega0: number): com.oregondsp.signalProcessing.filter.iir.AnalogPrototype;
        lptobp(omega1: number, omega2: number): com.oregondsp.signalProcessing.filter.iir.AnalogPrototype;
        protected computeTransferFunction(): com.oregondsp.signalProcessing.filter.Rational;
        get transferFunction(): com.oregondsp.signalProcessing.filter.Rational;
        evaluate(omega: number): com.oregondsp.signalProcessing.filter.iir.Complex;
        groupDelay(omega: number): number;
        toString(): string;
    }
}
export namespace com.oregondsp.signalProcessing.filter.iir {
    class Butterworth extends com.oregondsp.signalProcessing.filter.iir.IIRFilter {
        constructor(order: number, type: com.oregondsp.signalProcessing.filter.iir.PassbandType, f1: number, f2: number, delta: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.iir {
    class ChebyshevI extends com.oregondsp.signalProcessing.filter.iir.IIRFilter {
        constructor(order: number, epsilon: number, type: com.oregondsp.signalProcessing.filter.iir.PassbandType, f1: number, f2: number, delta: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.iir {
    class ChebyshevII extends com.oregondsp.signalProcessing.filter.iir.IIRFilter {
        constructor(order: number, epsilon: number, type: com.oregondsp.signalProcessing.filter.iir.PassbandType, f1: number, f2: number, delta: number);
    }
}
export namespace com.oregondsp.signalProcessing.filter.iir {
    class Complex {
        constructor(realpart: number, imagpart: number);
        static Complex_fromReal(real: number): com.oregondsp.signalProcessing.filter.iir.Complex;
        real(): number;
        imag(): number;
        abs(): number;
        angle(): number;
        timesComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
        timesReal(a: number): com.oregondsp.signalProcessing.filter.iir.Complex;
        conjugate(): com.oregondsp.signalProcessing.filter.iir.Complex;
        plusComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
        plusReal(a: number): com.oregondsp.signalProcessing.filter.iir.Complex;
        minusComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
        minusReal(a: number): com.oregondsp.signalProcessing.filter.iir.Complex;
        overReal(a: number): com.oregondsp.signalProcessing.filter.iir.Complex;
        overComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
        plusEqualsReal(a: number): void;
        plusEqualsComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): void;
        minusEqualsReal(a: number): void;
        minusEqualsComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): void;
        timesEqualsReal(a: number): void;
        timesEqualsComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): void;
        divideEqualsReal(a: number): void;
        divideEqualsComplex(c: com.oregondsp.signalProcessing.filter.iir.Complex): void;
        toString(): string;
        static get Companion(): {
            ComplexFromPolar(r: number, phi: number): com.oregondsp.signalProcessing.filter.iir.Complex;
            addRealComplex(a: number, c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            addComplexReal(c: com.oregondsp.signalProcessing.filter.iir.Complex, a: number): com.oregondsp.signalProcessing.filter.iir.Complex;
            subtractComplexReal(c: com.oregondsp.signalProcessing.filter.iir.Complex, a: number): com.oregondsp.signalProcessing.filter.iir.Complex;
            subtractRealComplex(a: number, c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            unaryMinus(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            multiplyRealComplex(a: number, c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            multiplyComplexReal(c: com.oregondsp.signalProcessing.filter.iir.Complex, a: number): com.oregondsp.signalProcessing.filter.iir.Complex;
            addComplexComplex(c1: com.oregondsp.signalProcessing.filter.iir.Complex, c2: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            subtractComplexComplex(c1: com.oregondsp.signalProcessing.filter.iir.Complex, c2: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            multiplyComplexComplex(c1: com.oregondsp.signalProcessing.filter.iir.Complex, c2: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            divideComplexReal(c: com.oregondsp.signalProcessing.filter.iir.Complex, a: number): com.oregondsp.signalProcessing.filter.iir.Complex;
            divideRealComplex(a: number, c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            divideComplexComplex(c1: com.oregondsp.signalProcessing.filter.iir.Complex, c2: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            sqrt(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            abs(c: com.oregondsp.signalProcessing.filter.iir.Complex): number;
            angle(c: com.oregondsp.signalProcessing.filter.iir.Complex): number;
            exp(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
            conjugate(c: com.oregondsp.signalProcessing.filter.iir.Complex): com.oregondsp.signalProcessing.filter.iir.Complex;
        };
    }
}
export namespace com.oregondsp.signalProcessing.filter.iir {
    class IIRFilter {
        constructor(baseFilter: com.oregondsp.signalProcessing.filter.iir.AnalogPrototype, type: com.oregondsp.signalProcessing.filter.iir.PassbandType, f1: number, f2: number, delta: number);
        protected get sections(): any/* kotlin.collections.ArrayList<com.oregondsp.signalProcessing.filter.iir.SecondOrderSection> */;
        protected set sections(value: any/* kotlin.collections.ArrayList<com.oregondsp.signalProcessing.filter.iir.SecondOrderSection> */);
        protected get T(): com.oregondsp.signalProcessing.filter.Rational;
        protected set T(value: com.oregondsp.signalProcessing.filter.Rational);
        protected get delta(): number;
        protected get f1(): number;
        protected get f2(): number;
        initialize(): void;
        getDelta(): number;
        getLowCorner(): number;
        getHighCorner(): number;
        filterNextSample(x: number): number;
        filter(x: Float32Array, y: Float32Array): void;
        filterInPlace(x: Float32Array): void;
        evaluate(Omega: number): com.oregondsp.signalProcessing.filter.iir.Complex;
        groupDelay(Omega: number): number;
        toString(): string;
    }
}
export namespace com.oregondsp.signalProcessing.filter.iir {
    abstract class PassbandType {
        private constructor();
        static get LOWPASS(): com.oregondsp.signalProcessing.filter.iir.PassbandType & {
            get name(): "LOWPASS";
            get ordinal(): 0;
        };
        static get BANDPASS(): com.oregondsp.signalProcessing.filter.iir.PassbandType & {
            get name(): "BANDPASS";
            get ordinal(): 1;
        };
        static get HIGHPASS(): com.oregondsp.signalProcessing.filter.iir.PassbandType & {
            get name(): "HIGHPASS";
            get ordinal(): 2;
        };
        static values(): Array<com.oregondsp.signalProcessing.filter.iir.PassbandType>;
        static valueOf(value: string): com.oregondsp.signalProcessing.filter.iir.PassbandType;
        get name(): "LOWPASS" | "BANDPASS" | "HIGHPASS";
        get ordinal(): 0 | 1 | 2;
    }
}
export namespace com.oregondsp.signalProcessing.filter.iir {
    class ThiranAllpass extends com.oregondsp.signalProcessing.filter.iir.Allpass {
        constructor(N: number, D: number);
    }
}
export as namespace oregondsp;