package edu.sc.seis.TauP;

import net.sf.geographiclib.Geodesic;

public class DistanceGeodeticKmRay extends DistanceRay {

    public DistanceGeodeticKmRay(double km, Geodesic geod) {
        this.kilometers = km;
        this.geodesic = geod;
    }

    @Override
    public double getDegrees(double radius) {
        return getRadians(radius)*SphericalCoords.RtoD;
    }

    @Override
    public double getRadians(double radius) {
        return kilometers/averageRadiusKm();
    }

    @Override
    public double getKilometers(double radius) {
        return kilometers;
    }

    public double averageRadiusKm() {
        // use mean radius, r = (2*er+pr)/3, mean of two equitorial radii and polar radius
        double polarRadius = geodesic.EquatorialRadius() * (1 - geodesic.Flattening());
        double meanRadius = (2*geodesic.EquatorialRadius()+polarRadius)/3;
        return meanRadius/1000;
    }

    protected double kilometers;
}
