/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.DistAz;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.SurfaceStation;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQuerier;
import edu.sc.seis.seisFile.fdsnws.FDSNEventQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNStationQueryParams;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import edu.sc.seis.seisFile.fdsnws.IRISFedCatQuerier;
import edu.sc.seis.seisFile.fdsnws.IRISFedCatQueryParams;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.Quakeml;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.FDSNSourceIdException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import picocli.CommandLine;

public class QmlStaxmlArgs {
    public static final String staSourceIdRegExString = "FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})";
    public static final Pattern staSourceIdRegEx = Pattern.compile("FDSN:([A-Z0-9]{1,8})_([A-Z0-9-]{1,8})");
    @CommandLine.Option(names={"--eid"}, paramLabel="evt", split=",", description={"event id, like us7000pn9s, for lookup via USGS fdsn event web service. Creates a distance if station is also given."})
    public List<String> eidList = new ArrayList<String>();
    @CommandLine.Option(names={"--sid"}, paramLabel="sta", split=",", description={"station id, like CO.HAW or FDSN:CO_HAW, for lookup via fedcat web service. Creates a distance if event is also given."})
    public List<String> sidList = new ArrayList<String>();
    protected String quakemlFilename = null;
    protected String stationxmlFilename = null;
    public static double MAX_CHANNEL_DEPTH_SAME_STATION = 10.0;

    public static List<Station> loadStationsForSid(List<String> sidList) throws FDSNSourceIdException, FDSNWSException {
        if (sidList.isEmpty()) {
            return List.of();
        }
        FDSNStationQueryParams staQP = new FDSNStationQueryParams();
        staQP.setLevel("station");
        for (String sid : sidList) {
            if (sid.startsWith("FDSN:")) {
                Matcher m = staSourceIdRegEx.matcher(sid);
                if (m.matches()) {
                    staQP.appendToNetwork(m.group(1));
                    staQP.appendToStation(m.group(2));
                    continue;
                }
                FDSNSourceId fdsn = FDSNSourceId.parse((String)sid);
                staQP.appendToNetwork(fdsn.getNetworkCode());
                staQP.appendToStation(fdsn.getStationCode());
                continue;
            }
            String[] splitSid = sid.split("[_.]");
            if (splitSid.length < 2) continue;
            staQP.appendToNetwork(splitSid[0]);
            staQP.appendToStation(splitSid[1]);
        }
        IRISFedCatQueryParams qp = new IRISFedCatQueryParams(staQP);
        qp.setFormat("text");
        IRISFedCatQuerier querier = new IRISFedCatQuerier(qp);
        querier.setUserAgent(QmlStaxmlArgs.getTaupUserAgent());
        ArrayList<Station> staList = querier.getStationsFromText();
        ArrayList<Station> uniq = new ArrayList<Station>();
        for (int i = 0; i < staList.size(); ++i) {
            Station a = (Station)staList.get(i);
            boolean found = false;
            for (int j = i + 1; j < staList.size(); ++j) {
                DistAz distAz;
                Station b = (Station)staList.get(j);
                if (!Objects.equals(a.getNetworkCode(), b.getNetworkCode()) || !Objects.equals(a.getStationCode(), b.getStationCode()) || !((distAz = new DistAz(a.asLocation(), b.asLocation())).getDelta() < 0.01)) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniq.add(a);
        }
        staList = uniq;
        return staList;
    }

    public List<LatLonLocatable> getStationLocations() throws TauPException {
        ArrayList<LatLonLocatable> staList = new ArrayList<LatLonLocatable>();
        staList.addAll(this.getSidLocations());
        staList.addAll(this.getStationXMLLocations());
        return staList;
    }

    public List<LatLonLocatable> getStationXMLLocations() throws TauPException {
        ArrayList<LatLonLocatable> staList = new ArrayList<LatLonLocatable>();
        Map<Network, List<Station>> networks = this.loadStationXML();
        for (Network net : networks.keySet()) {
            for (Station sta : networks.get(net)) {
                ArrayList<Channel> allChans = new ArrayList<Channel>();
                for (Channel chan : sta.getChannelList()) {
                    if (sta.asLocation().equals((Object)chan.asLocation())) continue;
                    boolean found = false;
                    for (int i = 0; i < allChans.size(); ++i) {
                        Channel prev = (Channel)allChans.get(i);
                        if (!prev.asLocation().equals((Object)chan.asLocation())) continue;
                        found = true;
                        if (!chan.getChannelCode().endsWith("Z") || prev.getChannelCode().endsWith("Z") && (prev.getLocCode().equals("00") || !chan.getLocCode().equals("00"))) break;
                        allChans.set(i, chan);
                        break;
                    }
                    if (found) continue;
                    allChans.add(chan);
                }
                if (allChans.isEmpty()) {
                    staList.add((LatLonLocatable)sta);
                    continue;
                }
                if (allChans.size() == 1) {
                    Location chL = ((Channel)allChans.get(0)).asLocation();
                    Location stL = sta.asLocation();
                    if (chL.getLatitude() == stL.getLatitude() && chL.getLongitude() == stL.getLongitude() && (chL.getDepthMeter() == null || chL.getDepthMeter() < MAX_CHANNEL_DEPTH_SAME_STATION)) {
                        staList.add((LatLonLocatable)new SurfaceStation(sta));
                        continue;
                    }
                    staList.addAll(allChans);
                    continue;
                }
                staList.addAll(allChans);
            }
        }
        return staList;
    }

    public List<LatLonLocatable> getEventLocations() throws TauPException {
        ArrayList<LatLonLocatable> eventLocs = new ArrayList<LatLonLocatable>();
        eventLocs.addAll(this.loadQuakeML());
        eventLocs.addAll(this.loadEventsFromUSGS(this.getEventIdList()));
        return eventLocs;
    }

    public boolean hasQml() {
        return this.getQuakemlFilename() != null || !this.getEventIdList().isEmpty();
    }

    public boolean hasStationXML() {
        return this.getStationxmlFilename() != null || !this.sidList.isEmpty();
    }

    public Map<Network, List<Station>> loadStationXML() throws TauPException {
        Map<Object, List<Object>> networks = new HashMap<Network, List<Station>>();
        try {
            if (this.stationxmlFilename != null) {
                FDSNStationXML staxml = FDSNStationXML.loadStationXML((String)this.stationxmlFilename);
                networks = staxml.extractAllNetworks();
            }
        }
        catch (SeisFileException | IOException | XMLStreamException e) {
            throw new TauPException("Unable to process stationxml from " + this.stationxmlFilename, e);
        }
        return networks;
    }

    public List<Event> loadQuakeML() throws TauPException {
        List<Object> quakes = new ArrayList<Event>();
        try {
            if (this.quakemlFilename != null) {
                FileReader reader = new FileReader(this.quakemlFilename);
                Quakeml quakeml = Quakeml.loadQuakeML((Reader)reader);
                quakes = quakeml.extractAllEvents();
                reader.close();
            }
        }
        catch (SeisFileException | IOException | XMLStreamException e) {
            throw new TauPException("Unable to process quakeml from " + this.quakemlFilename, e);
        }
        return quakes;
    }

    public String getQuakemlFilename() {
        return this.quakemlFilename;
    }

    @CommandLine.Option(names={"--qml", "--quakeml"}, description={"QuakeML file to load for earthquake origins to use"})
    public void setQuakemlFilename(String quakemlFilename) {
        this.quakemlFilename = quakemlFilename;
    }

    public List<String> getEventIdList() {
        return this.eidList;
    }

    public List<Event> loadEventsFromUSGS(List<String> eidList) throws TauPException {
        ArrayList<Event> out = new ArrayList<Event>();
        try {
            for (String eid : eidList) {
                FDSNEventQueryParams qp = new FDSNEventQueryParams();
                qp.setEventid(eid);
                FDSNEventQuerier querier = new FDSNEventQuerier(qp);
                querier.setUserAgent(QmlStaxmlArgs.getTaupUserAgent());
                out.addAll(querier.getQuakeML().extractAllEvents());
            }
        }
        catch (SeisFileException | XMLStreamException e) {
            throw new TauPException("Unable to load station locations from fedcat service", e);
        }
        return out;
    }

    public String getStationxmlFilename() {
        return this.stationxmlFilename;
    }

    @CommandLine.Option(names={"--staxml"}, description={"StationXML file to extract station latitudes and longitudes from"})
    public void setStationxmlFilename(String stationxmlFilename) {
        this.stationxmlFilename = stationxmlFilename;
    }

    public List<String> getSidList() {
        return this.sidList;
    }

    public List<Station> getSidLocations() throws TauPException {
        try {
            return QmlStaxmlArgs.loadStationsForSid(this.getSidList());
        }
        catch (FDSNWSException | FDSNSourceIdException e) {
            throw new TauPException("Unable to load station locations from fedcat service", e);
        }
    }

    public static String getTaupUserAgent() {
        return BuildVersion.getName() + "/" + BuildVersion.getVersion();
    }
}

