/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.DistAzPlanet;
import edu.sc.seis.TauP.cmdline.args.LatLonArgs;
import net.sf.geographiclib.Geodesic;
import picocli.CommandLine;

public class GeodeticArgs
extends LatLonArgs {
    @CommandLine.Option(names={"--az"}, description={"azimuth in degrees, source to receiver"})
    protected Double azimuth = null;
    @CommandLine.Option(names={"--baz"}, description={"backazimuth in degrees, receiver to source"})
    protected Double backAzimuth = null;
    @CommandLine.Option(names={"--geodetic"}, description={"use geodetic latitude for distance calculations, which implies an ellipticity. Default is spherical. Note this only affects calculation of distance from lat/lon pairs, all travel time calculations are done in a purely spherical model."})
    protected boolean geodetic = false;
    @CommandLine.Option(names={"--invflattening", "--geodeticflattening"}, paramLabel="f", description={"Inverse Elliptical flattening for distance calculations when --geodetic, defaults to WGS84 ~ 298.257. The distance calculation uses 1/x."})
    protected Double geodeticFlattening = null;
    @CommandLine.Option(names={"--equitorialradius"}, paramLabel="m", description={"Equitorial radius in meters for distance calculations when --geodetic, defaults to WGS84 ~ 6378137 meters. "})
    protected Double equitorialradius = null;
    @CommandLine.Option(names={"--planet"}, description={"Geodesic for planets, for distance calculations when --geodetic, one of: ${COMPLETION-CANDIDATES}. "})
    protected DistAzPlanet planet = null;
    public static final String GEODETIC = "geodetic";
    public static final String SPHERICAL = "spherical";

    public boolean hasAzimuth() {
        return this.azimuth != null;
    }

    public Double getAzimuth() {
        return this.azimuth;
    }

    public boolean hasBackAzimuth() {
        return this.backAzimuth != null;
    }

    public Double getBackAzimuth() {
        return this.backAzimuth;
    }

    public boolean isGeodetic() {
        return this.geodetic;
    }

    public double getInverseEllipFlattening() {
        if (this.geodeticFlattening != null) {
            return this.geodeticFlattening;
        }
        if (this.planet != null) {
            return 1.0 / this.planet.createGeodesic().Flattening();
        }
        return 1.0 / Geodesic.WGS84.Flattening();
    }

    public double getEquitorialRadius() {
        if (this.equitorialradius != null) {
            return this.equitorialradius;
        }
        if (this.planet != null) {
            return this.planet.createGeodesic().EquatorialRadius();
        }
        return Geodesic.WGS84.EquatorialRadius();
    }

    @Override
    public void validateArguments() {
        if (this.geodeticFlattening != null && this.getInverseEllipFlattening() <= 0.0) {
            throw new IllegalArgumentException("Inverse Elliptical flattening must be positive: " + this.getInverseEllipFlattening());
        }
        if (this.planet != null && this.equitorialradius != null && this.geodeticFlattening != null) {
            throw new IllegalArgumentException("Cannot specify --planet and either of --equitorialradius or --geodeticflattening");
        }
    }

    public Geodesic getGeodesic() {
        Geodesic geodesic = Geodesic.WGS84;
        geodesic = this.geodetic ? (this.planet != null ? this.planet.createGeodesic() : new Geodesic(this.equitorialradius != null ? this.equitorialradius.doubleValue() : Geodesic.WGS84.EquatorialRadius(), this.geodeticFlattening != null ? 1.0 / this.geodeticFlattening : Geodesic.WGS84.Flattening())) : new Geodesic(this.equitorialradius.doubleValue(), 0.0);
        return geodesic;
    }

    public String getCalcType() {
        if (this.geodetic) {
            return GEODETIC;
        }
        return SPHERICAL;
    }
}

