/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.SeismicSource;
import edu.sc.seis.TauP.cmdline.args.DistanceArgs;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

public class DistanceLengthArgs {
    @CommandLine.Option(names={"--deg", "--degree"}, paramLabel="d", description={"distance in degrees"}, split=",")
    public List<Double> degreesList = new ArrayList<Double>();
    @CommandLine.Option(names={"--degreerange"}, arity="1..3", paramLabel="[step][min max][min max step]", hideParamSyntax=true, description={"regular distance range in degrees, one of step; min max or min max step. Default min is 0, max is 180 and step is 10."})
    public List<Double> degreeRange = new ArrayList<Double>();
    @CommandLine.Option(names={"--km", "--kilometer"}, paramLabel="km", description={"distance in kilometers along surface."}, split=",")
    public List<Double> distKilometersList = new ArrayList<Double>();
    @CommandLine.Option(names={"--kilometerrange"}, arity="1..3", paramLabel="[step][min max][min max step]", hideParamSyntax=true, description={"regular distance range in kilometers, one of step; min max or min max step. Default min is 0, max is 1000 and step is 100."})
    public List<Double> kilometerRange = new ArrayList<Double>();

    public List<RayCalculateable> getRayCalculatables(SeismicSourceArgs sourceArgs) {
        ArrayList<RayCalculateable> out = new ArrayList<RayCalculateable>();
        out.addAll(this.getLengthDistances());
        if (sourceArgs != null) {
            SeismicSource ss = new SeismicSource(sourceArgs.getMw(), sourceArgs.getFaultPlane());
            for (RayCalculateable rc : out) {
                if (rc.hasSeismicSource()) continue;
                rc.setSeismicSource(ss);
            }
        }
        return out;
    }

    public List<DistanceRay> getLengthDistances() {
        ArrayList<DistanceRay> simpleDistanceList = new ArrayList<DistanceRay>();
        for (Double d : this.degreesList) {
            simpleDistanceList.add(DistanceRay.ofDegrees(d));
        }
        if (!this.degreeRange.isEmpty()) {
            for (Double d : DistanceArgs.createListFromRangeDeg(this.degreeRange)) {
                simpleDistanceList.add(DistanceRay.ofDegrees(d));
            }
        }
        for (Double d : this.distKilometersList) {
            simpleDistanceList.add(DistanceRay.ofKilometers(d));
        }
        if (!this.kilometerRange.isEmpty()) {
            for (Double d : DistanceArgs.createListFromRangeKm(this.kilometerRange)) {
                simpleDistanceList.add(DistanceRay.ofKilometers(d));
            }
        }
        return simpleDistanceList;
    }

    public boolean allEmpty() {
        return this.degreesList.isEmpty() && this.distKilometersList.isEmpty() && this.degreeRange.isEmpty() && this.kilometerRange.isEmpty();
    }
}

