/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.ModelAxisType;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.SlownessModel;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelMaterial;
import edu.sc.seis.TauP.XYPlotOutput;
import edu.sc.seis.TauP.XYPlottingData;
import edu.sc.seis.TauP.XYSegment;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.ColoringArgs;
import edu.sc.seis.TauP.cmdline.args.InputVelocityModelArgs;
import edu.sc.seis.TauP.cmdline.args.ModelArgs;
import edu.sc.seis.TauP.cmdline.args.VelPlotOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.VelocityModelArgs;
import edu.sc.seis.TauP.cmdline.args.VelocityModelListArgs;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import picocli.CommandLine;

@CommandLine.Command(name="velplot", description={"Plot velocity vs depth for a model."}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_VelocityPlot
extends TauP_Tool {
    public static final String DEFAULT_OUTFILE = "taup_velplot";
    @CommandLine.ArgGroup(heading="Velocity Model %n")
    VelocityModelListArgs velModelArgs = new VelocityModelListArgs();
    @CommandLine.Mixin
    VelPlotOutputTypeArgs outputTypeArgs;
    @CommandLine.Option(names={"--legend"}, description={"create a legend"})
    boolean isLegend = false;
    ColoringArgs coloringArgs = new ColoringArgs();
    ModelAxisType xAxisType = ModelAxisType.velocity;
    ModelAxisType yAxisType = ModelAxisType.depth;
    protected double[] xAxisMinMax = new double[0];
    protected double[] yAxisMinMax = new double[0];

    public TauP_VelocityPlot() {
        super(new VelPlotOutputTypeArgs("text", DEFAULT_OUTFILE));
        this.outputTypeArgs = (VelPlotOutputTypeArgs)this.abstractOutputTypeArgs;
        this.outputTypeArgs.setOutFileBase(DEFAULT_OUTFILE);
    }

    @Override
    public void start() throws TauPException, IOException {
        List<VelocityModel> vModList = this.getVelModelArgs().getVelocityModels();
        if (this.outputTypeArgs.isCSV()) {
            for (VelocityModel vMod : vModList) {
                if (!this.outputTypeArgs.isStdout()) {
                    this.outputTypeArgs.setOutFileBase(vMod.getModelName());
                }
                PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
                this.printCSV(writer, vMod);
                writer.close();
            }
        } else if (this.outputTypeArgs.isND()) {
            for (VelocityModel vMod : vModList) {
                if (!this.outputTypeArgs.isStdout()) {
                    this.outputTypeArgs.setOutFileBase(vMod.getModelName());
                }
                PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
                vMod.writeToND(writer);
                writer.close();
            }
        } else {
            if (Objects.equals(this.outputTypeArgs.getOutFileBase(), DEFAULT_OUTFILE) && vModList.size() == 1) {
                this.outputTypeArgs.setOutFileBase(vModList.get(0).getModelName() + "_vel");
            }
            PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
            Object modelLabel = "";
            Object title = "";
            ArrayList<XYPlottingData> xyPlotList = new ArrayList<XYPlottingData>();
            for (VelocityModelArgs vmodArg : this.velModelArgs.getVelocityModelArgsList()) {
                title = (String)title + ", " + vmodArg.getModelFilename();
                if (this.velModelArgs.size() > 1) {
                    modelLabel = vmodArg.getModelFilename() + " ";
                }
                List<XYPlottingData> modxyPlotList = this.calculate(vmodArg, this.getxAxisType(), this.getyAxisType(), (String)modelLabel);
                xyPlotList.addAll(modxyPlotList);
            }
            HashMap<String, String> wavetypeColors = this.coloringArgs.getWavetypeColors();
            ArrayList<String> colorList = new ArrayList<String>();
            int idx = -1;
            for (XYPlottingData xyp : xyPlotList) {
                ++idx;
                boolean notFound = true;
                for (String wt : wavetypeColors.keySet()) {
                    if (!xyp.cssClasses.contains(wt)) continue;
                    colorList.add(wavetypeColors.get(wt));
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                colorList.add(this.coloringArgs.colorForIndex(idx));
            }
            this.coloringArgs.setColorList(colorList);
            ModelArgs modelArgs = new ModelArgs();
            modelArgs.setModelName("");
            XYPlotOutput xyOut = new XYPlotOutput(xyPlotList, null);
            title = ((String)title).substring(2);
            xyOut.setTitle(((String)title).trim());
            xyOut.setxAxisMinMax(this.xAxisMinMax);
            xyOut.setyAxisMinMax(this.yAxisMinMax);
            xyOut.setXLabel(ModelAxisType.labelFor(this.xAxisType));
            xyOut.setYLabel(ModelAxisType.labelFor(this.yAxisType));
            xyOut.setColoringArgs(this.coloringArgs);
            if (this.yAxisType == ModelAxisType.depth) {
                xyOut.setyAxisInvert(true);
            }
            this.printResult(writer, xyOut);
            writer.close();
        }
    }

    public void printResult(PrintWriter writer, XYPlotOutput xyOut) throws TauPException {
        if (this.getOutputTypeArgs().isJSON()) {
            xyOut.printAsJSON(writer, 2);
        } else if (this.getOutputTypeArgs().isText()) {
            xyOut.printAsGmtText(writer);
        } else if (this.getOutputTypeArgs().isGMT()) {
            xyOut.printAsGmtScript(writer, TauP_VelocityPlot.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), this.getOutputTypeArgs().asGraphicOutputTypeArgs(), this.isLegend);
        } else if (this.getOutputTypeArgs().isSVG()) {
            xyOut.printAsSvg(writer, TauP_VelocityPlot.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), this.outputTypeArgs.getPixelWidth(), SvgUtil.createWaveTypeColorCSS(this.coloringArgs), this.isLegend);
        } else if (this.getOutputTypeArgs().isHTML()) {
            xyOut.printAsHtml(writer, TauP_VelocityPlot.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), this.outputTypeArgs.getPixelWidth(), SvgUtil.createWaveTypeColorCSS(this.coloringArgs), this.isLegend);
        } else {
            throw new IllegalArgumentException("Unknown output format: " + this.getOutputFormat());
        }
        writer.flush();
    }

    public void printCSV(PrintWriter out, VelocityModel vMod) {
        VelocityLayer prev = null;
        boolean hasQ = !vMod.QIsDefault();
        out.print("Depth,P Velocity,S Velocity,Density");
        if (hasQ) {
            out.print(",Qp,Qs");
        }
        out.println();
        for (VelocityLayer vLayer : vMod.getLayers()) {
            if (prev == null || prev.getBotPVelocity() != vLayer.getTopPVelocity() || prev.getBotSVelocity() != vLayer.getTopSVelocity()) {
                out.print((float)vLayer.getTopDepth() + "," + (float)vLayer.getTopPVelocity() + "," + (float)vLayer.getTopSVelocity() + "," + (float)vLayer.getTopDensity());
                if (hasQ) {
                    out.print("," + (float)vLayer.getTopQp() + "," + (float)vLayer.getTopQs());
                }
                out.println();
            }
            out.print((float)vLayer.getBotDepth() + "," + (float)vLayer.getBotPVelocity() + "," + (float)vLayer.getBotSVelocity() + "," + (float)vLayer.getBotDensity());
            if (hasQ) {
                out.print("," + (float)vLayer.getBotQp() + "," + (float)vLayer.getBotQs());
            }
            out.println();
            prev = vLayer;
        }
        out.flush();
    }

    @Override
    public void init() throws TauPException {
    }

    public boolean depthLike(ModelAxisType axisType) {
        return axisType == ModelAxisType.depth || axisType == ModelAxisType.radius;
    }

    public boolean velocityLike(ModelAxisType axisType) {
        return axisType == ModelAxisType.velocity || axisType == ModelAxisType.Vp || axisType == ModelAxisType.Vs || axisType == ModelAxisType.velocity_density || axisType == ModelAxisType.density || axisType == ModelAxisType.Q || axisType == ModelAxisType.Qp || axisType == ModelAxisType.Qs || axisType == ModelAxisType.vpvs || axisType == ModelAxisType.vpdensity || axisType == ModelAxisType.vsdensity || axisType == ModelAxisType.poisson || axisType == ModelAxisType.shearmodulus || axisType == ModelAxisType.lambda || axisType == ModelAxisType.bulkmodulus || axisType == ModelAxisType.youngsmodulus;
    }

    public boolean slownessLike(ModelAxisType axisType) {
        return axisType == ModelAxisType.slownessrad || axisType == ModelAxisType.slownessrad_p || axisType == ModelAxisType.slownessrad_s || axisType == ModelAxisType.slownessdeg || axisType == ModelAxisType.slownessdeg_p || axisType == ModelAxisType.slownessdeg_s;
    }

    public ModelAxisType dependentAxis(ModelAxisType xAxisType, ModelAxisType yAxisType) {
        if (this.depthLike(yAxisType) && !this.depthLike(xAxisType)) {
            return xAxisType;
        }
        return yAxisType;
    }

    public static double calculateAtDepth(VelocityModel vMod, ModelAxisType axisType, double depth, boolean above) throws TauModelException {
        switch (axisType) {
            case radius: {
                return vMod.getRadiusOfEarth() - depth;
            }
            case depth: {
                return depth;
            }
            case density: 
            case velocity_density: {
                if (above) {
                    return vMod.evaluateAbove(depth, VelocityModelMaterial.DENSITY);
                }
                return vMod.evaluateBelow(depth, VelocityModelMaterial.DENSITY);
            }
            case velocity: 
            case Vp: {
                if (above) {
                    return vMod.evaluateAbove(depth, VelocityModelMaterial.P_VELOCITY);
                }
                return vMod.evaluateBelow(depth, VelocityModelMaterial.P_VELOCITY);
            }
            case Vs: {
                if (above) {
                    return vMod.evaluateAbove(depth, VelocityModelMaterial.S_VELOCITY);
                }
                return vMod.evaluateBelow(depth, VelocityModelMaterial.S_VELOCITY);
            }
            case Q: 
            case Qp: {
                if (above) {
                    return vMod.evaluateAbove(depth, VelocityModelMaterial.Q_P);
                }
                return vMod.evaluateBelow(depth, VelocityModelMaterial.Q_P);
            }
            case Qs: {
                if (above) {
                    return vMod.evaluateAbove(depth, VelocityModelMaterial.Q_S);
                }
                return vMod.evaluateBelow(depth, VelocityModelMaterial.Q_S);
            }
            case vpvs: 
            case vpdensity: 
            case vsdensity: 
            case poisson: 
            case shearmodulus: 
            case lambda: 
            case bulkmodulus: 
            case youngsmodulus: {
                double rho;
                double vs;
                double vp;
                if (above) {
                    vp = vMod.evaluateAbove(depth, VelocityModelMaterial.P_VELOCITY);
                    vs = vMod.evaluateAbove(depth, VelocityModelMaterial.S_VELOCITY);
                    rho = vMod.evaluateAbove(depth, VelocityModelMaterial.DENSITY);
                } else {
                    vp = vMod.evaluateBelow(depth, VelocityModelMaterial.P_VELOCITY);
                    vs = vMod.evaluateBelow(depth, VelocityModelMaterial.S_VELOCITY);
                    rho = vMod.evaluateBelow(depth, VelocityModelMaterial.DENSITY);
                }
                double mu = vs * vs * rho;
                double lambda = vp * vp * rho - 2.0 * mu;
                switch (axisType) {
                    case vpvs: {
                        return vp / vs;
                    }
                    case vpdensity: {
                        return vp / rho;
                    }
                    case vsdensity: {
                        return vs / rho;
                    }
                    case poisson: {
                        return (vp * vp / 2.0 - vs * vs) / (vp * vp - vs * vs);
                    }
                    case shearmodulus: {
                        return mu;
                    }
                    case lambda: {
                        return lambda;
                    }
                    case bulkmodulus: {
                        return lambda + 2.0 * mu / 3.0;
                    }
                    case youngsmodulus: {
                        return mu * ((3.0 * lambda + 2.0 * mu) / (lambda + mu));
                    }
                }
            }
        }
        throw new TauModelException(String.valueOf((Object)axisType) + " is not a velocity model property");
    }

    public static double calculateAtDepth(TauModel tMod, ModelAxisType axisType, double depth, boolean above) throws TauModelException {
        switch (axisType) {
            case radius: {
                return tMod.getRadiusOfEarth() - depth;
            }
            case depth: {
                return depth;
            }
            case vpvs: 
            case vpdensity: 
            case vsdensity: 
            case poisson: 
            case shearmodulus: 
            case lambda: 
            case bulkmodulus: 
            case youngsmodulus: 
            case density: 
            case velocity_density: 
            case velocity: 
            case Vp: 
            case Vs: 
            case Q: 
            case Qp: 
            case Qs: {
                return TauP_VelocityPlot.calculateAtDepth(tMod.getVelocityModel(), axisType, depth, above);
            }
            case slownessrad_s: 
            case slownessdeg_s: {
                if (TauP_VelocityPlot.calculateAtDepth(tMod.getVelocityModel(), ModelAxisType.Vs, depth, above) == 0.0) {
                    return Double.NaN;
                }
            }
            case slownessrad: 
            case slownessrad_p: 
            case slownessdeg: 
            case slownessdeg_p: {
                boolean isPWave = axisType != ModelAxisType.slownessrad_s && axisType != ModelAxisType.slownessdeg_s;
                SlownessLayer slayer = above ? tMod.getSlownessModel().layerAbove(depth, isPWave) : tMod.getSlownessModel().layerBelow(depth, isPWave);
                try {
                    double slowness = slayer.evaluateAt_bullen(depth, tMod.getRadiusOfEarth());
                    if (axisType == ModelAxisType.slownessdeg || axisType == ModelAxisType.slownessdeg_p || axisType == ModelAxisType.slownessdeg_s) {
                        slowness /= 57.29577951308232;
                    }
                    return slowness;
                }
                catch (SlownessModelException e) {
                    throw new TauModelException(e);
                }
            }
        }
        throw new TauModelException(String.valueOf((Object)axisType) + " not a simple material property");
    }

    public List<XYPlottingData> calculate(InputVelocityModelArgs velModelArgs, ModelAxisType xAxis, ModelAxisType yAxis, String labelPrefix) throws IOException, TauModelException, SlownessModelException {
        String modelName;
        ArrayList<XYPlottingData> xyList = new ArrayList<XYPlottingData>();
        ArrayList<Double> xVals = new ArrayList<Double>();
        ArrayList<Double> yVals = new ArrayList<Double>();
        if ((this.velocityLike(xAxis) || this.depthLike(xAxis)) && (this.velocityLike(yAxis) || this.depthLike(yAxis))) {
            VelocityModel vMod = TauModelLoader.loadVelocityModel(velModelArgs.getModelFilename(), velModelArgs.getVelFileType());
            modelName = vMod.getModelName();
            double depth = vMod.getVelocityLayer(0).getTopDepth();
            xVals.add(TauP_VelocityPlot.calculateAtDepth(vMod, xAxis, depth, false));
            yVals.add(TauP_VelocityPlot.calculateAtDepth(vMod, yAxis, depth, false));
            for (VelocityLayer vLayer : vMod.getLayers()) {
                if (vLayer.getThickness() > 0.0 && vMod.isDisconDepth(vLayer.getTopDepth())) {
                    xVals.add(TauP_VelocityPlot.calculateAtDepth(vMod, xAxis, vLayer.getTopDepth(), false));
                    yVals.add(TauP_VelocityPlot.calculateAtDepth(vMod, yAxis, vLayer.getTopDepth(), false));
                }
                xVals.add(TauP_VelocityPlot.calculateAtDepth(vMod, xAxis, vLayer.getBotDepth(), true));
                yVals.add(TauP_VelocityPlot.calculateAtDepth(vMod, yAxis, vLayer.getBotDepth(), true));
            }
        } else {
            TauModel tMod = TauModelLoader.load(velModelArgs.getModelFilename(), velModelArgs.getVelFileType());
            modelName = tMod.getModelName();
            SlownessModel sMod = tMod.getSlownessModel();
            boolean defWaveType = xAxis != ModelAxisType.slownessrad_s && yAxis != ModelAxisType.slownessrad_s;
            xVals.add(TauP_VelocityPlot.calculateAtDepth(tMod, xAxis, sMod.getSlownessLayer(0, defWaveType).getTopDepth(), false));
            yVals.add(TauP_VelocityPlot.calculateAtDepth(tMod, yAxis, sMod.getSlownessLayer(0, defWaveType).getTopDepth(), false));
            for (SlownessLayer layer : sMod.getAllSlownessLayers(defWaveType)) {
                if (!layer.isZeroThickness()) {
                    xVals.add(TauP_VelocityPlot.calculateAtDepth(tMod, xAxis, layer.getTopDepth(), false));
                    yVals.add(TauP_VelocityPlot.calculateAtDepth(tMod, yAxis, layer.getTopDepth(), false));
                }
                xVals.add(TauP_VelocityPlot.calculateAtDepth(tMod, xAxis, layer.getBotDepth(), true));
                yVals.add(TauP_VelocityPlot.calculateAtDepth(tMod, yAxis, layer.getBotDepth(), true));
            }
        }
        ArrayList<Double> xValDedup = new ArrayList<Double>();
        ArrayList<Double> yValDedup = new ArrayList<Double>();
        Double prevX = (Double)xVals.get(0);
        Double prevY = (Double)yVals.get(0);
        xValDedup.add(prevX);
        yValDedup.add(prevY);
        for (int i = 1; i < xVals.size(); ++i) {
            Double currX = (Double)xVals.get(i);
            Double currY = (Double)yVals.get(i);
            if (Objects.equals(currX, prevX) && Objects.equals(currY, prevY)) continue;
            xValDedup.add(currX);
            yValDedup.add(currY);
            prevX = currX;
            prevY = currY;
        }
        xVals = xValDedup;
        yVals = yValDedup;
        double[] xDbl = new double[xVals.size()];
        double[] yDbl = new double[yVals.size()];
        for (int i = 0; i < xVals.size(); ++i) {
            xDbl[i] = (Double)xVals.get(i);
            yDbl[i] = (Double)yVals.get(i);
        }
        ArrayList<XYSegment> segList = new ArrayList<XYSegment>();
        segList.addAll(new XYSegment(xDbl, yDbl).recalcForInfinite(false, false));
        ArrayList<String> cssClassList = new ArrayList<String>();
        String legendLabel = yAxis == ModelAxisType.depth || yAxis == ModelAxisType.radius ? ModelAxisType.legendFor(xAxis) : ModelAxisType.legendFor(yAxis);
        if (xAxis == ModelAxisType.Vp || xAxis == ModelAxisType.velocity || yAxis == ModelAxisType.Vp || yAxis == ModelAxisType.velocity || xAxis == ModelAxisType.slownessrad_p || xAxis == ModelAxisType.slownessrad || yAxis == ModelAxisType.slownessrad_p || yAxis == ModelAxisType.slownessrad || xAxis == ModelAxisType.slownessdeg_p || xAxis == ModelAxisType.slownessdeg || yAxis == ModelAxisType.slownessdeg_p || yAxis == ModelAxisType.slownessdeg || xAxis == ModelAxisType.Qp || xAxis == ModelAxisType.Q || yAxis == ModelAxisType.Qp || yAxis == ModelAxisType.Q) {
            cssClassList.add("pwave");
        } else if (xAxis == ModelAxisType.Vs || yAxis == ModelAxisType.Vs || xAxis == ModelAxisType.slownessrad_s || yAxis == ModelAxisType.slownessrad_s || xAxis == ModelAxisType.slownessdeg_s || yAxis == ModelAxisType.slownessdeg_s || xAxis == ModelAxisType.Qs || yAxis == ModelAxisType.Qs) {
            cssClassList.add("swave");
        } else {
            cssClassList.add("both_p_swave");
        }
        XYPlottingData xyplot = new XYPlottingData(segList, xAxis.name(), yAxis.name(), (labelPrefix + " " + legendLabel).trim(), modelName + " " + ModelAxisType.labelFor(xAxis) + " / " + ModelAxisType.labelFor(yAxis), cssClassList);
        xyList.add(xyplot);
        if (xAxis == ModelAxisType.velocity) {
            xyList.addAll(this.calculate(velModelArgs, ModelAxisType.Vs, yAxis, labelPrefix));
        }
        if (yAxis == ModelAxisType.velocity) {
            xyList.addAll(this.calculate(velModelArgs, xAxis, ModelAxisType.Vs, labelPrefix));
        }
        if (xAxis == ModelAxisType.velocity_density) {
            xyList.addAll(this.calculate(velModelArgs, ModelAxisType.velocity, yAxis, labelPrefix));
        }
        if (yAxis == ModelAxisType.velocity_density) {
            xyList.addAll(this.calculate(velModelArgs, xAxis, ModelAxisType.velocity, labelPrefix));
        }
        if (xAxis == ModelAxisType.Q) {
            xyList.addAll(this.calculate(velModelArgs, ModelAxisType.Qs, yAxis, labelPrefix));
        }
        if (yAxis == ModelAxisType.Q) {
            xyList.addAll(this.calculate(velModelArgs, xAxis, ModelAxisType.Qs, labelPrefix));
        }
        if (xAxis == ModelAxisType.slownessrad || xAxis == ModelAxisType.slownessdeg) {
            xyList.addAll(this.calculate(velModelArgs, xAxis == ModelAxisType.slownessrad ? ModelAxisType.slownessrad_s : ModelAxisType.slownessdeg_s, yAxis, labelPrefix));
        }
        if (yAxis == ModelAxisType.slownessrad || yAxis == ModelAxisType.slownessdeg) {
            xyList.addAll(this.calculate(velModelArgs, xAxis, yAxis == ModelAxisType.slownessrad ? ModelAxisType.slownessrad_s : ModelAxisType.slownessdeg_s, labelPrefix));
        }
        return xyList;
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        if (this.velModelArgs.size() == 0) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "must give at least one model");
        }
        if (Objects.equals(this.getOutputFormat(), "nd") && (this.xAxisType != ModelAxisType.velocity || this.yAxisType != ModelAxisType.depth)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "cannot specify axis type for --nd output");
        }
        if (!this.outputTypeArgs.isCSV() && !this.outputTypeArgs.isND()) {
            try {
                if (ModelAxisType.needsDensity(this.xAxisType) || ModelAxisType.needsDensity(this.yAxisType)) {
                    for (VelocityModel vMod : this.getVelModelArgs().getVelocityModels()) {
                        if (!vMod.densityIsDefault()) continue;
                        throw new TauModelException("model " + vMod.getModelName() + " does not include density, but " + String.valueOf((Object)this.xAxisType) + "/" + String.valueOf((Object)this.yAxisType) + " requires density.");
                    }
                }
                if (ModelAxisType.needsQ(this.xAxisType) || ModelAxisType.needsQ(this.yAxisType)) {
                    for (VelocityModel vMod : this.getVelModelArgs().getVelocityModels()) {
                        if (!vMod.QIsDefault()) continue;
                        throw new TauModelException("model " + vMod.getModelName() + " does not include Q, but " + String.valueOf((Object)this.xAxisType) + "/" + String.valueOf((Object)this.yAxisType) + " requires Q.");
                    }
                }
            }
            catch (IOException e) {
                throw new TauPException(e);
            }
        }
    }

    public VelPlotOutputTypeArgs getOutputTypeArgs() {
        return this.outputTypeArgs;
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    public VelocityModelListArgs getVelModelArgs() {
        return this.velModelArgs;
    }

    public ModelAxisType getxAxisType() {
        return this.xAxisType;
    }

    @CommandLine.Option(names={"-x", "--xaxis"}, paramLabel="type", description={"X axis data type, one of ${COMPLETION-CANDIDATES}", "Default is ${DEFAULT-VALUE}."}, defaultValue="velocity")
    public void setxAxisType(ModelAxisType xAxisType) {
        this.xAxisType = xAxisType;
    }

    public ModelAxisType getyAxisType() {
        return this.yAxisType;
    }

    @CommandLine.Option(names={"-y", "--yaxis"}, paramLabel="type", description={"Y axis data type, one of ${COMPLETION-CANDIDATES}", "Default is ${DEFAULT-VALUE}."}, defaultValue="depth")
    public void setyAxisType(ModelAxisType yAxisType) {
        this.yAxisType = yAxisType;
    }

    public double[] getxAxisMinMax() {
        return this.xAxisMinMax;
    }

    @CommandLine.Option(names={"--xminmax"}, arity="2", paramLabel="x", description={"min and max x axis for plotting"})
    public void setxAxisMinMax(double[] xAxisMinMax) {
        this.xAxisMinMax = xAxisMinMax;
    }

    public double[] getyAxisMinMax() {
        return this.yAxisMinMax;
    }

    @CommandLine.Option(names={"--yminmax"}, arity="2", paramLabel="y", description={"min and max y axis for plotting"})
    public void setyAxisMinMax(double[] yAxisMinMax) {
        this.yAxisMinMax = yAxisMinMax;
    }
}

