/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.BuildVersion;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.MomentMagnitude;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.Theta;
import edu.sc.seis.TauP.cmdline.TauP_AbstractPhaseTool;
import edu.sc.seis.TauP.cmdline.TauP_Time;
import edu.sc.seis.TauP.cmdline.args.DistanceLengthArgs;
import edu.sc.seis.TauP.cmdline.args.GeodeticArgs;
import edu.sc.seis.TauP.cmdline.args.QmlStaxmlArgs;
import edu.sc.seis.TauP.cmdline.args.SeismicSourceArgs;
import edu.sc.seis.TauP.cmdline.args.SeismogramOutputTypeArgs;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import edu.sc.seis.seisFile.fdsnws.quakeml.Time;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.MSeed3Convert;
import edu.sc.seis.seisFile.mseed3.MSeed3EH;
import edu.sc.seis.seisFile.mseed3.MSeed3Record;
import edu.sc.seis.seisFile.mseed3.ehbag.Marker;
import edu.sc.seis.seisFile.mseed3.ehbag.Path;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONObject;
import picocli.CommandLine;

@CommandLine.Command(name="spikes", description={"Calculate spike seismograms"}, optionListHeading="%nOptions:%n%n", usageHelpAutoWidth=true)
public class TauP_Spikes
extends TauP_AbstractPhaseTool {
    public static final int RAD_IDX = 0;
    public static final int TRANS_IDX = 1;
    public static final int VERT_IDX = 2;
    DataOutputStream writer;
    ZonedDateTime defaultOriginTime = ZonedDateTime.of(2000, 1, 1, 0, 0, 0, 0, ZoneId.of("UTC"));
    @CommandLine.Mixin
    SeismicSourceArgs sourceArgs = new SeismicSourceArgs();
    @CommandLine.Option(names={"--otime"}, description={"event origin time, as ISO8601 yyyy-MM-ddTHH:mm:ss.SZ, append Z for UTC times"})
    ZonedDateTime origintime;
    @CommandLine.Mixin
    SeismogramOutputTypeArgs outputTypeArgs;
    @CommandLine.Option(names={"sps"}, defaultValue="20", description={"Samples per second for the output seismogram, defaults to $DEFAULT_VALUE"})
    protected double sps = 20.0;
    @CommandLine.Option(names={"--pulsewidth"}, defaultValue="1.0", description={"Width in seconds of the spike pulse for each arrival"})
    double pulseWidth = 1.0;
    @CommandLine.Mixin
    DistanceLengthArgs distanceArgs = new DistanceLengthArgs();
    @CommandLine.ArgGroup(validate=false, heading="Lat,Lon influenced by:%n")
    GeodeticArgs geodeticArgs = new GeodeticArgs();
    @CommandLine.Mixin
    QmlStaxmlArgs qmlStaxmlArgs = new QmlStaxmlArgs();

    public TauP_Spikes() {
        super(new SeismogramOutputTypeArgs("ms3", "taup_spikes"));
        this.outputTypeArgs = (SeismogramOutputTypeArgs)this.abstractOutputTypeArgs;
    }

    public double getDeltaT() {
        return 1.0 / this.sps;
    }

    public void setDeltaT(double v) {
        this.sps = 1.0 / v;
    }

    @Override
    public void validateArguments() throws TauPException {
        if (!this.getOutputFormat().equals("ms3") && !this.getOutputFormat().equals("sac")) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Unsupported Output Format: " + this.getOutputFormat());
        }
        if (this.modelArgs.getSourceDepths().size() > 1) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Multiple source depths unsupported: " + this.modelArgs.getSourceDepths().size());
        }
        this.sourceArgs.validateArguments();
        this.sourceArgs.validateArgumentsForAmplitude(this.modelArgs, this.getRayCalculatables());
    }

    @Override
    public void init() throws TauPException {
        super.init();
    }

    @Override
    public void start() throws IOException, TauPException {
        block8: {
            this.validateArguments();
            try {
                List<RayCalculateable> rays = this.getRayCalculatables();
                ArrayList<MSeed3Record> allRecords = new ArrayList<MSeed3Record>();
                List<MSeed3Record> spikeRecords = this.calcSpikes(rays);
                allRecords.addAll(spikeRecords);
                if (this.outputTypeArgs.isMS3()) {
                    this.setOutFileBase("taup_spikes");
                    DataOutputStream dos = this.getOutputStream();
                    for (MSeed3Record ms3 : allRecords) {
                        dos.write(ms3.asByteBuffer().array());
                    }
                    dos.close();
                    break block8;
                }
                if (this.outputTypeArgs.isSAC()) {
                    try {
                        for (MSeed3Record ms3r : allRecords) {
                            SacTimeSeries sac = MSeed3Convert.convert3ToSac((MSeed3Record)ms3r);
                            this.setOutFileBase("taup_spikes_" + sac.getHeader().getGcarc() + "_" + sac.getHeader().getKcmpnm());
                            DataOutputStream dos = this.getOutputStream();
                            sac.write(dos);
                            dos.close();
                            this.writer = null;
                        }
                        break block8;
                    }
                    catch (CodecException | SeedFormatException e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new TauPException("Unknown output type: " + this.getOutputFormat());
            }
            catch (IOException e) {
                throw new TauPException(e);
            }
        }
    }

    public List<MSeed3Record> calcSpikes(List<RayCalculateable> degreesList) throws TauPException {
        ArrayList<MSeed3Record> spikeRecords = new ArrayList<MSeed3Record>();
        for (double sourceDepth : this.getSourceDepths()) {
            for (double receiverDepth : this.getReceiverDepths()) {
                List<SeismicPhase> phaseList = this.calcSeismicPhases(sourceDepth, List.of(Double.valueOf(receiverDepth)), this.modelArgs.getScatterer());
                spikeRecords.addAll(this.calcSpikes(degreesList, phaseList));
            }
        }
        return spikeRecords;
    }

    public List<MSeed3Record> calcSpikes(List<RayCalculateable> rayList, List<SeismicPhase> phaseList) throws TauPException {
        ArrayList<MSeed3Record> spikeRecords = new ArrayList<MSeed3Record>();
        ArrayList<DistanceRay> degreesList = new ArrayList<DistanceRay>();
        HashSet<Double> distFromArrival = new HashSet<Double>();
        for (RayCalculateable ray : rayList) {
            if (!ray.hasSeismicSource()) {
                ray.setSeismicSource(this.sourceArgs.getSeismicSource());
            }
            if (ray instanceof DistanceRay) {
                degreesList.add((DistanceRay)ray);
                continue;
            }
            ArrayList<Arrival> rayArrivals = new ArrayList<Arrival>();
            for (SeismicPhase phase : phaseList) {
                if (!TauP_Time.isRayOkForPhase(ray, phase)) continue;
                rayArrivals.addAll(ray.calculate(phase));
            }
            for (Arrival arr : rayArrivals) {
                distFromArrival.add(arr.getDist());
            }
        }
        for (Double radian : distFromArrival) {
            DistanceAngleRay dr = DistanceRay.ofRadians(radian);
            if (!dr.hasAzimuth() && this.geodeticArgs.hasAzimuth()) {
                dr.setAzimuth(this.geodeticArgs.getAzimuth());
            }
            dr.setSeismicSource(this.sourceArgs.getSeismicSource());
            degreesList.add(dr);
        }
        for (DistanceRay dr : degreesList) {
            ArrayList<Arrival> allArrivals = new ArrayList<Arrival>();
            ArrayList<MSeed3Record> componentRecords = new ArrayList<MSeed3Record>();
            double degrees = dr.getDegrees(this.getRadiusOfEarth());
            for (SeismicPhase phase : phaseList) {
                List<Arrival> phaseArrivals = dr.calculate(phase);
                allArrivals.addAll(phaseArrivals);
            }
            Arrival last = Arrival.getLatestArrival(allArrivals);
            double lastTime = last == null ? 0.0 : last.getTime();
            int startTime = 0;
            double maxTime = lastTime - (double)startTime + 200.0;
            int numSamples = (int)Math.ceil(maxTime / this.getDeltaT());
            float[] radial = new float[numSamples];
            float[] vertical = new float[numSamples];
            float[] transverse = new float[numSamples];
            for (Arrival arrival : allArrivals) {
                double shAmpFactor;
                int timeIdx = (int)Math.ceil((arrival.getTime() - (double)startTime) / this.getDeltaT());
                double psvAmpFactor = arrival.getAmplitudeFactorPSV();
                if (!Double.isFinite(psvAmpFactor)) {
                    psvAmpFactor = 0.0;
                }
                if (!Double.isFinite(shAmpFactor = arrival.getAmplitudeFactorSH())) {
                    shAmpFactor = 0.0;
                }
                double incidentAngle = arrival.getIncidentAngleDegree();
                double rotateAngle = 0.0;
                if (!arrival.getPhase().finalSegmentIsPWave()) {
                    rotateAngle = 90.0;
                }
                incidentAngle += rotateAngle;
                int width = (int)Math.round(this.pulseWidth * this.sps) + 1;
                if (width < 2) {
                    width = 2;
                }
                float t = (float)shAmpFactor;
                float r = (float)(psvAmpFactor * Math.cos(incidentAngle * Math.PI / 180.0));
                float v = (float)(psvAmpFactor * Math.sin(incidentAngle * Math.PI / 180.0));
                for (int w = 0; w < width; ++w) {
                    int n = timeIdx + w;
                    transverse[n] = transverse[n] + t;
                    int n2 = timeIdx + w;
                    radial[n2] = radial[n2] + r;
                    int n3 = timeIdx + w;
                    vertical[n3] = vertical[n3] + v;
                }
            }
            Object staCode = null;
            if (dr.hasReceiver()) {
                if (dr.getReceiver() instanceof Station) {
                    Station sta = (Station)dr.getReceiver();
                    staCode = sta.getStationCode();
                } else if (dr.getReceiver() instanceof Channel) {
                    Channel chan = (Channel)dr.getReceiver();
                    staCode = chan.getStationCode();
                }
            }
            if (staCode == null) {
                staCode = "S" + degrees;
                if (((String)(staCode = ((String)staCode).replace(".", ""))).length() > 8) {
                    staCode = ((String)staCode).substring(8);
                }
            }
            componentRecords.add(this.packageMSeed3(vertical, (String)staCode, "SP", "Z", startTime));
            componentRecords.add(this.packageMSeed3(radial, (String)staCode, "SP", "R", startTime));
            componentRecords.add(this.packageMSeed3(transverse, (String)staCode, "SP", "T", startTime));
            for (MSeed3Record ms3 : componentRecords) {
                MSeed3EH eh = this.createEH(dr, this.getOriginTime(), allArrivals, ms3.getSourceId());
                ms3.setStartDateTime(this.getOriginTime());
                ms3.setExtraHeaders(eh.getEH());
            }
            spikeRecords.addAll(componentRecords);
        }
        return spikeRecords;
    }

    public MSeed3EH createEH(DistanceRay dr, ZonedDateTime startDateTime, List<Arrival> allArrivals, FDSNSourceId sourceId) throws TauPException {
        MSeed3EH eh = new MSeed3EH();
        double sourceDepth = this.modelArgs.getSourceDepths().isEmpty() ? 0.0 : this.modelArgs.getSourceDepths().get(0);
        Float deg = Float.valueOf((float)dr.getDegrees(this.getRadiusOfEarth()));
        Float az = dr.hasAzimuth() ? Float.valueOf(dr.getAzimuth().floatValue()) : null;
        Float baz = dr.hasBackAzimuth() ? Float.valueOf(dr.getBackAzimuth().floatValue()) : null;
        Origin origin = new Origin();
        origin.setDepth(new RealQuantity((float)sourceDepth));
        origin.setTime(new Time(startDateTime.toInstant()));
        float olat = 0.0f;
        float olon = 0.0f;
        if (dr.hasSource()) {
            Location loc = dr.getSource().asLocation();
            olat = (float)loc.getLatitude();
            olon = (float)loc.getLongitude();
        }
        origin.setLatitude(new RealQuantity(olat));
        origin.setLongitude(new RealQuantity(olon));
        Event event = new Event(origin);
        event.setPreferredOriginID(origin.getPublicId());
        Magnitude mag = new Magnitude();
        mag.setMag(new RealQuantity(this.sourceArgs.getMw()));
        mag.setType("Mw");
        event.setMagnitudeList(List.of(mag));
        event.setPreferredMagnitudeID(mag.getPublicId());
        eh.addToBag(event);
        for (Arrival a : allArrivals) {
            ZonedDateTime arrTime = startDateTime.plusNanos(Math.round(a.getTime() * 1.0E9));
            String desc = "";
            Marker m = new Marker(a.getName(), arrTime, "md", desc);
            eh.addToBag(m);
        }
        Marker oMarker = new Marker("origin", startDateTime, "md", "");
        eh.addToBag(oMarker);
        Station sta = new Station(new Network(sourceId.getNetworkCode()), sourceId.getStationCode());
        if (dr.hasReceiver()) {
            sta.setLatitude((float)dr.getReceiver().asLocation().getLatitude());
            sta.setLongitude((float)dr.getReceiver().asLocation().getLongitude());
        } else if (dr.hasAzimuth() && !dr.isGeodetic()) {
            sta.setLatitude((float)SphericalCoords.latFor(origin.asLocation(), dr.getDegrees(this.getRadiusOfEarth()), dr.getAzimuth()));
            sta.setLongitude((float)SphericalCoords.lonFor(origin.asLocation(), dr.getDegrees(this.getRadiusOfEarth()), dr.getAzimuth()));
        }
        Channel chan = new Channel(sta, sourceId.getLocationCode(), sourceId.getChannelCode());
        chan.setSourceId(sourceId.toString());
        if (dr.hasReceiver() && dr.getReceiver().asLocation().hasDepth()) {
            chan.setDepth(dr.getReceiver().asLocation().getDepthMeter().floatValue());
            chan.setElevation(-1.0f * dr.getReceiver().asLocation().getDepthMeter().floatValue());
        } else {
            chan.setDepth(0.0f);
            chan.setElevation(0.0f);
        }
        if (sta.getLatitude() != null && sta.getLongitude() != null && origin != null && chan.asLocation() != null) {
            if (az == null && !dr.isGeodetic()) {
                az = Float.valueOf((float)SphericalCoords.azimuth(origin.asLocation(), chan.asLocation()));
            }
            if (baz == null && !dr.isGeodetic()) {
                baz = Float.valueOf((float)SphericalCoords.azimuth(chan.asLocation(), origin.asLocation()));
            }
        }
        Path path = new Path(deg, az, baz);
        eh.addToBag(path);
        if (sourceId.getSubsourceCode().charAt(0) == 'Z') {
            chan.setAzimuth(0.0f);
            chan.setDip(-90.0f);
        } else if (sourceId.getSubsourceCode().charAt(0) == 'R') {
            if (baz != null) {
                chan.setAzimuth((baz.floatValue() + 180.0f) % 360.0f);
            }
            chan.setDip(0.0f);
        } else if (sourceId.getSubsourceCode().charAt(0) == 'T') {
            if (baz != null) {
                chan.setAzimuth((baz.floatValue() + 180.0f + 90.0f) % 360.0f);
            }
            chan.setDip(0.0f);
        }
        eh.addToBag(chan);
        eh.setTimeseriesUnit("m");
        JSONObject bagEh = eh.getBagEH();
        if (!bagEh.has("y")) {
            bagEh.put("y", (Object)new JSONObject());
        }
        JSONObject y = bagEh.getJSONObject("y");
        y.put("proc", (Object)"synth");
        if (!y.has("req")) {
            y.put("req", (Object)new JSONObject());
        }
        JSONObject req = y.getJSONObject("req");
        req.put("dc", (Object)("TauP" + BuildVersion.getVersion()));
        return eh;
    }

    public List<MSeed3Record> packageMSeed3(float[] vertical, float[] radial, float[] transverse, String staCode, int startSecOffset) {
        ArrayList<MSeed3Record> mSeed3Records = new ArrayList<MSeed3Record>();
        mSeed3Records.add(this.packageMSeed3(vertical, staCode, "W", "Z", startSecOffset));
        mSeed3Records.add(this.packageMSeed3(radial, staCode, "W", "R", startSecOffset));
        mSeed3Records.add(this.packageMSeed3(transverse, staCode, "W", "T", startSecOffset));
        return mSeed3Records;
    }

    public MSeed3Record packageMSeed3(float[] data, String staCode, String sourceCode, String subsourceCode, int startSecOffset) {
        MSeed3Record ms3RecZ = new MSeed3Record();
        String bandCode = "B";
        ms3RecZ.setSourceId(new FDSNSourceId("XX", staCode, "00", bandCode, sourceCode, subsourceCode));
        ms3RecZ.setSampleRatePeriod(-1.0 * this.getDeltaT());
        ms3RecZ.setTimeseries(data);
        ZonedDateTime startDT = ms3RecZ.getStartDateTime().plusSeconds(startSecOffset);
        ms3RecZ.setStartDateTime(startDT);
        return ms3RecZ;
    }

    public List<MSeed3Record> calcWKBJ(List<DistanceRay> degreesList) throws TauPException {
        this.validateArguments();
        List<SeismicPhase> phaseList = this.getSeismicPhases();
        ArrayList<MSeed3Record> spikeRecords = new ArrayList<MSeed3Record>();
        float[][] sourceTerm = TauP_Spikes.effectiveSourceTerm(this.sourceArgs.getMw(), (float)(1.0 / this.sps), 1000);
        Instant sourceTime = new MSeed3Record().getStartInstant();
        for (DistanceRay dr : degreesList) {
            double degrees = dr.getDegrees(this.getRadiusOfEarth());
            ArrayList<Arrival> allArrivals = new ArrayList<Arrival>();
            for (SeismicPhase phase : phaseList) {
                List<Arrival> phaseArrivals = dr.calculate(phase);
                allArrivals.addAll(phaseArrivals);
            }
            Arrival first = Arrival.getEarliestArrival(allArrivals);
            double firstTime = first == null ? 0.0 : first.getTime();
            Arrival last = Arrival.getLatestArrival(allArrivals);
            double lastTime = last == null ? 0.0 : last.getTime();
            int startTime = (int)(Math.round(firstTime) - 10L);
            startTime = 0;
            double maxTime = lastTime - (double)startTime + 200.0;
            int numSamples = (int)Math.ceil(maxTime / this.getDeltaT());
            float[][] theta_rtz = TauP_Spikes.calcThetaTimeseriesRTZ(degrees, allArrivals, startTime, this.getDeltaT(), numSamples);
            float[][] rtz = TauP_Spikes.calcThetaTimeseriesRTZ(degrees, allArrivals, startTime, this.getDeltaT(), numSamples);
            rtz[0] = TauP_Spikes.dumbconvolve(rtz[0], sourceTerm[0]);
            rtz[1] = TauP_Spikes.dumbconvolve(rtz[1], sourceTerm[1]);
            rtz[2] = TauP_Spikes.dumbconvolve(rtz[2], sourceTerm[2]);
            Object staCode = "S" + Math.round(degrees);
            if (((String)staCode).length() > 8) {
                staCode = ((String)staCode).substring(8);
            }
            spikeRecords.addAll(this.packageMSeed3(rtz[2], rtz[0], rtz[1], (String)staCode, startTime));
            spikeRecords.add(this.packageMSeed3(theta_rtz[2], (String)staCode, "THETA", "Z", startTime));
            for (MSeed3Record msr : spikeRecords) {
                MSeed3EH eh = this.createEH(dr, this.getOriginTime(), allArrivals, msr.getSourceId());
                msr.setExtraHeaders(eh.getEH());
                msr.setStartDateTime(this.getOriginTime());
            }
            spikeRecords.add(this.packageMSeed3(sourceTerm[0], (String)staCode, "XS", "Z", startTime));
            spikeRecords.add(this.packageMSeed3(sourceTerm[3], (String)staCode, "TR", "Z", startTime));
            spikeRecords.add(this.packageMSeed3(sourceTerm[4], (String)staCode, "2HS", "Z", startTime));
        }
        return spikeRecords;
    }

    public static float[] dumbconvolve(float[] a, float[] b) {
        float[] out = new float[a.length + b.length];
        for (int i = 0; i < out.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (i < j || i - j >= a.length) continue;
                int n = i;
                out[n] = out[n] + a[i - j] * b[j];
            }
        }
        return out;
    }

    public static void trapazoid(float[] data, float m, float rise, float dur, float deltaT) {
        int i;
        int riseIdx = (int)Math.ceil(rise / deltaT);
        int end = (int)Math.ceil((2.0f * rise + dur) / deltaT);
        if (end >= data.length) {
            throw new ArrayIndexOutOfBoundsException("Trapazoid wider than data, " + end + " >= " + data.length);
        }
        for (i = 0; i <= riseIdx; ++i) {
            data[i] = m * (float)i / (rise / deltaT);
            data[Math.round((float)((2.0f * rise + dur) / deltaT - (float)i))] = m * (float)i / (rise / deltaT);
        }
        while ((float)i < (rise + dur) / deltaT) {
            data[i] = m;
            ++i;
        }
    }

    public static void secondDerivative(float[] data, float deltaT) {
        float p;
        float c = 0.0f;
        float n = data[0];
        for (int i = 0; i < data.length - 1; ++i) {
            p = c;
            c = n;
            n = data[i + 1];
            data[i] = (p - 2.0f * c + n) / (deltaT * deltaT);
        }
        p = c;
        c = n;
        n = 0.0f;
        data[data.length - 1] = (p - 2.0f * c + n) / (deltaT * deltaT);
    }

    public static void boxcar(float[] data, float val, float dur, float deltaT) {
        int end = Math.round(dur / deltaT);
        for (int i = 0; i < end; ++i) {
            data[i] = val;
        }
    }

    public static void boxcarDerivative(float[] data, float val, float dur, float deltaT) {
        int end = Math.round(dur / deltaT);
        data[0] = val;
        data[end] = -val;
        for (int i = 1; i < end; ++i) {
            data[i] = 0.0f;
        }
    }

    public static void heavyside2ndDerivative(float[] data, float val, float deltaT) {
        int offset = 10;
        data[offset] = val / deltaT / deltaT;
        data[offset + 1] = -1.0f * data[offset];
    }

    public static float[][] effectiveSourceTerm(float momentMag, float deltaT, int numSamples) {
        float Mo = (float)MomentMagnitude.mw_to_N_m(momentMag);
        float[] radial = new float[numSamples];
        float[] vertical = new float[numSamples];
        float[] transverse = new float[numSamples];
        TauP_Spikes.heavyside2ndDerivative(radial, Mo, deltaT);
        TauP_Spikes.heavyside2ndDerivative(vertical, Mo, deltaT);
        TauP_Spikes.heavyside2ndDerivative(transverse, Mo, deltaT);
        float[] heavysideOverSqrtT = new float[numSamples];
        for (int i = 1; i < heavysideOverSqrtT.length; ++i) {
            heavysideOverSqrtT[i] = (float)(1.0 / Math.sqrt((float)i * deltaT));
        }
        heavysideOverSqrtT[0] = (float)((double)heavysideOverSqrtT[1] + 1.0 / Math.sqrt(deltaT));
        float[][] out = new float[5][];
        out[0] = TauP_Spikes.dumbconvolve(radial, heavysideOverSqrtT);
        out[1] = TauP_Spikes.dumbconvolve(transverse, heavysideOverSqrtT);
        out[2] = TauP_Spikes.dumbconvolve(vertical, heavysideOverSqrtT);
        float[] trap = new float[numSamples];
        TauP_Spikes.heavyside2ndDerivative(trap, Mo, deltaT);
        out[3] = trap;
        float[] trapSecD = new float[numSamples];
        out[4] = heavysideOverSqrtT;
        return out;
    }

    public static float[][] calcThetaTimeseriesRTZ(double degrees, List<Arrival> allArrivals, int startTime, double deltaT, int numSamples) throws TauPException {
        float[] radial = new float[numSamples];
        float[] vertical = new float[numSamples];
        float[] transverse = new float[numSamples];
        float[][] rtz = new float[][]{radial, transverse, vertical};
        if (allArrivals.isEmpty()) {
            return rtz;
        }
        double radiusEarthMeter = allArrivals.get(0).getTauModel().getRadiusOfEarth() * 1000.0;
        block4: for (Arrival arrival : allArrivals) {
            Theta thetaAtX = new Theta(arrival);
            double minRayParam = arrival.getPhase().getMinRayParam();
            double rayParam = thetaAtX.getMaxRayParam();
            double theta = thetaAtX.getTheta(rayParam);
            double nextRayParam = thetaAtX.getStepRayParam(rayParam, deltaT);
            double nextTheta = thetaAtX.getTheta(nextRayParam);
            int n = 0;
            try {
                while (nextRayParam >= minRayParam) {
                    n = (int)Math.round((theta - (double)startTime) / deltaT);
                    if (n >= 0 && n < numSamples) {
                        try {
                            Arrival thetaArrival = arrival.getPhase().shootRay(rayParam);
                            double psvAmpFactor = thetaArrival.getEnergyFluxFactorReflTransPSV();
                            double incidentAngle = thetaArrival.getIncidentAngleDegree();
                            double transverseAmpFactor = thetaArrival.getEnergyFluxFactorReflTransSH();
                            double rotateAngle = 0.0;
                            if (!thetaArrival.getPhase().finalSegmentIsPWave()) {
                                rotateAngle = 90.0;
                            }
                            double radialReflTrans = psvAmpFactor * Math.cos((incidentAngle += rotateAngle) * Math.PI / 180.0);
                            double verticalReflTrans = psvAmpFactor * Math.sin(incidentAngle * Math.PI / 180.0);
                            double drp_s_m = (rayParam - nextRayParam) / radiusEarthMeter;
                            double rp_s_m = rayParam / radiusEarthMeter;
                            int n2 = n;
                            radial[n2] = radial[n2] + (float)(Math.sqrt(rp_s_m) * radialReflTrans * drp_s_m);
                            int n3 = n;
                            vertical[n3] = vertical[n3] + (float)(Math.sqrt(rp_s_m) * verticalReflTrans * drp_s_m);
                            int n4 = n;
                            transverse[n4] = transverse[n4] + (float)(Math.sqrt(rp_s_m) * transverseAmpFactor * drp_s_m);
                        }
                        catch (SlownessModelException thetaArrival) {
                            // empty catch block
                        }
                    }
                    rayParam = nextRayParam;
                    theta = nextTheta;
                    nextRayParam = thetaAtX.getStepRayParam(rayParam, deltaT);
                    if (nextRayParam == -1.0) continue block4;
                    nextTheta = thetaAtX.getTheta(nextRayParam);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new TauPException(e);
            }
        }
        for (int i = 0; i < radial.length; ++i) {
            double dist_m = degrees * Math.PI / 180.0 * radiusEarthMeter;
            radial[i] = (float)((double)radial[i] * 1.0 / (Math.PI * Math.sqrt(2.0 * dist_m)));
            transverse[i] = (float)((double)transverse[i] * 1.0 / (Math.PI * Math.sqrt(2.0 * dist_m)));
            vertical[i] = (float)((double)vertical[i] * 1.0 / (Math.PI * Math.sqrt(2.0 * dist_m)));
        }
        return rtz;
    }

    public DataOutputStream getOutputStream() throws IOException {
        if (this.writer == null) {
            this.writer = !this.outputTypeArgs.getOutFile().equals("stdout") ? new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.outputTypeArgs.getOutFile()))) : new DataOutputStream(new BufferedOutputStream(System.out));
        }
        return this.writer;
    }

    public List<Arrival> calcAll(List<SeismicPhase> phaseList, List<RayCalculateable> shootables) throws TauPException {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (SeismicPhase phase : phaseList) {
            ArrayList<Arrival> phaseArrivals = new ArrayList<Arrival>();
            for (RayCalculateable shoot : shootables) {
                phaseArrivals.addAll(shoot.calculate(phase));
            }
            if (phaseArrivals.isEmpty()) continue;
            arrivals.add((Arrival)phaseArrivals.get(0));
        }
        Arrival.sortArrivals(arrivals);
        return arrivals;
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @Override
    public String getOutFileExtension() {
        return this.outputTypeArgs.getOutFileExtension();
    }

    public List<RayCalculateable> getRayCalculatables() {
        List<RayCalculateable> out = this.distanceArgs.getRayCalculatables(this.sourceArgs);
        if (this.geodeticArgs.hasAzimuth()) {
            for (RayCalculateable rc : out) {
                if (rc.hasAzimuth()) continue;
                rc.setAzimuth(this.geodeticArgs.getAzimuth());
            }
        }
        return out;
    }

    public ZonedDateTime getOriginTime() {
        if (this.origintime == null) {
            return this.defaultOriginTime;
        }
        return this.origintime;
    }

    public DistanceLengthArgs getDistanceLengthArgs() {
        return this.distanceArgs;
    }

    public boolean hasEventLatLon() {
        return this.geodeticArgs.hasEventLatLon() || this.qmlStaxmlArgs.hasQml();
    }

    public boolean hasStationLatLon() {
        return this.geodeticArgs.hasStationLatLon() || this.qmlStaxmlArgs.hasStationXML();
    }

    public List<LatLonLocatable> getStationLatLon() throws TauPException {
        ArrayList<LatLonLocatable> staList = new ArrayList<LatLonLocatable>();
        staList.addAll(this.geodeticArgs.getStationLocations());
        staList.addAll(this.qmlStaxmlArgs.getStationLocations());
        return staList;
    }

    public List<LatLonLocatable> getEventLatLon() throws TauPException {
        ArrayList<LatLonLocatable> eventLocs = new ArrayList<LatLonLocatable>();
        eventLocs.addAll(this.geodeticArgs.getEventLocations());
        eventLocs.addAll(this.qmlStaxmlArgs.getEventLocations());
        return eventLocs;
    }
}

