/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.DistanceAngleRay;
import edu.sc.seis.TauP.DistanceRay;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicSource;
import edu.sc.seis.TauP.SetSacException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeResult;
import edu.sc.seis.TauP.cmdline.TauP_AbstractPhaseTool;
import edu.sc.seis.TauP.cmdline.args.AmplitudeArgs;
import edu.sc.seis.TauP.cmdline.args.GeodeticArgs;
import edu.sc.seis.TauP.cmdline.args.QmlStaxmlArgs;
import edu.sc.seis.TauP.gson.GsonUtil;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.quakeml.Quakeml;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.seisFile.mseed3.FDSNSourceId;
import edu.sc.seis.seisFile.mseed3.MSeed3EH;
import edu.sc.seis.seisFile.mseed3.MSeed3Record;
import edu.sc.seis.seisFile.mseed3.ehbag.Marker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import picocli.CommandLine;

@CommandLine.Command(name="setms3", description={"Save travel times in the extra header of miniseed3 files.", "    https://crotwell.github.io/ms3eh/", "has details on the JSON structure.", ""}, optionListHeading="%nOptions:%n%n", abbreviateSynopsis=false, usageHelpAutoWidth=true)
public class TauP_SetMSeed3
extends TauP_AbstractPhaseTool {
    protected String ehKey = null;
    protected Duration quakeOTimeTol = Duration.ofSeconds(3600L);
    @CommandLine.Mixin
    protected QmlStaxmlArgs qmlStaxmlArgs = new QmlStaxmlArgs();
    protected List<String> mseed3FileNames = new ArrayList<String>();
    protected Map<Network, List<Station>> networks = new HashMap<Network, List<Station>>();
    protected List<Event> quakes = new ArrayList<Event>();
    @CommandLine.Mixin
    GeodeticArgs geodeticArgs = new GeodeticArgs();
    @CommandLine.Mixin
    AmplitudeArgs sourceArgs = new AmplitudeArgs();

    public TauP_SetMSeed3() {
        super(null);
    }

    @Override
    public String getOutputFormat() {
        return "ms3";
    }

    @Override
    public void start() throws IOException, TauPException {
        if (this.mseed3FileNames.isEmpty()) {
            CommandLine.usage(this, System.out);
            return;
        }
        try {
            if (this.qmlStaxmlArgs.hasStationXML()) {
                FDSNStationXML staxml = FDSNStationXML.loadStationXML((String)this.qmlStaxmlArgs.getStationxmlFilename());
                this.networks = staxml.extractAllNetworks();
            }
        }
        catch (SeisFileException | XMLStreamException e) {
            throw new TauPException("Unable to process stationxml from " + this.qmlStaxmlArgs.getStationxmlFilename(), e);
        }
        try {
            if (this.qmlStaxmlArgs.hasQml()) {
                FileReader reader = new FileReader(this.qmlStaxmlArgs.getQuakemlFilename());
                Quakeml quakeml = Quakeml.loadQuakeML((Reader)reader);
                this.quakes = quakeml.extractAllEvents();
                reader.close();
            }
        }
        catch (SeisFileException | XMLStreamException e) {
            throw new TauPException("Unable to process quakeml from " + this.qmlStaxmlArgs.getQuakemlFilename(), e);
        }
        for (String filename : this.mseed3FileNames) {
            try {
                if (this.isVerbose()) {
                    Alert.debug(filename);
                }
                this.processMSeed3File(new File(filename));
            }
            catch (SeisFileException e) {
                throw new TauPException(e);
            }
        }
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        this.geodeticArgs.validateArguments();
    }

    public void processMSeed3File(File msd3File) throws IOException, SeisFileException, TauPException {
        MSeed3Record dr3;
        int fileBytes = (int)msd3File.length();
        File tmpFile = File.createTempFile("taup", "ms3", msd3File.getParentFile());
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(msd3File)));
        for (int bytesRead = 0; bytesRead < fileBytes && (dr3 = MSeed3Record.read((DataInput)dis)) != null; bytesRead += dr3.getSize()) {
            this.processRecord(dr3);
            dr3.write((OutputStream)dos);
        }
        dos.close();
        if (!tmpFile.renameTo(msd3File)) {
            throw new SetSacException("unable to rename temp file: " + String.valueOf(tmpFile) + " to " + String.valueOf(msd3File));
        }
    }

    public void processRecord(MSeed3Record dr3) throws TauPException {
        DistanceAngleRay rayCalculateable;
        Instant evTime;
        Event evLoc;
        MSeed3EH eh = new MSeed3EH(dr3.getExtraHeaders());
        Channel chan = FDSNStationXML.findChannelBySID(this.networks, (FDSNSourceId)dr3.getSourceId(), (Instant)dr3.getStartInstant());
        Object staLoc = chan != null ? chan : eh.channelLocation();
        Event quake = this.findQuakeInTime(dr3.getStartInstant(), this.quakeOTimeTol);
        if (quake != null) {
            evLoc = quake;
            evTime = quake.getPreferredOrigin().getTime().asInstant();
        } else {
            evLoc = eh.quakeLocation();
            evTime = eh.quakeTime();
        }
        if (staLoc != null && evLoc != null) {
            rayCalculateable = this.geodeticArgs.isGeodetic() ? DistanceRay.ofGeodeticEventStation((LatLonLocatable)evLoc, (LatLonLocatable)staLoc, this.geodeticArgs.getGeodesic()) : DistanceRay.ofEventStation((LatLonLocatable)evLoc, (LatLonLocatable)staLoc);
        } else if (eh.gcarc() != null) {
            rayCalculateable = DistanceRay.ofDegrees(eh.gcarc().floatValue());
        } else {
            throw new SetSacException("Unable to get distance from MS3 record, skipping. :" + String.valueOf(dr3));
        }
        if (quake != null) {
            eh.addToBag(quake);
            if (quake.getPreferredMagnitude() != null && this.sourceArgs.getMw() == 4.0f) {
                SeismicSource quakeSourceArgs = new SeismicSource(quake.getPreferredMagnitude().getMag().getValue().floatValue());
                rayCalculateable.setSeismicSource(quakeSourceArgs);
            }
        }
        if (chan != null) {
            eh.addToBag(chan);
        }
        ArrayList<Double> receiverDepthList = new ArrayList<Double>();
        if (staLoc != null) {
            this.setSingleReceiverDepth(staLoc.asLocation().getDepthKm());
            receiverDepthList.add(staLoc.asLocation().getDepthKm());
        } else {
            this.setSingleReceiverDepth(0.0);
            receiverDepthList.add(0.0);
        }
        double depth = 0.0;
        if (evLoc != null) {
            depth = evLoc.asLocation().getDepthKm();
        }
        List<SeismicPhase> seismicPhaseList = this.calcSeismicPhases(depth, receiverDepthList, this.modelArgs.getScatterer());
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        for (SeismicPhase phase : seismicPhaseList) {
            arrivals.addAll(((RayCalculateable)rayCalculateable).calculate(phase));
        }
        if (!arrivals.isEmpty()) {
            if (this.ehKey != null && !this.ehKey.isEmpty()) {
                TimeResult result = this.createTimeResult(this.isWithAmplitude(), this.sourceArgs.getSeismicSource(), arrivals);
                Gson gson = GsonUtil.createGsonBuilder().create();
                JsonObject jsonObj = JsonParser.parseString((String)dr3.getExtraHeadersAsString(0)).getAsJsonObject();
                if (jsonObj.has(this.ehKey)) {
                    jsonObj.add(this.ehKey, gson.toJsonTree((Object)result));
                }
                dr3.setExtraHeaders(jsonObj.getAsString());
            } else {
                if (evTime == null) {
                    Alert.warning("Unable to extract event origin time, skipping record");
                }
                for (Arrival arrival : arrivals) {
                    eh.addToBag(TauP_SetMSeed3.createEHMarker(arrival, evTime));
                }
            }
        }
    }

    public static Marker createEHMarker(Arrival arrival, Instant evTime) {
        Marker m = new Marker(arrival.getName(), evTime.plusMillis(Math.round(arrival.getTime() * 1000.0)).atZone(TimeUtils.TZ_UTC));
        m.setType("md");
        return m;
    }

    Event findQuakeInTime(Instant time, Duration tol) {
        Instant early = time.minus(tol);
        Instant late = time.plus(tol);
        for (Event e : this.quakes) {
            Instant otime;
            Origin o = e.getPreferredOrigin();
            if (o == null || !(otime = o.getTime().asInstant()).isAfter(early) || !otime.isBefore(late)) continue;
            return e;
        }
        return null;
    }

    public String getEhKey() {
        return this.ehKey;
    }

    @CommandLine.Option(names={"--taupeh"}, arity="0..1", fallbackValue="taup", description={"key to store full TauP JSON output within extra headers within, otherwise use abbreviated 'bag' style markers.If specified without parameter, extra header key of ${FALLBACK-VALUE} will be used."})
    public void setEhKey(String ehKey) {
        this.ehKey = ehKey;
    }

    public Duration getQuakeOTimeTol() {
        return this.quakeOTimeTol;
    }

    @CommandLine.Option(names={"--qmltol"}, defaultValue="PT1H", description={"time window to search for origins in a QuakeML file as an ISO8601 string, default value is ${DEFAULT-VALUE}."})
    public void setQuakeOTimeTol(Duration quakeOTimeTol) {
        this.quakeOTimeTol = quakeOTimeTol;
    }

    public List<String> getMseed3FileNames() {
        return this.mseed3FileNames;
    }

    @CommandLine.Parameters(description={"Miniseed3 files to process."}, paramLabel="mseed3file")
    public void setMseed3FileNames(List<String> mseed3FileNames) {
        this.mseed3FileNames = mseed3FileNames;
    }

    public Map<Network, List<Station>> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Map<Network, List<Station>> networks) {
        this.networks = networks;
    }

    public List<Event> getQuakes() {
        return this.quakes;
    }

    public void setQuakes(List<Event> quakes) {
        this.quakes = quakes;
    }

    public AmplitudeArgs getSourceArgs() {
        return this.sourceArgs;
    }

    public boolean isWithAmplitude() {
        return this.getSourceArgs().isWithAmplitude();
    }
}

