/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.NamedVelocityDiscon;
import edu.sc.seis.TauP.ReflTrans;
import edu.sc.seis.TauP.ReflTransAxisType;
import edu.sc.seis.TauP.ReflTransFluidFreeSurface;
import edu.sc.seis.TauP.ReflTransFreeSurface;
import edu.sc.seis.TauP.ReflTransSolidFreeSurface;
import edu.sc.seis.TauP.SvgUtil;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.VelocityModel;
import edu.sc.seis.TauP.VelocityModelException;
import edu.sc.seis.TauP.XYPlotOutput;
import edu.sc.seis.TauP.XYPlottingData;
import edu.sc.seis.TauP.XYSegment;
import edu.sc.seis.TauP.cmdline.CalcReflTranFunction;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.args.ColorType;
import edu.sc.seis.TauP.cmdline.args.GraphicOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.ModelArgs;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="refltrans", description={"Plot reflection and transmission coefficients for a discontinuity."}, optionListHeading="%nOptions:%n%n", abbreviateSynopsis=false, usageHelpAutoWidth=true)
public class TauP_ReflTransPlot
extends TauP_Tool {
    public static final String DEFAULT_OUTFILE = "taup_refltrans";
    @CommandLine.Mixin
    GraphicOutputTypeArgs outputTypeArgs;
    LayerParams layerParams = null;
    @CommandLine.Option(names={"--legend"}, description={"create a legend"})
    boolean isLegend = false;
    String modelType;
    protected String depthName = null;
    protected double depth = -1.0;
    protected double angleStep = 1.0;
    protected double rayparamStep = 0.001;
    protected DegRayParam xAxisType = DegRayParam.degree;
    protected List<ReflTransAxisType> yAxisType = new ArrayList<ReflTransAxisType>();
    protected double[] xAxisMinMax = new double[0];
    protected double[] yAxisMinMax = new double[0];
    protected double step = -1.0;
    protected Boolean indown = null;
    protected boolean inpwave = false;
    protected boolean inswave = false;
    protected boolean inshwave = false;
    protected boolean absolute = false;
    protected boolean angles = false;
    protected boolean energyflux = false;
    protected boolean phase = false;
    protected boolean fsrf = false;
    @CommandLine.Mixin
    ModelArgs modelArgs = new ModelArgs();

    public TauP_ReflTransPlot() {
        super(new GraphicOutputTypeArgs("text", DEFAULT_OUTFILE));
        this.outputTypeArgs = (GraphicOutputTypeArgs)this.abstractOutputTypeArgs;
        this.outputTypeArgs.setOutFileBase(DEFAULT_OUTFILE);
    }

    @Override
    public void init() throws TauPException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void start() throws IOException, TauPException {
        List<XYPlottingData> xypList;
        double step = this.isLinearRayParam() ? this.rayparamStep : this.angleStep;
        VelocityModel vMod = null;
        if (this.layerParams == null && (vMod = TauModelLoader.loadVelocityModel(this.modelArgs.getModelName(), this.modelType)) == null) {
            throw new TauPException("Unable to find model " + this.modelArgs.getModelName());
        }
        if (this.fsrf) {
            this.yAxisType.addAll(ReflTransAxisType.allFreeRF);
            if (this.layerParams == null) {
                xypList = this.calculateFSRF(vMod, this.inpwave, this.inswave, this.inshwave, this.isLinearRayParam(), step);
            } else {
                this.modelArgs.setModelName(this.layerParams.asName());
                if (this.layerParams.inVp == 0.0 && this.layerParams.trVp != 0.0) {
                    xypList = this.calculateFSRF(this.layerParams.trVp, this.layerParams.trVs, this.layerParams.trRho, this.inpwave, this.inswave, this.inshwave, this.isLinearRayParam(), step);
                } else {
                    if (this.layerParams.trVp != 0.0 || this.layerParams.inVp == 0.0) throw new TauPException("Both above and below Vp are zero, cannot calculate free surface receiver function");
                    xypList = this.calculateFSRF(this.layerParams.inVp, this.layerParams.inVs, this.layerParams.inRho, this.inpwave, this.inswave, this.inshwave, this.isLinearRayParam(), step);
                }
            }
        } else {
            if (this.isAngles()) {
                this.yAxisType.addAll(ReflTransAxisType.allAngle);
            } else if (this.isEnergyFlux()) {
                this.yAxisType.addAll(ReflTransAxisType.allEnergy);
            } else if (this.isPhase()) {
                this.yAxisType.addAll(ReflTransAxisType.allPhase);
            } else if (this.yAxisType.isEmpty()) {
                this.yAxisType.addAll(ReflTransAxisType.allDisplacement);
            }
            if (this.layerParams == null) {
                xypList = this.calculate(vMod, this.getDepth(), this.isIncidentDown(), this.inpwave, this.inswave, this.inshwave, this.isLinearRayParam(), step);
            } else {
                xypList = this.calculate(this.layerParams.inVp, this.layerParams.inVs, this.layerParams.inRho, this.layerParams.trVp, this.layerParams.trVs, this.layerParams.trRho, this.isIncidentDown(), this.inpwave, this.inswave, this.inshwave, this.isLinearRayParam(), step);
                this.modelArgs.setModelName(this.layerParams.asName());
            }
        }
        if (this.xAxisMinMax.length == 2 || this.yAxisMinMax.length == 2) {
            xypList = XYPlottingData.trimAllToMinMax(xypList, this.xAxisMinMax, this.yAxisMinMax);
        }
        PrintWriter writer = this.outputTypeArgs.createWriter(this.spec.commandLine().getOut());
        this.printResult(writer, xypList);
        writer.close();
    }

    public void printResult(PrintWriter writer, List<XYPlottingData> xyPlots) throws TauPException {
        XYPlotOutput xyOut = new XYPlotOutput(xyPlots, this.modelArgs);
        xyOut.setxAxisMinMax(this.xAxisMinMax);
        xyOut.setyAxisMinMax(this.yAxisMinMax);
        xyOut.getColoringArgs().setColoring(ColorType.phase);
        Object title = "";
        if (this.layerParams != null) {
            title = this.layerParams.asName();
        } else {
            title = this.modelArgs.getModelName() + " at ";
            title = this.fsrf || this.depth == 0.0 || "surface".equalsIgnoreCase(this.depthName) ? (String)title + " surface" : (this.depthName != null ? (String)title + this.depthName : (String)title + this.depth + " km");
        }
        title = this.isIncidentDown() ? (String)title + ", inc. down" : (String)title + ", inc. up";
        xyOut.setTitle((String)title);
        Object yAxisActual = "";
        boolean hasDisplacement = false;
        boolean hasAngle = false;
        boolean hasEnergy = false;
        boolean hasPhase = false;
        boolean hasFreeSurface = false;
        for (XYPlottingData xyp : xyPlots) {
            try {
                ReflTransAxisType axisType = ReflTransAxisType.valueOf(xyp.yAxisType);
                if (ReflTransAxisType.allDisplacement.contains((Object)axisType)) {
                    hasDisplacement = true;
                    continue;
                }
                if (ReflTransAxisType.allAngle.contains((Object)axisType)) {
                    hasAngle = true;
                    continue;
                }
                if (ReflTransAxisType.allEnergy.contains((Object)axisType)) {
                    hasEnergy = true;
                    continue;
                }
                if (ReflTransAxisType.allPhase.contains((Object)axisType)) {
                    hasPhase = true;
                    continue;
                }
                if (ReflTransAxisType.allFreeRF.contains((Object)axisType)) {
                    hasFreeSurface = true;
                    continue;
                }
                yAxisActual = (String)yAxisActual + xyp.label + ",";
            }
            catch (IllegalArgumentException e) {
                Alert.warning("Unknown ReflTransAxisType: '" + xyp.yAxisType + "'");
                yAxisActual = (String)yAxisActual + xyp.label + ",";
            }
        }
        if (hasDisplacement) {
            yAxisActual = (String)yAxisActual + " Displacement,";
        }
        if (hasAngle) {
            yAxisActual = (String)yAxisActual + " Angle,";
        }
        if (hasEnergy) {
            yAxisActual = (String)yAxisActual + " Energy,";
        }
        if (hasPhase) {
            yAxisActual = (String)yAxisActual + " Phase,";
        }
        if (hasFreeSurface) {
            yAxisActual = (String)yAxisActual + " Free Surface RF,";
        }
        if (((String)yAxisActual).length() > 0) {
            yAxisActual = ((String)yAxisActual).substring(0, ((String)yAxisActual).length() - 1) + " Coeff.";
        }
        xyOut.setXLabel(DegRayParam.labelFor(this.xAxisType));
        xyOut.setYLabel((String)yAxisActual);
        if (this.getOutputFormat().equalsIgnoreCase("json")) {
            xyOut.printAsJSON(writer, 2);
        } else if (this.getOutputFormat().equalsIgnoreCase("text") || this.getOutputFormat().equalsIgnoreCase("gmt")) {
            xyOut.printAsGmtText(writer);
        } else if (this.getOutputFormat().equalsIgnoreCase("html")) {
            xyOut.printAsHtml(writer, TauP_ReflTransPlot.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), this.outputTypeArgs.getPixelWidth(), String.valueOf(SvgUtil.createReflTransCSSColors()) + "\n", this.isLegend);
        } else if (this.getOutputFormat().equalsIgnoreCase("svg")) {
            xyOut.printAsSvg(writer, TauP_ReflTransPlot.toolNameFromClass(this.getClass()), this.getCmdLineArgs(), this.outputTypeArgs.getPixelWidth(), String.valueOf(SvgUtil.createReflTransCSSColors()) + "\n", this.isLegend);
        } else {
            throw new IllegalArgumentException("Unknown output format: " + this.getOutputFormat());
        }
        writer.flush();
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauPException {
        if (this.layerParams == null && this.depth == -1.0 && this.depthName == null && !this.fsrf) {
            throw new TauPException("Either --layer, or --mod and --depth must be given to specify layer parameters");
        }
        if (this.fsrf && this.depth > 0.0) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "depth must be zero for free surface receiver function, --fsfr");
        }
    }

    public List<XYPlottingData> calculateFSRF(double pVel, double sVel, double rho, boolean inpwave, boolean inswave, boolean inshwave, boolean linearRayParam, double angleStep) throws VelocityModelException {
        ReflTrans reflTranCoef = VelocityModel.calcReflTransCoef(0.0, 0.0, 0.0, pVel, sVel, rho, false);
        this.yAxisType = sVel == 0.0 ? List.of(ReflTransAxisType.FreeRecFuncPr, ReflTransAxisType.FreeRecFuncPz) : List.of(ReflTransAxisType.FreeRecFuncPr, ReflTransAxisType.FreeRecFuncSvr, ReflTransAxisType.FreeRecFuncPz, ReflTransAxisType.FreeRecFuncSvz, ReflTransAxisType.FreeRecFuncSh);
        return this.calculate(reflTranCoef, inpwave, inswave, inshwave, linearRayParam, angleStep);
    }

    public List<XYPlottingData> calculateFSRF(VelocityModel vMod, boolean inpwave, boolean inswave, boolean inshwave, boolean linearRayParam, double angleStep) throws VelocityModelException {
        double depth = 0.0;
        if (!vMod.isDisconDepth(depth)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Depth is not a discontinuity in " + vMod.getModelName() + ": " + depth);
        }
        ReflTrans reflTranCoef = vMod.calcReflTransCoefFreeSurface();
        this.yAxisType = vMod.getVelocityLayer(0).getTopSVelocity() == 0.0 ? List.of(ReflTransAxisType.FreeRecFuncPr, ReflTransAxisType.FreeRecFuncPz) : List.of(ReflTransAxisType.FreeRecFuncPr, ReflTransAxisType.FreeRecFuncSvr, ReflTransAxisType.FreeRecFuncPz, ReflTransAxisType.FreeRecFuncSvz, ReflTransAxisType.FreeRecFuncSh);
        return this.calculate(reflTranCoef, inpwave, inswave, inshwave, linearRayParam, angleStep);
    }

    public List<XYPlottingData> calculate(VelocityModel vMod, double depth, boolean downgoing, boolean inpwave, boolean inswave, boolean inshwave, boolean linearRayParam, double angleStep) throws VelocityModelException {
        if (!vMod.isDisconDepth(depth)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Depth is not a discontinuity in " + vMod.getModelName() + ": " + depth);
        }
        ReflTrans reflTranCoef = vMod.calcReflTransCoef(depth, downgoing);
        return this.calculate(reflTranCoef, inpwave, inswave, inshwave, linearRayParam, angleStep);
    }

    public List<XYPlottingData> calculate(double topVp, double topVs, double topDensity, double botVp, double botVs, double botDensity, boolean downgoing, boolean inpwave, boolean inswave, boolean inshwave, boolean linearRayParam, double angleStep) throws VelocityModelException {
        ReflTrans reflTranCoef = VelocityModel.calcReflTransCoef(topVp, topVs, topDensity, botVp, botVs, botDensity, downgoing);
        return this.calculate(reflTranCoef, inpwave, inswave, inshwave, linearRayParam, angleStep);
    }

    public String createTitle(ReflTrans reflTransCoef, boolean inpwave, boolean inswave) {
        String title;
        if (reflTransCoef.getBotVp() == 0.0) {
            title = "Free surface: " + reflTransCoef.getTopVp() + "," + reflTransCoef.getTopVs() + "," + reflTransCoef.getTopDensity() + " ";
        } else {
            title = reflTransCoef.getTopVs() == 0.0 ? "In Fluid: " + reflTransCoef.getTopVp() + "," + reflTransCoef.getTopVs() + "," + reflTransCoef.getTopDensity() + " " : "In Solid: " + reflTransCoef.getTopVp() + "," + reflTransCoef.getTopVs() + "," + reflTransCoef.getTopDensity() + " ";
            title = reflTransCoef.getBotVs() == 0.0 ? title + "to Fluid: " + reflTransCoef.getBotVp() + "," + reflTransCoef.getBotVs() + "," + reflTransCoef.getBotDensity() + ": " : title + "to Solid: " + reflTransCoef.getBotVp() + "," + reflTransCoef.getBotVs() + "," + reflTransCoef.getBotDensity() + ": ";
        }
        title = title + (String)(inpwave ? "P at " + reflTransCoef.getTopVp() + " " : "");
        title = title + (String)(inswave ? "S at " + reflTransCoef.getTopVs() + " " : "");
        return title;
    }

    public List<XYPlottingData> calculate(ReflTrans reflTranCoef, boolean inpwave, boolean inswave, boolean inshwave, boolean linearRayParam, double step) throws VelocityModelException {
        XYPlottingData xyp_z;
        double oneOverV;
        double invel;
        boolean doAll;
        ArrayList<XYPlottingData> out = new ArrayList<XYPlottingData>();
        double minX = 0.0;
        double maxX = 90.0;
        if (linearRayParam) {
            maxX = 1.0 / ((inswave || inshwave) && reflTranCoef.getTopVs() != 0.0 ? reflTranCoef.getTopVs() : reflTranCoef.getTopVp());
        }
        float maxXPercent = 0.999999f;
        maxX *= (double)maxXPercent;
        boolean bl = doAll = !inpwave && !inswave && !inshwave;
        if (this.yAxisType.isEmpty()) {
            this.yAxisType = ReflTransAxisType.allDisplacement;
        }
        if (inpwave || doAll) {
            XYPlottingData xyp;
            invel = reflTranCoef.getTopVp();
            oneOverV = 1.0 / invel;
            double maxX_inP = maxX;
            if (linearRayParam) {
                maxX_inP = 1.0 / reflTranCoef.getTopVp() * (double)maxXPercent;
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.Rpp)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.Rpp, reflTranCoef::getRpp);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RppEnergy)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.RppEnergy, reflTranCoef::getEnergyFluxRpp);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RppPhase)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.RppPhase, reflTranCoef::getRppPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.Tpp)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.Tpp, reflTranCoef::getTpp);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TppEnergy)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.TppEnergy, reflTranCoef::getEnergyFluxTpp);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TppPhase)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.TppPhase, reflTranCoef::getTppPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.Rps)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.Rps, reflTranCoef::getRps);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RpsEnergy)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.RpsEnergy, reflTranCoef::getEnergyFluxRps);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RpsPhase)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.RpsPhase, reflTranCoef::getRpsPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.Tps)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.Tps, reflTranCoef::getTps);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TpsEnergy)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.TpsEnergy, reflTranCoef::getEnergyFluxTps);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TpsPhase)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.TpsPhase, reflTranCoef::getTpsPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RpAngle)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.RpAngle, reflTranCoef::getAngleR_p);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RsAngle)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RsAngle, reflTranCoef::getAngleR_s);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TpAngle)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX_inP, step, linearRayParam, oneOverV, ReflTransAxisType.TpAngle, reflTranCoef::getAngleT_p);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TsAngle)) {
                xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TsAngle, reflTranCoef::getAngleT_s);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.FreeRecFuncPz)) {
                ReflTransFreeSurface rtfree;
                CalcReflTranFunction<Double, Double> calcFn = null;
                if (reflTranCoef instanceof ReflTransSolidFreeSurface) {
                    rtfree = (ReflTransSolidFreeSurface)reflTranCoef;
                    calcFn = ((ReflTransSolidFreeSurface)rtfree)::getFreeSurfaceReceiverFunP_z;
                } else if (reflTranCoef instanceof ReflTransFluidFreeSurface) {
                    rtfree = (ReflTransFluidFreeSurface)reflTranCoef;
                    calcFn = ((ReflTransFluidFreeSurface)rtfree)::getFreeSurfaceReceiverFunP_z;
                } else {
                    throw new VelocityModelException("ReflTran not for free surface: " + reflTranCoef.getClass().getName());
                }
                XYPlottingData xyp_z2 = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.FreeRecFuncPz, calcFn);
                out.add(xyp_z2);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.FreeRecFuncPr)) {
                if (!(reflTranCoef instanceof ReflTransFreeSurface)) {
                    throw new VelocityModelException("ReflTran not for free surface: " + reflTranCoef.getClass().getName());
                }
                ReflTransFreeSurface rtfree = (ReflTransFreeSurface)reflTranCoef;
                XYPlottingData xyp_r = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.FreeRecFuncPr, rtfree::getFreeSurfaceReceiverFunP_r);
                out.add(xyp_r);
            }
        }
        if (inswave || doAll) {
            invel = reflTranCoef.getTopVs();
            oneOverV = 1.0 / invel;
            if (this.yAxisType.contains((Object)ReflTransAxisType.Rsp)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.Rsp, reflTranCoef::getRsp);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RspEnergy)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RspEnergy, reflTranCoef::getEnergyFluxRsp);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RspPhase)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RspPhase, reflTranCoef::getRspPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.Tsp)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.Tsp, reflTranCoef::getTsp);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TspEnergy)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TspEnergy, reflTranCoef::getEnergyFluxTsp);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TspPhase)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TspPhase, reflTranCoef::getTspPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.Rss)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.Rss, reflTranCoef::getRss);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RssEnergy)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RssEnergy, reflTranCoef::getEnergyFluxRss);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RssPhase)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RssPhase, reflTranCoef::getRssPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.Tss)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.Tss, reflTranCoef::getTss);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TssEnergy)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TssEnergy, reflTranCoef::getEnergyFluxTss);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TssPhase)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TssPhase, reflTranCoef::getTssPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RpAngle)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RpAngle, reflTranCoef::getAngleR_p);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RsAngle)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RsAngle, reflTranCoef::getAngleR_s);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TpAngle)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TpAngle, reflTranCoef::getAngleT_p);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TsAngle)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TsAngle, reflTranCoef::getAngleT_s);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.FreeRecFuncSvz)) {
                if (!(reflTranCoef instanceof ReflTransFreeSurface)) {
                    throw new VelocityModelException("ReflTran not for free surface: " + reflTranCoef.getClass().getName());
                }
                ReflTransFreeSurface rtfree = (ReflTransFreeSurface)reflTranCoef;
                xyp_z = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.FreeRecFuncSvz, rtfree::getFreeSurfaceReceiverFunSv_z);
                out.add(xyp_z);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.FreeRecFuncSvr)) {
                if (!(reflTranCoef instanceof ReflTransFreeSurface)) {
                    throw new VelocityModelException("ReflTran not for free surface: " + reflTranCoef.getClass().getName());
                }
                ReflTransFreeSurface rtfree = (ReflTransFreeSurface)reflTranCoef;
                XYPlottingData xyp_r = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.FreeRecFuncSvr, rtfree::getFreeSurfaceReceiverFunSv_r);
                out.add(xyp_r);
            }
        }
        if (inshwave || doAll) {
            invel = reflTranCoef.getTopVs();
            oneOverV = 1.0 / invel;
            if (this.yAxisType.contains((Object)ReflTransAxisType.Rshsh)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.Rshsh, reflTranCoef::getRshsh);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RshshEnergy)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RshshEnergy, reflTranCoef::getEnergyFluxRshsh);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RshshPhase)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RshshPhase, reflTranCoef::getRshshPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.Tshsh)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.Tshsh, reflTranCoef::getTshsh);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TshshEnergy)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TshshEnergy, reflTranCoef::getEnergyFluxTshsh);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TshshPhase)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TshshPhase, reflTranCoef::getTshshPhase);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.RsAngle)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.RsAngle, reflTranCoef::getAngleR_s);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.TsAngle)) {
                XYPlottingData xyp = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.TsAngle, reflTranCoef::getAngleT_s);
                out.add(xyp);
            }
            if (this.yAxisType.contains((Object)ReflTransAxisType.FreeRecFuncSh) && reflTranCoef instanceof ReflTransSolidFreeSurface) {
                ReflTransSolidFreeSurface rtfree = (ReflTransSolidFreeSurface)reflTranCoef;
                xyp_z = this.calculateForType(reflTranCoef, minX, maxX, step, linearRayParam, oneOverV, ReflTransAxisType.FreeRecFuncSh, rtfree::getFreeSurfaceReceiverFunSh);
                out.add(xyp_z);
            }
        }
        return out;
    }

    protected XYPlottingData calculateForType(ReflTrans reflTranCoef, double minX, double maxX, double step, boolean linearRayParam, double oneOverV, ReflTransAxisType label, CalcReflTranFunction<Double, Double> calcFn) throws VelocityModelException {
        double rayParam;
        double i;
        ArrayList<XYSegment> segments = new ArrayList<XYSegment>();
        String xAxisType = linearRayParam ? DegRayParam.rayparam.name() : DegRayParam.degree.name();
        ArrayList<String> cssClassList = new ArrayList<String>();
        cssClassList.add(label.name());
        XYPlottingData xyp = new XYPlottingData(segments, xAxisType, label.name(), ReflTransAxisType.labelFor(label), cssClassList);
        try {
            calcFn.apply(0.0);
        }
        catch (VelocityModelException e) {
            if (this.isDEBUG()) {
                Alert.warning("Skip as type not allowed: " + String.valueOf(calcFn));
            }
            return xyp;
        }
        ArrayList<Double> xList = new ArrayList<Double>();
        ArrayList<Double> yList = new ArrayList<Double>();
        double[] critSlownesses = reflTranCoef.calcCriticalRayParams();
        for (i = minX; i <= maxX; i += step) {
            double nextrayParam;
            if (linearRayParam) {
                rayParam = i;
                nextrayParam = rayParam + step;
            } else {
                rayParam = oneOverV * Math.sin(i * (Math.PI / 180));
                nextrayParam = oneOverV * Math.sin((i + step) * (Math.PI / 180));
            }
            double val = calcFn.apply(rayParam);
            if (this.isAbsolute()) {
                val = Math.abs(val);
            }
            xList.add(i);
            yList.add(val);
            for (double critSlowness : critSlownesses) {
                double xval;
                if (!(rayParam < critSlowness) || !(nextrayParam > critSlowness)) continue;
                double d = xval = linearRayParam ? critSlowness : Math.asin(critSlowness / oneOverV) * 57.29577951308232;
                if (!(xval < maxX)) continue;
                val = calcFn.apply(critSlowness);
                if (this.isAbsolute()) {
                    val = Math.abs(val);
                }
                xList.add(xval);
                yList.add(val);
            }
        }
        if (i < maxX + step) {
            rayParam = linearRayParam ? maxX : oneOverV * Math.sin(maxX * (Math.PI / 180));
            double val = calcFn.apply(rayParam);
            if (this.isAbsolute()) {
                val = Math.abs(val);
            }
            xList.add(maxX);
            yList.add(val);
        }
        XYSegment seg = XYSegment.fromSingleList(xList, yList);
        segments.add(seg);
        return xyp;
    }

    public double getDepth() throws TauModelException {
        if (this.depthName != null) {
            VelocityModel vMod = this.getModelArgs().getTauModel().getVelocityModel();
            for (NamedVelocityDiscon nd : vMod.getNamedDiscons()) {
                if (!this.depthName.equalsIgnoreCase(nd.getPreferredName()) && !this.depthName.equalsIgnoreCase(nd.getName())) continue;
                return nd.getDepth();
            }
        }
        return this.depth;
    }

    @CommandLine.Option(names={"--depth"}, description={"Depth in model to get boundary parameters, may be number or name like moho."})
    public void setDepth(String depthOrName) {
        try {
            double d = Double.parseDouble(depthOrName);
            this.setDepth(d);
        }
        catch (NumberFormatException e) {
            this.depthName = depthOrName;
        }
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public void setLayerParams(double topVp, double topVs, double topDensity, double botVp, double botVs, double botDensity) {
        this.layerParams = new LayerParams();
        this.layerParams.inVp = topVp;
        this.layerParams.inVs = topVs;
        this.layerParams.inRho = topDensity;
        this.layerParams.trVp = botVp;
        this.layerParams.trVs = botVs;
        this.layerParams.trRho = botDensity;
    }

    @Override
    public String getOutputFormat() {
        return this.outputTypeArgs.getOutputFormat();
    }

    @CommandLine.Option(names={"--down"}, description={"incident is downgoing"})
    public void setIncidentDown(boolean indown) {
        this.indown = indown;
    }

    @CommandLine.Option(names={"--up"}, defaultValue="false", description={"incident is upgoing, reverses the sense of the boundary"})
    public void setIncidentUp(boolean inup) {
        this.indown = !inup;
    }

    public boolean isIncidentDown() {
        if (this.indown == null) {
            return true;
        }
        return this.indown;
    }

    @CommandLine.Option(names={"--pwave"}, description={"incident P wave"})
    public void setIncidentPWave(boolean inpwave) {
        this.inpwave = inpwave;
    }

    public boolean isIncidentPWave() {
        return this.inpwave;
    }

    @CommandLine.Option(names={"--swave"}, description={"incident S wave"})
    public void setIncidentSWave(boolean inswave) {
        this.inswave = inswave;
    }

    public boolean isIncidentSWave() {
        return this.inswave;
    }

    @CommandLine.Option(names={"--shwave"}, description={"incident SH wave"})
    public void setIncidentShWave(boolean inshwave) {
        this.inshwave = inshwave;
    }

    public boolean isIncidentShWave() {
        return this.inshwave;
    }

    @CommandLine.Option(names={"--energyflux"}, description={"all energy flux coefficients, like TppEnergy"})
    public void setEnergyFlux(boolean energyFlux) {
        this.energyflux = energyFlux;
    }

    public boolean isEnergyFlux() {
        return this.energyflux;
    }

    @CommandLine.Option(names={"--phase"}, description={"all displacement phase coefficients, like TppPhase"})
    public void setPhase(boolean phase) {
        this.phase = phase;
    }

    public boolean isPhase() {
        return this.phase;
    }

    @CommandLine.Option(names={"--fsrf"}, description={"all free surface receiver functions, like FreeRecFuncPz"})
    public void setFreeSurfRF(boolean fsrf) {
        this.fsrf = fsrf;
    }

    public boolean isFreeSurfRF() {
        return this.fsrf;
    }

    @CommandLine.Option(names={"--angles"}, description={"all angle coefficients, like TpAngle"})
    public void setAngles(boolean angles) {
        this.angles = angles;
    }

    public boolean isAngles() {
        return this.angles;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    @CommandLine.Option(names={"--abs"}, description={"absolute value of amplitude factor"})
    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    @CommandLine.Option(names={"--layer"}, arity="6", paramLabel="vp vs rho vp vs rho", hideParamSyntax=true, description={"inbound and transmitted layer parameters, vp, vs, rho, vp, vs, rho"})
    public void setLayerParams(double[] params) {
        if (params.length == 0) {
            this.layerParams = null;
        } else {
            if (params.length != 6) {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "layer params must be 6 numbers, inbould vp, vs, rho, transmitted vp, vs, rho");
            }
            this.layerParams = new LayerParams();
            this.layerParams.inVp = params[0];
            this.layerParams.inVs = params[1];
            this.layerParams.inRho = params[2];
            this.layerParams.trVp = params[3];
            this.layerParams.trVs = params[4];
            this.layerParams.trRho = params[5];
        }
    }

    public DegRayParam getxAxisType() {
        return this.xAxisType;
    }

    @CommandLine.Option(names={"-x"}, paramLabel="type", description={"X axis data type, one of ${COMPLETION-CANDIDATES}, default is ${DEFAULT-VALUE}"}, defaultValue="degree")
    public void setxAxisType(DegRayParam xAxisType) {
        this.xAxisType = xAxisType;
    }

    public List<ReflTransAxisType> getyAxisType() {
        return this.yAxisType;
    }

    @CommandLine.Option(names={"-y"}, paramLabel="type", description={"Y axis data type, one or more of ${COMPLETION-CANDIDATES}, default is all displacement coef."}, arity="1..*")
    public void setyAxisType(List<ReflTransAxisType> yAxisType) {
        this.yAxisType.addAll(yAxisType);
    }

    public double[] getxAxisMinMax() {
        return this.xAxisMinMax;
    }

    @CommandLine.Option(names={"--xminmax"}, arity="2", paramLabel="x", description={"min and max x axis for plotting"})
    public void setxAxisMinMax(double[] xAxisMinMax) {
        this.xAxisMinMax = xAxisMinMax;
    }

    public double[] getyAxisMinMax() {
        return this.yAxisMinMax;
    }

    @CommandLine.Option(names={"--yminmax"}, arity="2", paramLabel="y", description={"min and max y axis for plotting"})
    public void setyAxisMinMax(double[] yAxisMinMax) {
        this.yAxisMinMax = yAxisMinMax;
    }

    public boolean isLinearRayParam() {
        return this.xAxisType == DegRayParam.rayparam;
    }

    public boolean isInpwave() {
        return this.inpwave;
    }

    public boolean isInswave() {
        return this.inswave;
    }

    public boolean isInshwave() {
        return this.inshwave;
    }

    @CommandLine.Option(names={"--anglestep"}, paramLabel="deg", description={"step in degrees when x is degrees"})
    public void setAngleStep(double angleStep) {
        this.angleStep = angleStep;
    }

    public double getAngleStep() {
        return this.angleStep;
    }

    public double getRayparamStep() {
        return this.rayparamStep;
    }

    @CommandLine.Option(names={"--rpstep"}, paramLabel="s/km", description={"step in ray param when x is ray param"})
    public void setRayparamStep(double rayparamStep) {
        this.rayparamStep = rayparamStep;
    }

    public ModelArgs getModelArgs() {
        return this.modelArgs;
    }

    public static enum DegRayParam {
        degree,
        rayparam;


        public static String labelFor(DegRayParam val) {
            switch (val) {
                case rayparam: {
                    return "Ray Parameter (s/km)";
                }
                case degree: {
                    return "Incident Angle (deg)";
                }
            }
            return val.name();
        }
    }

    static class LayerParams {
        double inVp;
        double inVs;
        double inRho;
        double trVp;
        double trVs;
        double trRho;

        LayerParams() {
        }

        public String asName() {
            return this.inVp + "," + this.inVs + "," + this.inRho + " " + this.trVp + "," + this.trVs + "," + this.trRho;
        }
    }
}

