/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.EventAzimuth;
import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.LinearInterpolation;
import edu.sc.seis.TauP.RayCalculateable;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SimpleContigSeismicPhase;
import edu.sc.seis.TauP.StationBackAzimuth;
import java.util.ArrayList;
import java.util.List;

public class TimeRay
extends RayCalculateable {
    private final double seconds;

    public TimeRay(double seconds) {
        this.seconds = seconds;
    }

    @Override
    public List<Arrival> calculate(SeismicPhase phase) {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        if (phase instanceof SimpleContigSeismicPhase && phase.getMinTime() <= this.seconds && this.seconds <= phase.getMaxTime()) {
            SimpleContigSeismicPhase simp = (SimpleContigSeismicPhase)phase;
            double[] times = simp.getTime();
            double[] rayParams = simp.getRayParams();
            for (int rayNum = 0; rayNum < times.length - 1; ++rayNum) {
                double dRPdDist;
                double arrivalDist;
                if (!((times[rayNum] <= this.seconds && this.seconds < times[rayNum + 1] || times[rayNum] >= this.seconds && this.seconds > times[rayNum + 1]) && (rayParams[rayNum] != rayParams[rayNum + 1] || !(simp.getMaxRayParam() > simp.getMinRayParam())))) continue;
                Arrival left = simp.createArrivalAtIndex(rayNum);
                Arrival right = simp.createArrivalAtIndex(rayNum + 1);
                double arrivalRayParam = LinearInterpolation.linearInterp(left.getTime(), left.getRayParam(), right.getTime(), right.getRayParam(), this.seconds);
                if (simp.getMaxRayParam() == simp.getMinRayParam()) {
                    arrivalDist = LinearInterpolation.linearInterp(left.getTime(), left.getDist(), right.getTime(), right.getDist(), this.seconds);
                    dRPdDist = 0.0;
                } else if (Math.abs(this.seconds - left.getTime()) < Math.abs(this.seconds - right.getTime())) {
                    arrivalDist = (this.seconds - left.getTime()) / arrivalRayParam + left.getDist();
                    dRPdDist = (left.getRayParam() - arrivalRayParam) / (left.getDist() - arrivalDist);
                } else {
                    arrivalDist = (this.seconds - right.getTime()) / arrivalRayParam + right.getDist();
                    dRPdDist = (right.getRayParam() - arrivalRayParam) / (right.getDist() - arrivalDist);
                }
                Arrival a = new Arrival(phase, simp, this.seconds, arrivalDist, arrivalRayParam, rayNum, dRPdDist);
                a.setSearchValue(this);
                arrivals.add(a);
            }
        }
        return arrivals;
    }

    @Override
    public LatLonable getLatLonable() {
        if (this.isLatLonable()) {
            if (this.evtLatLon != null) {
                return new EventAzimuth(this.evtLatLon, this.azimuth, this.geodesic);
            }
            return new StationBackAzimuth(this.staLatLon, this.backAzimuth, this.geodesic);
        }
        return null;
    }

    @Override
    public boolean isLatLonable() {
        return this.evtLatLon != null && this.azimuth != null || this.staLatLon != null && this.backAzimuth != null;
    }
}

