/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicLine;

public class StationBackAzimuth
extends LatLonable {
    LatLonLocatable staLatLon;
    double backAzimuth;

    public StationBackAzimuth(LatLonLocatable staLatLon, Double backAzimuth, Geodesic geodesic) {
        this.staLatLon = staLatLon;
        this.backAzimuth = backAzimuth;
        this.geodesic = geodesic;
    }

    @Override
    public double[] calcLatLon(double calcDist, double totalDist) {
        double[] out = new double[2];
        Location staLoc = this.staLatLon.asLocation();
        if (this.isGeodetic()) {
            double backDistance = totalDist - calcDist;
            GeodesicLine gLine = this.geodesic.ArcDirectLine(staLoc.getLatitude(), staLoc.getLongitude(), this.backAzimuth, backDistance);
            out[0] = gLine.Latitude();
            out[1] = gLine.Longitude();
        } else {
            double evtLat = SphericalCoords.latFor(staLoc.getLatitude(), staLoc.getLongitude(), this.backAzimuth, totalDist);
            double evtLon = SphericalCoords.lonFor(staLoc.getLatitude(), staLoc.getLongitude(), this.backAzimuth, totalDist);
            double azimuth = SphericalCoords.azimuth(evtLat, evtLon, staLoc.getLatitude(), staLoc.getLongitude());
            out[0] = SphericalCoords.latFor(evtLat, evtLon, calcDist, azimuth);
            out[1] = SphericalCoords.lonFor(evtLat, evtLon, calcDist, azimuth);
        }
        return out;
    }
}

