/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.NoArrivalException;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.ShadowZone;
import edu.sc.seis.TauP.SimpleContigSeismicPhase;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.SlownessModelException;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TimeDist;
import edu.sc.seis.TauP.VelocityModelException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CompositeSeismicPhase
extends SimpleSeismicPhase {
    private final List<SimpleContigSeismicPhase> simplePhaseList;
    private final List<ShadowZone> shadowZones;

    public CompositeSeismicPhase(List<SimpleContigSeismicPhase> subphaseList) {
        this(subphaseList, new ArrayList<ShadowZone>());
        assert (subphaseList.size() != 1);
    }

    public CompositeSeismicPhase(List<SimpleContigSeismicPhase> subphaseList, List<ShadowZone> shadowZones) {
        this.simplePhaseList = subphaseList;
        this.shadowZones = shadowZones;
        if (this.simplePhaseList.size() < 2) {
            throw new IllegalArgumentException("Subphase list must not be empty or single: " + this.simplePhaseList.size());
        }
        SimpleContigSeismicPhase prev = null;
        for (SimpleContigSeismicPhase subphase : subphaseList) {
            if (prev != null) {
                if (prev.tMod != subphase.tMod) {
                    throw new IllegalArgumentException("subphases must all have same TauModel " + prev.tMod.getModelName() + " " + subphase.tMod.getModelName());
                }
                if (!Objects.equals(prev.getName(), subphase.getName())) {
                    throw new IllegalArgumentException("subphases must all have same name " + prev.getName() + " " + subphase.getName());
                }
                if (prev.getMinRayParam() != subphase.getMaxRayParam()) {
                    throw new IllegalArgumentException("subphase are not adjacent in ray param: " + prev.getMinRayParam() + " " + subphase.getMaxRayParam());
                }
                if (prev.getInitialPhaseSegment().isDownGoing != subphase.getInitialPhaseSegment().isDownGoing || prev.getInitialPhaseSegment().isPWave != subphase.getInitialPhaseSegment().isPWave || prev.getInitialPhaseSegment().startBranch != subphase.getInitialPhaseSegment().startBranch) {
                    throw new IllegalArgumentException("Initial phase segments not the same " + String.valueOf(prev) + " " + String.valueOf(subphase));
                }
                if (prev.getFinalPhaseSegment().isDownGoing != subphase.getFinalPhaseSegment().isDownGoing || prev.getFinalPhaseSegment().isPWave != subphase.getFinalPhaseSegment().isPWave || prev.getFinalPhaseSegment().endBranch != subphase.getFinalPhaseSegment().endBranch) {
                    throw new IllegalArgumentException("Final phase segments not the same " + String.valueOf(prev) + " " + String.valueOf(subphase));
                }
            }
            prev = subphase;
        }
    }

    public List<SimpleContigSeismicPhase> getSubPhaseList() {
        return this.simplePhaseList;
    }

    @Override
    public List<ShadowZone> getShadowZones() {
        return this.shadowZones;
    }

    @Override
    public SimpleSeismicPhase interpolateSimplePhase(double maxDeltaDeg) {
        ArrayList<SimpleContigSeismicPhase> interpList = new ArrayList<SimpleContigSeismicPhase>();
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            interpList.add(sp.interpolateSimplePhase(maxDeltaDeg));
        }
        return new CompositeSeismicPhase(interpList);
    }

    @Override
    public boolean isFail() {
        return !this.phasesExistsInModel();
    }

    @Override
    public String failReason() {
        if (!this.isFail()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            sb.append(sp.failReason()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean phasesExistsInModel() {
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            if (!sp.phasesExistsInModel()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Arrival getEarliestArrival(double degrees) {
        Arrival early = null;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            Arrival spArrival = sp.getEarliestArrival(degrees);
            if (early != null && !(spArrival.getTime() < early.getTime())) continue;
            early = spArrival;
        }
        return early;
    }

    @Override
    public TauModel getTauModel() {
        return this.simplePhaseList.get((int)0).tMod;
    }

    @Override
    public double getMinDistanceDeg() {
        return this.getMinDistance() * 180.0 / Math.PI;
    }

    @Override
    public double getMinDistance() {
        double minDist = Double.MAX_VALUE;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            minDist = Math.min(minDist, sp.getMinDistance());
        }
        return minDist;
    }

    @Override
    public double getMaxDistanceDeg() {
        return this.getMaxDistance() * 180.0 / Math.PI;
    }

    @Override
    public double getMaxDistance() {
        double maxDist = -1.7976931348623157E308;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            maxDist = Math.max(maxDist, sp.getMaxDistance());
        }
        return maxDist;
    }

    @Override
    public double getMaxRayParam() {
        double maxRP = -1.7976931348623157E308;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            maxRP = Math.max(maxRP, sp.getMaxRayParam());
        }
        return maxRP;
    }

    @Override
    public double getMinRayParam() {
        double minRP = Double.MAX_VALUE;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            minRP = Math.min(minRP, sp.getMinRayParam());
        }
        return minRP;
    }

    @Override
    public double getMinTime() {
        double minTime = Double.MAX_VALUE;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            minTime = Math.min(minTime, sp.getMinTime());
        }
        return minTime;
    }

    @Override
    public double getMaxTime() {
        double maxTime = -1.7976931348623157E308;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            maxTime = Math.max(maxTime, sp.getMaxTime());
        }
        return maxTime;
    }

    @Override
    public String getName() {
        return this.simplePhaseList.get(0).getName();
    }

    @Override
    public String getPuristName() {
        return this.simplePhaseList.get(0).getPuristName();
    }

    @Override
    public double getSourceDepth() {
        return this.simplePhaseList.get(0).getSourceDepth();
    }

    @Override
    public double getReceiverDepth() {
        return this.simplePhaseList.get(0).getReceiverDepth();
    }

    @Override
    public boolean hasArrivals() {
        for (SimpleSeismicPhase simpleSeismicPhase : this.simplePhaseList) {
            if (!simpleSeismicPhase.hasArrivals()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxRayParamIndex() {
        int idx = Integer.MAX_VALUE;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            idx = Integer.min(idx, sp.getMaxRayParamIndex());
        }
        return idx;
    }

    @Override
    public int getMinRayParamIndex() {
        int idx = -2147483647;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            idx = Integer.max(idx, sp.getMinRayParamIndex());
        }
        return idx;
    }

    @Override
    public List<List<SeismicPhaseSegment>> getListPhaseSegments() {
        ArrayList<List<SeismicPhaseSegment>> out = new ArrayList<List<SeismicPhaseSegment>>();
        for (SimpleContigSeismicPhase subphase : this.getSubPhaseList()) {
            out.add(subphase.getPhaseSegments());
        }
        return out;
    }

    @Override
    public SeismicPhaseSegment getInitialPhaseSegment() {
        return this.getSubPhaseList().get(0).getInitialPhaseSegment();
    }

    @Override
    public SeismicPhaseSegment getFinalPhaseSegment() {
        return this.getSubPhaseList().get(0).getFinalPhaseSegment();
    }

    @Override
    public int countFlatLegs() {
        int numFlat = this.simplePhaseList.get(0).countFlatLegs();
        for (SimpleContigSeismicPhase subphase : this.simplePhaseList) {
            if (numFlat == subphase.countFlatLegs()) continue;
            throw new RuntimeException("SHouldn't happen, num flat legs differs across shadow zone for " + this.getName());
        }
        return numFlat;
    }

    @Override
    public double getRayParams(int rayNum) {
        int idx = 0;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            if (rayNum - idx < sp.getNumRays()) {
                return sp.getRayParams(rayNum - idx);
            }
            idx += sp.getNumRays();
        }
        throw new ArrayIndexOutOfBoundsException(rayNum + " >= " + this.getNumRays() + " for CompositeSeismicPhase");
    }

    @Override
    public double[] getRayParams() {
        throw new RuntimeException("getPhaseSegments no impl for CompositeSeismicPhase");
    }

    @Override
    public double getDist(int rayNum) {
        int idx = 0;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            if (rayNum - idx < sp.getNumRays()) {
                return sp.getDist(rayNum - idx);
            }
            idx += sp.getNumRays();
        }
        throw new ArrayIndexOutOfBoundsException(rayNum + " >= " + this.getNumRays() + " for CompositeSeismicPhase");
    }

    @Override
    public double[] getDist() {
        throw new RuntimeException("getPhaseSegments no impl for CompositeSeismicPhase");
    }

    @Override
    public double getTime(int rayNum) {
        int idx = 0;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            if (rayNum - idx < sp.getNumRays()) {
                return sp.getTime(rayNum - idx);
            }
            idx += sp.getNumRays();
        }
        throw new ArrayIndexOutOfBoundsException(rayNum + " >= " + this.getNumRays() + " for CompositeSeismicPhase");
    }

    @Override
    public double[] getTime() {
        throw new RuntimeException("getTime no impl for CompositeSeismicPhase");
    }

    @Override
    public double getTau(int rayNum) {
        int idx = 0;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            if (rayNum - idx < sp.getNumRays()) {
                return sp.getTau(rayNum - idx);
            }
            idx += sp.getNumRays();
        }
        throw new ArrayIndexOutOfBoundsException(rayNum + " >= " + this.getNumRays() + " for CompositeSeismicPhase");
    }

    @Override
    public double[] getTau() {
        throw new RuntimeException("getPhaseSegments no impl for CompositeSeismicPhase");
    }

    @Override
    public Arrival createArrivalAtIndex(int rayNum) {
        int idx = 0;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            if (rayNum - idx < sp.getNumRays()) {
                return sp.createArrivalAtIndex(rayNum - idx);
            }
            idx += sp.getNumRays();
        }
        throw new ArrayIndexOutOfBoundsException(rayNum + " >= " + this.getNumRays() + " for CompositeSeismicPhase");
    }

    @Override
    public Arrival shootRay(double rayParam) throws TauPException {
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            if (!(sp.getMinRayParam() <= rayParam) || !(rayParam <= sp.getMaxRayParam())) continue;
            return sp.shootRay(rayParam);
        }
        throw new TauPException("rayParam doesn't exist for this phase " + rayParam + ", " + this.getName());
    }

    @Override
    public boolean isAllPWave() {
        return this.getSubPhaseList().get(0).isAllPWave();
    }

    @Override
    public boolean isAllSWave() {
        return this.getSubPhaseList().get(0).isAllSWave();
    }

    @Override
    public double calcRayParamForTakeoffAngle(double takeoffDegree) throws NoArrivalException {
        return this.getSubPhaseList().get(0).calcRayParamForTakeoffAngle(takeoffDegree);
    }

    @Override
    public double calcRayParamForIncidentAngle(double incidentDegree) throws NoArrivalException {
        return this.getSubPhaseList().get(0).calcRayParamForIncidentAngle(incidentDegree);
    }

    @Override
    public double velocityAtSource() {
        return this.getSubPhaseList().get(0).velocityAtSource();
    }

    @Override
    public double velocityAtReceiver() {
        return this.getSubPhaseList().get(0).velocityAtReceiver();
    }

    @Override
    public double densityAtReceiver() {
        return this.getSubPhaseList().get(0).densityAtReceiver();
    }

    @Override
    public double densityAtSource() {
        return this.getSubPhaseList().get(0).densityAtSource();
    }

    @Override
    public double calcTakeoffAngleDegree(double arrivalRayParam) {
        return this.getSubPhaseList().get(0).calcTakeoffAngleDegree(arrivalRayParam);
    }

    @Override
    public double calcTakeoffAngle(double arrivalRayParam) {
        return this.getSubPhaseList().get(0).calcTakeoffAngle(arrivalRayParam);
    }

    @Override
    public double calcIncidentAngle(double arrivalRayParam) {
        return this.getSubPhaseList().get(0).calcIncidentAngle(arrivalRayParam);
    }

    @Override
    public double calcIncidentAngleDegree(double arrivalRayParam) {
        return this.getSubPhaseList().get(0).calcIncidentAngleDegree(arrivalRayParam);
    }

    @Override
    public boolean sourceSegmentIsPWave() {
        return this.getSubPhaseList().get(0).sourceSegmentIsPWave();
    }

    @Override
    public boolean finalSegmentIsPWave() {
        return this.getSubPhaseList().get(0).finalSegmentIsPWave();
    }

    @Override
    public List<Arrival> calcTimeExactDistance(double searchDist) {
        ArrayList<Arrival> out = new ArrayList<Arrival>();
        for (SimpleContigSeismicPhase sp : this.getSubPhaseList()) {
            out.addAll(sp.calcTimeExactDistance(searchDist));
        }
        return out;
    }

    @Override
    public List<ArrivalPathSegment> calcSegmentPaths(Arrival arrival, TimeDist prevEnd, int prevIdx) throws NoArrivalException, SlownessModelException, TauModelException {
        return arrival.getSimpleContigSeismicPhase().calcSegmentPaths(arrival, prevEnd, prevIdx);
    }

    @Override
    public void dump() {
        for (SimpleContigSeismicPhase subphase : this.simplePhaseList) {
            subphase.dump();
        }
    }

    @Override
    public SeismicPhase interpolatePhase(double maxDeltaDeg) {
        ArrayList<SimpleContigSeismicPhase> out = new ArrayList<SimpleContigSeismicPhase>();
        for (SimpleContigSeismicPhase sp : this.getSubPhaseList()) {
            out.add(sp.interpolatePhase(maxDeltaDeg));
        }
        return new CompositeSeismicPhase(out);
    }

    @Override
    public double calcEnergyFluxFactorReflTranPSV(Arrival arrival) throws VelocityModelException {
        return arrival.getSimpleContigSeismicPhase().calcEnergyFluxFactorReflTranPSV(arrival);
    }

    @Override
    public double calcEnergyFluxFactorReflTranSH(Arrival arrival) throws VelocityModelException {
        return arrival.getSimpleContigSeismicPhase().calcEnergyFluxFactorReflTranSH(arrival);
    }

    @Override
    public List<TimeDist> interpPierceTimeDist(Arrival arrival) throws TauModelException {
        return arrival.getSimpleContigSeismicPhase().interpPierceTimeDist(arrival);
    }

    @Override
    public double calcTstar(Arrival arrival) {
        return arrival.getSimpleContigSeismicPhase().calcTstar(arrival);
    }

    @Override
    public int getNumRays() {
        int out = 0;
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            out += sp.getNumRays();
        }
        return out;
    }

    @Override
    public String describe() {
        StringBuilder s = new StringBuilder();
        List<ShadowZone> shadowZones = this.getShadowZones();
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            s.append(sp.describe()).append("\n");
            int idx = this.simplePhaseList.indexOf(sp);
            if (idx == this.simplePhaseList.size() - 1) continue;
            s.append(shadowZones.get(idx)).append("\n");
        }
        return s.toString();
    }

    @Override
    public String describeShort() {
        StringBuilder s = new StringBuilder();
        for (SimpleContigSeismicPhase sp : this.simplePhaseList) {
            s.append(sp.describeShort()).append("\n");
        }
        return s.toString();
    }
}

