/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.cmdline.args.AbstractOutputTypeArgs;
import picocli.CommandLine;

public class TextCsvOutputTypeArgs
extends AbstractOutputTypeArgs {
    @CommandLine.ArgGroup(heading="Output Type:%n")
    TextCsvOutputType outputType = new TextCsvOutputType();

    public TextCsvOutputTypeArgs(String defaultFormat, String filebase) {
        super(filebase);
        this.setOutputFormat(defaultFormat);
    }

    public boolean isText() {
        return this.outputType._isText;
    }

    public boolean isJSON() {
        return this.outputType._isJSON;
    }

    public boolean isHTML() {
        return this.outputType._isHTML;
    }

    public boolean isCSV() {
        return this.outputType._isCSV;
    }

    @Override
    public void setOutputFormat(String oType) {
        this.outputType._isText = false;
        this.outputType._isJSON = false;
        this.outputType._isHTML = false;
        this.outputType._isCSV = false;
        if (oType.equalsIgnoreCase("text")) {
            this.outputType._isText = true;
        } else if (oType.equalsIgnoreCase("json")) {
            this.outputType._isJSON = true;
        } else if (oType.equalsIgnoreCase("html")) {
            this.outputType._isHTML = true;
        } else if (oType.equalsIgnoreCase("csv")) {
            this.outputType._isCSV = true;
        } else {
            throw new IllegalArgumentException("output type " + oType + " not recognized.");
        }
    }

    @Override
    public String getOutputFormat() {
        if (this.isJSON()) {
            return "json";
        }
        if (this.isCSV()) {
            return "csv";
        }
        if (this.isHTML()) {
            return "html";
        }
        return "text";
    }

    @Override
    public String getOutFileExtension() {
        if (this.extension != null && !this.extension.isEmpty()) {
            return this.extension;
        }
        String calcExt = "text";
        if (this.isJSON()) {
            calcExt = "json";
        } else if (this.isHTML()) {
            calcExt = "html";
        } else if (this.isCSV()) {
            calcExt = "csv";
        }
        return calcExt;
    }

    static class TextCsvOutputType {
        @CommandLine.Option(names={"--text"}, required=true, description={"outputs as Text"})
        boolean _isText = false;
        @CommandLine.Option(names={"--json"}, required=true, description={"outputs as JSON"})
        boolean _isJSON = false;
        @CommandLine.Option(names={"--html"}, required=true, description={"outputs as HTML"})
        boolean _isHTML = false;
        @CommandLine.Option(names={"--csv"}, required=true, description={"outputs as CSV"})
        boolean _isCSV = false;

        TextCsvOutputType() {
        }
    }
}

