/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.StdModelGenerator;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauModelLoader;
import edu.sc.seis.TauP.TauPConfig;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.VelocityModelException;
import edu.sc.seis.TauP.cmdline.TauP_Spikes;
import edu.sc.seis.TauP.cmdline.TauP_Tool;
import edu.sc.seis.TauP.cmdline.TauP_Web;
import edu.sc.seis.TauP.cmdline.ToolRun;
import edu.sc.seis.TauP.gson.GsonUtil;
import edu.sc.seis.seisFile.mseed3.MSeed3Record;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.Headers;
import io.undertow.util.MimeMappings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import picocli.CommandLine;

public class TauP_WebServe
extends TauP_Tool {
    static Pattern allowedModelNamePat = Pattern.compile("[^[\\w._-]]");
    public static List<String> disableOptions = List.of("o", "output", "help", "version", "phasefile");
    public int port = 7409;
    public String host = "localhost";
    public String wsNamespace = "localws";
    public String wsServiceName = "taup";
    public String wsServiceVersion = "3";
    public static final String PARAM_HELP = "paramhelp";
    public static final String CMD_LINE = "cmdline";
    public static final String MODEL_NAMES = "modelnames";
    public static final String DEFAULT_SERVICE_NAMESPACE = "localws";
    public static final String DEFAULT_SERVICE = "taup";
    public static final String DEFAULT_SERVICE_VERSION = "3";

    public TauP_WebServe() {
        super(null);
    }

    public TauP_WebServe(String wsNamespace) {
        super(null);
        this.wsNamespace = wsNamespace;
    }

    @Override
    public void init() {
    }

    @Override
    public void start() {
        System.out.println();
        System.out.println("   http://localhost:" + this.port);
        System.out.println("or");
        System.out.println("   http://localhost:" + this.port + "/" + this.wsNamespace + "/" + this.wsServiceName + "/" + this.wsServiceVersion);
        System.out.println();
        final HttpHandler taupToolHandler = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                try {
                    this.handleTauPRequest(exchange);
                }
                catch (Exception e) {
                    Alert.warning(e);
                    e.printStackTrace(System.err);
                    if (exchange.isResponseChannelAvailable()) {
                        String errorPage = "<html><head><title>Error</title></head><body><h3>Internal Error</h3><p>" + exchange.getRequestURL() + "?" + exchange.getQueryString() + "</p><p>" + e.getMessage() + "</p></body></html>";
                        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, "" + errorPage.length());
                        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/html");
                        exchange.setStatusCode(500);
                        exchange.getResponseSender().send(errorPage);
                    }
                    exchange.getResponseSender().send(e.getMessage());
                    throw e;
                }
            }

            public void handleTauPRequest(HttpServerExchange exchange) throws Exception {
                String path = exchange.getRequestPath();
                Alert.debug("handle TauP: " + path);
                if (path.equals("favicon.ico")) {
                    new ResponseCodeHandler(404).handleRequest(exchange);
                    return;
                }
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                String namespace = "";
                String service = TauP_WebServe.DEFAULT_SERVICE;
                String version = TauP_WebServe.DEFAULT_SERVICE_VERSION;
                String toolname = "";
                String cmdLineToolname = "";
                String[] splitPath = path.split("/");
                if (splitPath.length >= 4) {
                    namespace = splitPath[0];
                    service = splitPath[1];
                    version = splitPath[2];
                    toolname = splitPath[3];
                    if (Objects.equals(toolname, "query")) {
                        toolname = "time";
                    }
                    if (splitPath.length >= 5) {
                        cmdLineToolname = splitPath[4];
                    }
                    Alert.debug("load via split: ns: " + namespace + " ser: " + service + " ver: " + version + " tool: " + toolname);
                } else if (splitPath.length >= 1) {
                    namespace = TauP_WebServe.this.wsNamespace;
                    service = TauP_WebServe.this.wsServiceName;
                    version = TauP_WebServe.this.wsServiceVersion;
                    if (this.isKnownTool(splitPath[0])) {
                        toolname = splitPath[0];
                        if (splitPath.length >= 2) {
                            cmdLineToolname = splitPath[1];
                        }
                        Alert.debug("load via single: " + toolname);
                    }
                }
                if (TauP_WebServe.this.wsNamespace.equals(namespace) && TauP_WebServe.this.wsServiceName.equals(service)) {
                    if (TauP_WebServe.this.wsServiceVersion.equals(version)) {
                        if (toolname.equals(TauP_WebServe.MODEL_NAMES)) {
                            TauP_WebServe.this.handleKnownModels(exchange);
                        } else if (toolname.equals(TauP_WebServe.CMD_LINE) && ToolRun.isKnownToolName(cmdLineToolname)) {
                            TauP_Tool tool = TauP_WebServe.this.createTool(cmdLineToolname);
                            TauP_WebServe.this.handleCmdLine(tool, exchange);
                        } else if (toolname.equals(TauP_WebServe.PARAM_HELP)) {
                            TauP_WebServe.this.handleParamHelp(exchange);
                        } else if (ToolRun.isKnownToolName(toolname)) {
                            this.handleTauPTool(exchange, namespace, service, version, toolname);
                        }
                    } else {
                        Alert.info("Unknown version: " + version);
                        new ResponseCodeHandler(404).handleRequest(exchange);
                        exchange.getResponseSender().send(TauP_WebServe.this.createVersionsPage("Tool Version " + version + " unknown"));
                    }
                } else {
                    new ResponseCodeHandler(404).handleRequest(exchange);
                    exchange.getResponseSender().send(TauP_WebServe.this.createVersionsPage("Namespace " + namespace + " or servicename " + service + " unknown"));
                }
            }

            public boolean isKnownTool(String toolname) {
                if (toolname == null || toolname.isEmpty()) {
                    return false;
                }
                if (toolname.startsWith(TauP_WebServe.CMD_LINE) || toolname.equals(TauP_WebServe.PARAM_HELP) || toolname.equals(TauP_WebServe.MODEL_NAMES)) {
                    return true;
                }
                return ToolRun.isKnownToolName(toolname);
            }

            public void handleTauPTool(HttpServerExchange exchange, String namespace, String service, String version, String toolname) throws Exception {
                Alert.debug("Try to run as tool: " + toolname);
                Map queryParams = exchange.getQueryParameters();
                if (!ToolRun.isKnownToolName(toolname)) {
                    return;
                }
                TauP_Tool tool = TauP_WebServe.this.createTool(toolname);
                if (tool != null) {
                    Alert.debug("Handle via TauP Tool:" + toolname);
                    TauP_WebServe.this.webRunTool(tool, queryParams, exchange);
                } else {
                    Alert.debug("Can't find tool for :" + toolname + " in " + exchange.getRequestPath());
                }
            }
        };
        final ResourceHandler resHandler = new ResourceHandler((ResourceManager)new ClassPathResourceManager(TauP_Web.class.getClassLoader(), "edu/sc/seis/TauP/html"));
        MimeMappings nmm = MimeMappings.builder((boolean)true).addMapping("mjs", "application/javascript").addMapping("tvel", "text/plain").addMapping("nd", "text/plain").build();
        resHandler.setMimeMappings(nmm);
        resHandler.addWelcomeFiles(new String[]{"index.html"});
        PathHandler pathHandler = new PathHandler((HttpHandler)resHandler);
        final String prefix = "/" + this.wsNamespace + "/" + this.wsServiceName + "/" + this.wsServiceVersion;
        HttpHandler toolAndResHandler = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                taupToolHandler.handleRequest(exchange);
                if (exchange.isComplete()) {
                    return;
                }
                if (exchange.getRequestPath().startsWith(prefix)) {
                    exchange.setRequestPath(exchange.getRequestPath().substring(prefix.length()));
                }
                resHandler.handleRequest(exchange);
            }
        };
        HttpHandler serviceVersionList = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String[] splitPath;
                String path = exchange.getRequestPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((splitPath = path.split("/")).length > 2) {
                    String version = splitPath[2];
                    new ResponseCodeHandler(404).handleRequest(exchange);
                    exchange.getResponseSender().send(TauP_WebServe.this.createVersionsPage("serviceVersionList Version " + version + " unknown"));
                    return;
                }
                if (path.equals(TauP_WebServe.this.wsNamespace + "/" + TauP_WebServe.this.wsServiceName)) {
                    String versionsPage = "<!DOCTYPE html>\n<html><head><title>Service Versions</title></head><body><h3><a href=\"/" + TauP_WebServe.this.wsNamespace + "\">" + TauP_WebServe.this.wsNamespace + "</a>/" + TauP_WebServe.this.wsServiceName + " Service Versions:</h3>\n";
                    versionsPage = versionsPage + "<a href=\"/" + TauP_WebServe.this.wsNamespace + "/" + TauP_WebServe.this.wsServiceName + "/" + TauP_WebServe.this.wsServiceVersion + "\">/" + TauP_WebServe.this.wsNamespace + "/" + TauP_WebServe.this.wsServiceName + "/" + TauP_WebServe.this.wsServiceVersion + "</a>\n</body></html>";
                    exchange.getResponseSender().send(versionsPage);
                    return;
                }
                if (TauPConfig.DEBUG) {
                    Alert.debug("serviceVersionList No handle " + path + "  expect: /" + TauP_WebServe.this.wsNamespace + "/" + TauP_WebServe.this.wsServiceName);
                }
            }
        };
        HttpHandler servicesList = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String path = exchange.getRequestPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.equals(TauP_WebServe.this.wsNamespace)) {
                    String servicesPage = "<!DOCTYPE html>\n<html><head><title>Services</title></head><body><h3>Known " + TauP_WebServe.this.wsNamespace + " Services:</h3>\n";
                    servicesPage = servicesPage + "<a href=\"/" + TauP_WebServe.this.wsNamespace + "/" + TauP_WebServe.this.wsServiceName + "\">/" + TauP_WebServe.this.wsNamespace + "/" + TauP_WebServe.this.wsServiceName + "</a>\n</body></html>";
                    TauP_WebServe.this.configContentType("html", exchange);
                    exchange.getResponseSender().send(servicesPage);
                    return;
                }
                if (TauPConfig.VERBOSE) {
                    Alert.debug("servicesList No handle " + path + "  expect: /" + TauP_WebServe.this.wsNamespace);
                }
            }
        };
        pathHandler.addPrefixPath(prefix, toolAndResHandler);
        pathHandler.addPrefixPath("/" + this.wsNamespace, servicesList);
        pathHandler.addPrefixPath("/" + this.wsNamespace + "/" + this.wsServiceName, serviceVersionList);
        pathHandler.addPrefixPath("/", toolAndResHandler);
        Undertow server = Undertow.builder().addHttpListener(this.port, this.host).setHandler((HttpHandler)new BlockingHandler((HttpHandler)pathHandler)).build();
        server.start();
    }

    @Override
    public void destroy() throws TauPException {
    }

    @Override
    public void validateArguments() throws TauModelException {
    }

    public String createVersionsPage(String errorMessage) {
        Object versionsPage = "<!DOCTYPE html>\n<html><head><title>Unknown Service Version</title></head><body>";
        if (errorMessage != null) {
            versionsPage = (String)versionsPage + "<h1>Error: " + errorMessage + "</h1>\n";
        }
        versionsPage = (String)versionsPage + "<h3><a href=\"/" + this.wsNamespace + "\">" + this.wsNamespace + "</a>/" + this.wsServiceName + " Service Versions:</h3>\n";
        versionsPage = (String)versionsPage + "<a href=\"/" + this.wsNamespace + "/" + this.wsServiceName + "/" + this.wsServiceVersion + "\">/" + this.wsNamespace + "/" + this.wsServiceName + "/" + this.wsServiceVersion + "</a>\n</body></html>";
        return versionsPage;
    }

    public void configContentType(String format, HttpServerExchange exchange) throws TauPException {
        String contentType;
        switch (format) {
            case "html": {
                contentType = "text/html";
                break;
            }
            case "text": 
            case "gmt": 
            case "nd": 
            case "locsat": {
                contentType = "text/plain";
                break;
            }
            case "csv": {
                contentType = "text/csv";
                break;
            }
            case "svg": {
                contentType = "image/svg+xml";
                break;
            }
            case "json": {
                contentType = "application/json";
                break;
            }
            case "ms3": {
                contentType = "application/x-miniseed3";
                break;
            }
            default: {
                throw new TauPException("Unknown format: " + format);
            }
        }
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentType);
    }

    public TauP_Tool createTool(String toolToRun) {
        while (toolToRun.startsWith("/")) {
            toolToRun = toolToRun.substring(1);
        }
        return ToolRun.getToolForName(toolToRun);
    }

    /*
     * Could not resolve type clashes
     */
    public static List<String> queryParamsToCmdLineArgs(CommandLine.Model.CommandSpec spec, Map<String, Deque<String>> queryParams) throws TauPException {
        ArrayList<String> out = new ArrayList<String>();
        for (String qp : queryParams.keySet()) {
            String dashedQP = (qp.length() == 1 ? "-" : "--") + qp;
            if (disableOptions.contains(qp)) {
                throw new TauPException("Query param not allowed: " + qp);
            }
            CommandLine.Model.OptionSpec op = spec.findOption(dashedQP);
            Deque<String> qpList = queryParams.get(qp);
            if (qp.equalsIgnoreCase("mod") || qp.equalsIgnoreCase("model")) {
                for (Object p : qpList) {
                    if (!allowedModelNamePat.matcher((CharSequence)p).find()) continue;
                    throw new TauPException("Modelname contains unallowed characters: " + (String)p);
                }
            }
            if (op != null) {
                if (op.typeInfo().isBoolean()) {
                    if (qpList.size() == 1 && qpList.getFirst().equalsIgnoreCase("false") || qpList.size() != 1 || !qpList.getFirst().equalsIgnoreCase("true")) continue;
                    out.add(dashedQP);
                    continue;
                }
                out.add(dashedQP);
                if (op.splitRegex().trim().isEmpty()) {
                    Object p;
                    ArrayList<String> paramItems = new ArrayList<String>();
                    p = qpList.iterator();
                    while (p.hasNext()) {
                        Object p2 = (String)p.next();
                        paramItems.addAll(Arrays.asList(((String)p2).split(",")));
                    }
                    if (op.isMultiValue() && op.arity().min() > 1 && op.arity().min() == op.arity().max() && paramItems.size() % op.arity().max() == 0) {
                        int idx = 0;
                        for (String p3 : paramItems) {
                            out.add(p3);
                            if (idx <= paramItems.size() - op.arity().max() && idx % op.arity().max() == op.arity().max() - 1) {
                                out.add(dashedQP);
                            }
                            ++idx;
                        }
                        continue;
                    }
                    out.addAll(paramItems);
                    continue;
                }
                if (op.splitRegex().trim().equals(",")) {
                    Object commaList = "";
                    for (Object p2 : qpList) {
                        commaList = (String)commaList + (String)p2 + ",";
                    }
                    commaList = ((String)commaList).substring(0, ((String)commaList).length() - 1);
                    out.add((String)commaList);
                    continue;
                }
                out.addAll((Collection<String>)queryParams.get(qp));
                continue;
            }
            if (qp.equalsIgnoreCase("format")) {
                if (qpList.size() > 1) {
                    throw new TauPException("Only one format at a time: " + qpList.getFirst() + " " + qpList.peek());
                }
                String format = "--" + qpList.getFirst();
                op = spec.findOption(format);
                if (op != null) {
                    out.add(format);
                    continue;
                }
            }
            for (String unarg : spec.commandLine().getUnmatchedArguments()) {
                Alert.warning(unarg);
            }
            Alert.warning(spec.commandLine().getUsageMessage());
            throw new TauPException("Unknown parameter: '" + qp + "' value: '" + qpList.getFirst() + "'");
        }
        return out;
    }

    public void handleParamHelp(HttpServerExchange exchange) throws TauPException {
        Map queryParams = exchange.getQueryParameters();
        if (queryParams.containsKey("tool")) {
            String toolname = (String)((Deque)queryParams.get("tool")).getFirst();
            TauP_Tool tool = this.createTool(toolname);
            JsonObject out = new JsonObject();
            out.addProperty("tool", toolname);
            CommandLine cmd = new CommandLine(tool);
            CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
            if (queryParams.containsKey("param")) {
                String arg = (String)((Deque)queryParams.get("param")).getFirst();
                String dashedQP = (arg.length() == 1 ? "-" : "--") + arg;
                CommandLine.Model.OptionSpec op = spec.findOption(dashedQP);
                if (op != null) {
                    Object desc = "";
                    for (String s : op.description()) {
                        desc = (String)desc + s;
                    }
                    out.addProperty("param", arg);
                    out.addProperty("desc", (String)desc);
                }
            } else {
                out.addProperty("name", cmd.getCommandName());
                JsonArray allOps = new JsonArray();
                out.add("params", (JsonElement)allOps);
                for (CommandLine.Model.OptionSpec op : spec.options()) {
                    JsonObject opObj = new JsonObject();
                    JsonArray nameArr = new JsonArray(op.names().length);
                    for (String n : op.names()) {
                        nameArr.add(n);
                    }
                    opObj.add("name", (JsonElement)nameArr);
                    Object descStr = "";
                    for (String n : op.description()) {
                        descStr = (String)descStr + n + "\n";
                    }
                    opObj.addProperty("desc", ((String)descStr).trim());
                    allOps.add((JsonElement)opObj);
                }
            }
            Gson gson = GsonUtil.createGsonBuilder().create();
            exchange.getResponseSender().send(gson.toJson((JsonElement)out));
            return;
        }
        throw new TauPException("Unable to create param help for " + exchange.getQueryString() + " " + queryParams.containsKey("tool"));
    }

    public void handleKnownModels(HttpServerExchange exchange) {
        Gson gson = GsonUtil.createGsonBuilder().create();
        exchange.getResponseSender().send(gson.toJson(this.getKnownModels()));
    }

    public List<String> getKnownModels() {
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(StdModelGenerator.standardModels);
        out.addAll(TauModelLoader.otherVelocityModels.keySet());
        return out;
    }

    public void handleCmdLine(TauP_Tool tool, HttpServerExchange exchange) throws TauPException {
        CommandLine cmd = new CommandLine(tool);
        CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
        List<String> argList = TauP_WebServe.queryParamsToCmdLineArgs(spec, exchange.getQueryParameters());
        StringBuilder buffer = new StringBuilder();
        buffer.append(TauP_Tool.toolNameFromClass(tool.getClass()));
        for (String s : argList) {
            buffer.append(" " + s);
        }
        this.configContentType("text", exchange);
        exchange.getResponseSender().send(buffer.toString());
    }

    public void webRunTool(TauP_Tool tool, Map<String, Deque<String>> queryParams, HttpServerExchange exchange) throws Exception {
        block13: {
            StringWriter sw = new StringWriter();
            CommandLine cmd = new CommandLine(tool);
            cmd.setOut(new PrintWriter(sw));
            CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
            List<String> argList = TauP_WebServe.queryParamsToCmdLineArgs(spec, queryParams);
            ArrayList modList = new ArrayList();
            if (queryParams.containsKey("mod")) {
                modList.addAll(queryParams.get("mod"));
            }
            if (queryParams.containsKey("model")) {
                modList.addAll(queryParams.get("model"));
            }
            List<String> knownModels = this.getKnownModels();
            for (Object mod : modList) {
                if (knownModels.contains(mod)) continue;
                throw new VelocityModelException("Unknown model " + (String)mod + " in " + tool.getClass().getName());
            }
            argList.add("-o");
            argList.add("stdout");
            StringBuilder buffer = new StringBuilder();
            buffer.append(TauP_Tool.toolNameFromClass(tool.getClass()));
            for (String s : argList) {
                buffer.append(" " + s);
            }
            Alert.debug("  " + String.valueOf(buffer));
            try {
                CommandLine.ParseResult parseResult = cmd.parseArgs(argList.toArray(argList.toArray(new String[0])));
                tool.setOutFileBase("stdout");
                if (cmd.isUsageHelpRequested()) {
                    cmd.usage(cmd.getOut());
                    break block13;
                }
                if (cmd.isVersionHelpRequested()) {
                    cmd.printVersionHelp(cmd.getOut());
                    break block13;
                }
                if (tool instanceof TauP_Spikes) {
                    TauP_Spikes taup_spikes;
                    block14: {
                        taup_spikes = (TauP_Spikes)tool;
                        try {
                            taup_spikes.validateArguments();
                        }
                        catch (Exception e) {
                            if (!exchange.isResponseChannelAvailable()) break block14;
                            exchange.setStatusCode(500);
                            exchange.setReasonPhrase(e.getMessage());
                            exchange.endExchange();
                            return;
                        }
                    }
                    ArrayList<MSeed3Record> allRecords = new ArrayList<MSeed3Record>();
                    List<MSeed3Record> spikeRecords = taup_spikes.calcSpikes(taup_spikes.getRayCalculatables());
                    allRecords.addAll(spikeRecords);
                    ArrayList<ByteBuffer> bufList = new ArrayList<ByteBuffer>();
                    for (MSeed3Record ms3 : allRecords) {
                        bufList.add(ms3.asByteBuffer());
                    }
                    exchange.getResponseSender().send(bufList.toArray(new ByteBuffer[0]));
                    break block13;
                }
                Integer statusCode = tool.call();
                cmd.setExecutionResult(statusCode);
                if (statusCode != 0) {
                    Alert.warning("\nWARN: status code non-zero: " + statusCode + "\n");
                }
                this.configContentType(tool.getOutputFormat(), exchange);
                exchange.getResponseSender().send(sw.toString());
            }
            catch (Exception e) {
                Alert.warning("\nException in tool exec: " + e.getMessage() + "\n");
                Alert.warning("  " + String.valueOf(buffer));
                Alert.warning("  " + String.valueOf(e));
                throw e;
            }
        }
    }

    @Override
    public String getOutputFormat() {
        return null;
    }
}

