/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.LinearInterpolation;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.TauModel;

public class Theta {
    protected double radians;
    protected double[] thetaAtX;
    protected double[] rayParams;

    public Theta(Arrival arrival) {
        SeismicPhase phase = arrival.getPhase();
        this.radians = arrival.getDist();
        int minRayParamIndex = phase.getMinRayParamIndex();
        int maxRayParamIndex = phase.getMaxRayParamIndex();
        this.rayParams = phase.getRayParams();
        this.thetaAtX = phase.getTau();
        TauModel tMod = phase.getTauModel();
        for (int i = 0; i < this.thetaAtX.length; ++i) {
            int n = i;
            this.thetaAtX[n] = this.thetaAtX[n] + this.rayParams[i] * this.radians;
        }
    }

    public double getRadians() {
        return this.radians;
    }

    public double[] getThetaAtX() {
        return this.thetaAtX;
    }

    public double[] getRayParams() {
        return this.rayParams;
    }

    public double getMaxRayParam() {
        return this.rayParams[0];
    }

    public double getStepRayParam(double rayParam, double timeStep) {
        int i;
        double thetaStart = this.getTheta(rayParam);
        boolean found = false;
        for (i = this.getThetaIndex(rayParam); i < this.thetaAtX.length - 1 && Math.abs(this.thetaAtX[i + 1] - thetaStart) <= timeStep; ++i) {
        }
        if (i >= this.thetaAtX.length - 1) {
            return -1.0;
        }
        double newTheta = thetaStart < this.thetaAtX[i + 1] ? thetaStart + timeStep : thetaStart - timeStep;
        return LinearInterpolation.linearInterp(this.thetaAtX[i], this.rayParams[i], this.thetaAtX[i + 1], this.rayParams[i + 1], newTheta);
    }

    public double getTheta(double rayParam) {
        if (rayParam > this.rayParams[0] || rayParam < this.rayParams[this.rayParams.length - 1]) {
            throw new ArrayIndexOutOfBoundsException(rayParam + " not in range " + this.rayParams[0] + " to " + this.rayParams[this.rayParams.length - 1]);
        }
        int currentNum = this.getThetaIndex(rayParam);
        double thetaStart = LinearInterpolation.linearInterp(this.rayParams[currentNum], this.thetaAtX[currentNum], this.rayParams[currentNum + 1], this.thetaAtX[currentNum + 1], rayParam);
        return thetaStart;
    }

    protected int getThetaIndex(double rayParam) {
        int tooSmallNum = 0;
        int tooLargeNum = this.rayParams.length - 1;
        int currentNum = 0;
        boolean found = false;
        while (!found) {
            currentNum = (int)Math.floor((float)(tooSmallNum + tooLargeNum) / 2.0f);
            if (this.rayParams[currentNum] >= rayParam && this.rayParams[currentNum + 1] < rayParam) {
                found = true;
                continue;
            }
            if (this.rayParams[currentNum] > rayParam) {
                tooSmallNum = currentNum;
                continue;
            }
            if (!(this.rayParams[currentNum] <= rayParam)) continue;
            tooLargeNum = currentNum;
        }
        return currentNum;
    }
}

