/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.ShootableRay;
import edu.sc.seis.TauP.SimpleSeismicPhase;
import edu.sc.seis.TauP.TauPException;
import java.util.ArrayList;
import java.util.List;

public class RayParamRay
extends ShootableRay {
    Double rayParam;
    Double rayParamSDeg = null;

    public RayParamRay(double rayParam) {
        this.rayParam = rayParam;
    }

    public static RayParamRay ofRayParamSRadian(double d) {
        RayParamRay rp = new RayParamRay(d);
        rp.setDescription(d + " s/rad");
        return rp;
    }

    public static RayParamRay ofRayParamSDegree(double d) {
        RayParamRay rp = RayParamRay.ofRayParamSRadian(d / (Math.PI / 180));
        rp.rayParamSDeg = d;
        rp.setDescription(d + " s/deg");
        return rp;
    }

    @Override
    public List<Arrival> calculate(SeismicPhase phase) throws TauPException {
        ArrayList<Arrival> arrivals = new ArrayList<Arrival>();
        if (phase instanceof SimpleSeismicPhase && phase.getMinRayParam() <= this.rayParam && this.rayParam <= phase.getMaxRayParam()) {
            Arrival phaseArrival = phase.shootRay(this.rayParam);
            phaseArrival.setSearchValue(this);
            arrivals.add(phaseArrival);
        }
        return arrivals;
    }

    public Double getRayParam() {
        return this.rayParam;
    }

    public boolean hasSDegree() {
        return this.rayParamSDeg != null;
    }

    public Double getRayParamSDegree() {
        if (this.rayParamSDeg != null) {
            return this.rayParamSDeg;
        }
        return this.rayParam / 57.29577951308232;
    }
}

