/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.FaultPlane;
import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.MomentMagnitude;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.SeismicSource;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;
import edu.sc.seis.seisFile.fdsnws.quakeml.Event;
import edu.sc.seis.seisFile.fdsnws.quakeml.FocalMechanism;
import java.util.List;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicLine;

public abstract class RayCalculateable {
    protected LatLonLocatable staLatLon = null;
    protected LatLonLocatable evtLatLon = null;
    protected Double azimuth = null;
    protected Double backAzimuth = null;
    protected boolean geodetic = false;
    protected Double invFlattening = null;
    protected Geodesic geodesic = null;
    protected String description = null;
    protected SeismicSource seismicSource = null;

    public void insertSeismicSource(LatLonLocatable evtLoc) {
        if (evtLoc instanceof Event) {
            Event event = (Event)evtLoc;
            if (event.getFocalMechanismList().size() > 0) {
                FocalMechanism fm = (FocalMechanism)event.getFocalMechanismList().get(0);
                if (fm.getNodalPlane().length > 0) {
                    FaultPlane fp = new FaultPlane(fm.getNodalPlane()[0]);
                    SeismicSource es = new SeismicSource(event.getPreferredMagnitude().getMag().getValue().floatValue(), fp);
                    this.setSeismicSource(es);
                }
            } else {
                SeismicSource es = new SeismicSource(event.getPreferredMagnitude().getMag().getValue().floatValue());
                this.setSeismicSource(es);
            }
        }
    }

    public abstract List<Arrival> calculate(SeismicPhase var1) throws TauPException;

    public void withEventAzimuth(LatLonLocatable evt, double azimuth) {
        this.evtLatLon = evt;
        this.azimuth = azimuth;
        this.backAzimuth = null;
        this.insertSeismicSource(evt);
    }

    public void withStationBackAzimuth(LatLonLocatable sta, double backazimuth) {
        this.staLatLon = sta;
        this.azimuth = null;
        this.backAzimuth = backazimuth;
    }

    public abstract boolean isLatLonable();

    public abstract LatLonable getLatLonable();

    public boolean hasSourceDepth() {
        return this.evtLatLon != null && this.evtLatLon.asLocation().hasDepth();
    }

    public Double getSourceDepth() {
        return this.evtLatLon != null ? this.evtLatLon.asLocation().getDepthKm() : null;
    }

    public boolean hasSource() {
        return this.evtLatLon != null;
    }

    public LatLonLocatable getSource() {
        return this.evtLatLon;
    }

    public boolean hasReceiverDepth() {
        return this.staLatLon != null && this.staLatLon.asLocation().hasDepth();
    }

    public Double getReceiverDepth() {
        return this.staLatLon != null ? this.staLatLon.asLocation().getDepthKm() : null;
    }

    public boolean hasReceiver() {
        return this.staLatLon != null;
    }

    public LatLonLocatable getReceiver() {
        return this.staLatLon;
    }

    public boolean hasAzimuth() {
        return this.azimuth != null || this.staLatLon != null && this.evtLatLon != null;
    }

    public boolean isGeodetic() {
        return this.geodetic;
    }

    public Double getInvFlattening() {
        return this.invFlattening;
    }

    public Double getNormalizedAzimuth() {
        Double az = this.getAzimuth();
        return RayCalculateable.normalizAzimuth(az);
    }

    public static Double normalizAzimuth(Double az) {
        if (az != null && (az = Double.valueOf(az % 360.0)) > 180.0) {
            az = az - 360.0;
        }
        return az;
    }

    public Double getAzimuth() {
        if (this.azimuth != null) {
            return this.azimuth;
        }
        if (this.evtLatLon != null && this.staLatLon != null) {
            if (this.getLatLonable().isGeodetic()) {
                Location evt = this.evtLatLon.asLocation();
                Location sta = this.staLatLon.asLocation();
                GeodesicLine gLine = this.geodesic.InverseLine(evt.getLatitude(), evt.getLongitude(), sta.getLatitude(), sta.getLongitude());
                return gLine.Azimuth();
            }
            return SphericalCoords.azimuth(this.evtLatLon.asLocation(), this.staLatLon.asLocation());
        }
        if (this.staLatLon != null && this.backAzimuth != null) {
            if (this.getLatLonable().isGeodetic()) {
                return null;
            }
            return null;
        }
        throw new RuntimeException("should not happen");
    }

    public void setAzimuth(Double azimuth) {
        this.azimuth = azimuth;
    }

    public boolean hasBackAzimuth() {
        return this.backAzimuth != null || this.evtLatLon != null && this.staLatLon != null;
    }

    public Double getNormalizedBackAzimuth() {
        Double baz = this.getBackAzimuth();
        return RayCalculateable.normalizAzimuth(baz);
    }

    public Double getBackAzimuth() {
        if (this.backAzimuth != null) {
            return this.backAzimuth;
        }
        if (this.evtLatLon != null && this.staLatLon != null) {
            if (this.getLatLonable().isGeodetic()) {
                Location evt = this.evtLatLon.asLocation();
                Location sta = this.staLatLon.asLocation();
                GeodesicLine gLine = this.geodesic.InverseLine(sta.getLatitude(), sta.getLongitude(), evt.getLatitude(), evt.getLongitude());
                return gLine.Azimuth();
            }
            return SphericalCoords.azimuth(this.staLatLon, this.evtLatLon);
        }
        if (this.staLatLon != null && this.azimuth != null) {
            if (this.getLatLonable().isGeodetic()) {
                return null;
            }
            return null;
        }
        throw new RuntimeException("should not happen");
    }

    public void setBackAzimuth(Double backAzimuth) {
        this.backAzimuth = backAzimuth;
    }

    public boolean hasMw() {
        LatLonLocatable ll;
        if (this.hasSeismicSource()) {
            return this.getSeismicSource().hasMw();
        }
        if (this.hasSource() && (ll = this.getSource()) instanceof Event) {
            Event event = (Event)ll;
            return event.getPreferredMagnitude() != null;
        }
        return false;
    }

    public float getMw() {
        Event event;
        LatLonLocatable ll;
        if (this.hasSource() && (ll = this.getSource()) instanceof Event && (event = (Event)ll).getPreferredMagnitude() != null) {
            return event.getPreferredMagnitude().getMag().getValue().floatValue();
        }
        if (this.hasSeismicSource() && this.getSeismicSource().hasMw()) {
            return this.getSeismicSource().getMw().floatValue();
        }
        return 4.0f;
    }

    public double getMoment() {
        return MomentMagnitude.mw_to_N_m(this.getMw());
    }

    public boolean hasFaultPlane() {
        return this.hasSeismicSource() && this.getSeismicSource().hasNodalPlane();
    }

    public FaultPlane getFaultPlane() {
        if (this.hasSeismicSource() && this.getSeismicSource().hasNodalPlane()) {
            return this.getSeismicSource().getNodalPlane1();
        }
        return null;
    }

    public double getAttenuationFrequency() {
        if (this.hasSeismicSource()) {
            return this.getSeismicSource().getAttenuationFrequency();
        }
        return 1.0;
    }

    public int getNumFrequencies() {
        if (this.hasSeismicSource()) {
            return this.getSeismicSource().getNumFrequencies();
        }
        return 64;
    }

    public boolean hasSeismicSource() {
        return this.seismicSource != null;
    }

    public void setSeismicSource(SeismicSource source) {
        this.seismicSource = source;
    }

    public SeismicSource getSeismicSource() {
        return this.seismicSource;
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String toString() {
        if (this.hasDescription()) {
            return this.getDescription();
        }
        return "";
    }
}

