/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.LatLonable;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicLine;

public class EventStation
extends LatLonable {
    LatLonLocatable evt;
    LatLonLocatable sta;

    public EventStation(LatLonLocatable evt, LatLonLocatable sta, Geodesic geodesic) {
        this.evt = evt;
        this.sta = sta;
        this.geodesic = geodesic;
    }

    @Override
    public double[] calcLatLon(double calcDist, double totalDist) {
        double[] out = new double[2];
        Location evtLoc = this.evt.asLocation();
        Location staLoc = this.sta.asLocation();
        if (this.isGeodetic()) {
            GeodesicLine gLine = this.geodesic.InverseLine(evtLoc.getLatitude(), evtLoc.getLongitude(), staLoc.getLatitude(), staLoc.getLongitude());
            out[0] = gLine.Latitude();
            out[1] = gLine.Longitude();
        } else {
            double azimuth = SphericalCoords.azimuth(evtLoc, staLoc);
            out[0] = SphericalCoords.latFor(evtLoc, calcDist, azimuth);
            out[1] = SphericalCoords.lonFor(evtLoc, calcDist, azimuth);
        }
        return out;
    }
}

