/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.seisFile.LatLonLocatable;
import edu.sc.seis.seisFile.Location;

public class DistAzLambert {
    public static final double wgs85_invflattening = 298.257223563;
    public static final double wgs85_flattening = 0.0033528106647474805;
    public static final double wgs85_meanEarthRadius = 6371.0088;
    private final double delta;
    private double az;
    private double baz;
    private final double stalat;
    private final double stalon;
    private final double evtlat;
    private final double evtlon;

    public DistAzLambert(LatLonLocatable loc1, LatLonLocatable loc2) {
        this(loc1.asLocation(), loc2.asLocation());
    }

    public DistAzLambert(LatLonLocatable loc1, LatLonLocatable loc2, double flattening) {
        this(loc1.asLocation(), loc2.asLocation(), flattening);
    }

    public DistAzLambert(Location loc1, Location loc2) {
        this(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude());
    }

    public DistAzLambert(Location loc1, Location loc2, double flattening) {
        this(loc1.getLatitude(), loc1.getLongitude(), loc2.getLatitude(), loc2.getLongitude(), flattening);
    }

    public DistAzLambert(double lat1, double lon1, double lat2, double lon2) {
        this(lat1, lon1, lat2, lon2, 0.0033528106647474805);
    }

    public DistAzLambert(double lat1, double lon1, double lat2, double lon2, double flattening) {
        this.evtlat = lat1;
        this.evtlon = lon1;
        this.stalat = lat2;
        this.stalon = lon2;
        if (lat1 == lat2 && lon1 == lon2) {
            this.delta = 0.0;
            this.az = 0.0;
            this.baz = 0.0;
            return;
        }
        double rad = Math.PI / 180;
        double sph = flattening;
        double slat = this.stalat * rad;
        double elat = this.evtlat * rad;
        double sredlat = Math.atan((1.0 - sph) * Math.tan(this.stalat * rad));
        double eredlat = Math.atan((1.0 - sph) * Math.tan(this.evtlat * rad));
        double slon = this.stalon * rad;
        double elon = this.evtlon * rad;
        double P = (eredlat + sredlat) / 2.0;
        double Q = (sredlat - eredlat) / 2.0;
        double haversine = (1.0 - Math.cos(sredlat - eredlat) + Math.cos(eredlat) * Math.cos(sredlat) * (1.0 - Math.cos(slon - elon))) / 2.0;
        double sigma = 2.0 * Math.asin(Math.sqrt(haversine));
        double sinP = Math.sin(P);
        double cosP = Math.cos(P);
        double sinQ = Math.sin(Q);
        double cosQ = Math.cos(Q);
        double cos_sigma_2 = Math.cos(sigma / 2.0);
        double sin_sigma_2 = Math.sin(sigma / 2.0);
        double X = (sigma - Math.sin(sigma)) * sinP * sinP * cosQ * cosQ / (cos_sigma_2 * cos_sigma_2);
        double Y = (sigma + Math.sin(sigma)) * cosP * cosP * sinQ * sinQ / (sin_sigma_2 * sin_sigma_2);
        double D = sigma - sph / 2.0 * (X + Y);
        this.delta = D / rad;
        double e2 = sph * (2.0 - sph);
        double lambda = (1.0 - e2) * Math.tan(slon) / Math.tan(elon) + e2 * Math.sqrt((1.0 + (1.0 - e2) * Math.tan(slon) * Math.tan(slon)) / (1.0 + (1.0 - e2) * Math.tan(elon) * Math.tan(elon)));
        double daz = Math.atan2(Math.sin(slat), (lambda - Math.cos(slat)) * Math.tan(slon));
        if (daz < 0.0) {
            daz += Math.PI * 2;
        }
        this.az = daz / rad;
        double bazlambda = (1.0 - e2) * Math.tan(elon) / Math.tan(slon) + e2 * Math.sqrt((1.0 + (1.0 - e2) * Math.tan(elon) * Math.tan(elon)) / (1.0 + (1.0 - e2) * Math.tan(slon) * Math.tan(slon)));
        double dbaz = Math.atan2(Math.sin(elat), (bazlambda - Math.cos(elat)) * Math.tan(elon));
        if (dbaz < 0.0) {
            dbaz += Math.PI * 2;
        }
        this.baz = dbaz / rad;
        if (Math.abs(this.baz - 360.0) < 1.0E-5) {
            this.baz = 0.0;
        }
        if (Math.abs(this.az - 360.0) < 1.0E-5) {
            this.az = 0.0;
        }
    }

    public double getDelta() {
        return this.delta;
    }

    public double getAz() {
        return this.az;
    }

    public double getBaz() {
        return this.baz;
    }

    public double getRadialAzimuth() {
        return (180.0 + this.getBaz()) % 360.0;
    }

    public double getTransverseAzimuth() {
        return (270.0 + this.getBaz()) % 360.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DistAzLambert) {
            DistAzLambert oAz = (DistAzLambert)o;
            if (oAz.stalat == this.stalat && oAz.stalon == this.stalon && oAz.evtlat == this.evtlat && oAz.evtlon == this.evtlon) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 24;
        result = 37 * result + Double.hashCode(this.stalat);
        result = 37 * result + Double.hashCode(this.stalon);
        result = 37 * result + Double.hashCode(this.evtlat);
        result = 37 * result + Double.hashCode(this.evtlon);
        return result;
    }

    public static double kmPerDeg() {
        return DistAzLambert.kmPerDeg(6371.0088);
    }

    public static double kmPerDeg(double radius) {
        return Math.PI * radius / 180.0;
    }

    public static double degreesToKilometers(double degrees) {
        return degrees * DistAzLambert.kmPerDeg();
    }

    public static double degreesToKilometers(double degrees, double radius) {
        return degrees * DistAzLambert.kmPerDeg(radius);
    }

    public static double kilometersToDegrees(double kilometers, double radius) {
        return kilometers / DistAzLambert.kmPerDeg(radius);
    }
}

