/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.ContinuedControlRecord;
import edu.sc.seis.seisFile.mseed.ControlHeader;
import edu.sc.seis.seisFile.mseed.ControlRecordLengthBlockette;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.PartialBlockette;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.DataInput;
import java.io.IOException;

public class ControlRecord
extends SeedRecord {
    public static final String THREESPACE = "   ";

    public ControlRecord(ControlHeader header) {
        super(header);
    }

    public static ControlRecord readControlRecord(DataInput inStream, ControlHeader header, int defaultRecordSize) throws IOException, SeedFormatException {
        ControlRecord controlRec = ControlRecord.readSingleControlRecord(inStream, header, defaultRecordSize, null);
        if (controlRec.getLastPartialBlockette() != null) {
            ContinuedControlRecord continuationCR = new ContinuedControlRecord(controlRec);
            ControlRecord nextPartialRecord = controlRec;
            while (nextPartialRecord.getLastPartialBlockette() != null) {
                ControlHeader nextHeader = ControlHeader.read(inStream);
                if (nextHeader instanceof DataHeader) {
                    throw new SeedFormatException("Control record continues, but next record is a DataRecord. curr=" + header.toString() + "  next=" + nextHeader.toString());
                }
                nextPartialRecord = ControlRecord.readSingleControlRecord(inStream, nextHeader, nextPartialRecord.getRecordSize(), nextPartialRecord.getLastPartialBlockette());
                continuationCR.addContinuation(nextPartialRecord);
            }
            controlRec = continuationCR;
        }
        return controlRec;
    }

    public static ControlRecord readSingleControlRecord(DataInput inStream, ControlHeader header, int defaultRecordSize, PartialBlockette partialBlockette) throws IOException, SeedFormatException {
        byte[] readBytes;
        int recordSize = defaultRecordSize;
        ControlRecord controlRec = new ControlRecord(header);
        int currOffset = header.getSize();
        if (partialBlockette != null && header.isContinuation()) {
            int length = partialBlockette.getTotalSize() - partialBlockette.getSoFarSize();
            readBytes = recordSize == 0 || length + currOffset < recordSize ? new byte[length] : new byte[recordSize - currOffset];
            inStream.readFully(readBytes);
            currOffset += readBytes.length;
            PartialBlockette b = new PartialBlockette(partialBlockette.getType(), readBytes, partialBlockette.getSwapBytes(), partialBlockette.getSoFarSize(), partialBlockette.getTotalSize());
            controlRec.addBlockette(b);
        }
        while (recordSize == 0 || currOffset <= recordSize - 7) {
            String typeStr;
            byte[] typeBytes = new byte[3];
            if (recordSize == 0 || currOffset < recordSize - 3) {
                inStream.readFully(typeBytes);
                typeStr = new String(typeBytes);
                currOffset += typeBytes.length;
            } else {
                typeStr = THREESPACE;
            }
            if (typeStr.equals(THREESPACE)) break;
            if (recordSize != 0 && currOffset >= recordSize - 4) {
                throw new SeedFormatException("Blockette type/length section is split across records");
            }
            int type = Integer.parseInt(typeStr.trim());
            byte[] lengthBytes = new byte[4];
            inStream.readFully(lengthBytes);
            String lengthStr = new String(lengthBytes);
            int length = Integer.parseInt(lengthStr.trim());
            readBytes = recordSize == 0 || length + currOffset - 7 < recordSize ? new byte[length - 7] : new byte[recordSize - (currOffset += lengthBytes.length)];
            inStream.readFully(readBytes);
            currOffset += readBytes.length;
            byte[] fullBlocketteBytes = new byte[7 + readBytes.length];
            System.arraycopy(typeBytes, 0, fullBlocketteBytes, 0, 3);
            System.arraycopy(lengthBytes, 0, fullBlocketteBytes, 3, 4);
            System.arraycopy(readBytes, 0, fullBlocketteBytes, 7, readBytes.length);
            Blockette b = length == fullBlocketteBytes.length ? SeedRecord.getBlocketteFactory().parseBlockette(type, fullBlocketteBytes, true) : new PartialBlockette(type, fullBlocketteBytes, true, 0, length);
            if (b instanceof ControlRecordLengthBlockette) {
                recordSize = ((ControlRecordLengthBlockette)b).getLogicalRecordLength();
            }
            controlRec.addBlockette(b);
        }
        if (recordSize == 0) {
            if (defaultRecordSize == 0) {
                throw new SeedFormatException("No blockettes 5, 8 or 10 to indicated record size and no default set");
            }
            recordSize = defaultRecordSize;
        }
        controlRec.RECORD_SIZE = recordSize;
        byte[] garbage = new byte[recordSize - currOffset];
        if (garbage.length != 0) {
            inStream.readFully(garbage);
        }
        return controlRec;
    }

    public void setRecordSize(int recordSize) throws SeedFormatException {
        this.RECORD_SIZE = recordSize;
    }
}

