/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.earthworm;

import edu.sc.seis.seisFile.earthworm.EarthwormEscapeOutputStream;
import edu.sc.seis.seisFile.earthworm.EarthwormHeartbeater;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthwormExport {
    int traceBufSent = 0;
    int splitTraceBufSent = 0;
    private String heartbeatMessage = "heartbeat";
    int module;
    int institution;
    EarthwormEscapeOutputStream outStream;
    BufferedInputStream inStream;
    int seqNum = 0;
    ServerSocket serverSocket;
    Socket clientSocket = null;
    private EarthwormHeartbeater heartbeater = null;
    int port;
    public boolean verbose = true;
    public static final byte ESC = 27;
    public static final byte STX = 2;
    public static final byte ETX = 3;
    public static final String SEQ_CODE = "SQ:";
    private static final Logger logger = LoggerFactory.getLogger(EarthwormExport.class);

    public EarthwormExport() {
    }

    public EarthwormExport(int port, int module, int institution, String heartbeatMessage, int heartbeatSeconds) throws IOException {
        this.port = port;
        this.module = module;
        this.institution = institution;
        this.heartbeatMessage = heartbeatMessage;
        this.initSocket();
        this.setHeartbeater(new EarthwormHeartbeater(null, heartbeatSeconds, heartbeatMessage, institution, module));
    }

    EarthwormExport(EarthwormEscapeOutputStream outStream, int module, int institution) {
        this.outStream = outStream;
        this.module = module;
        this.institution = institution;
        this.setHeartbeater(new EarthwormHeartbeater(outStream, 10, this.heartbeatMessage, institution, module));
    }

    public void exportWithRetry(TraceBuf2 traceBuf) throws IOException {
        boolean notSent = true;
        while (notSent) {
            try {
                this.export(traceBuf);
                notSent = false;
            }
            catch (Throwable e) {
                this.closeClient();
                logger.warn("Caught exception, waiting for reconnect, will resend tracebuf", e);
                this.waitForClient();
            }
        }
    }

    public void export(TraceBuf2 traceBuf) throws IOException {
        if (!this.isConnected()) {
            this.waitForClient();
        }
        ++this.traceBufSent;
        if (traceBuf.getSize() > 4096) {
            List<TraceBuf2> split = traceBuf.split(4096);
            if (this.verbose) {
                System.out.println("TraceBuf too large: " + traceBuf.getSize() + " split into " + split.size() + " pieces.");
            }
            ++this.splitTraceBufSent;
            for (TraceBuf2 splitTB : split) {
                this.writeTraceBuf(splitTB);
            }
        } else {
            this.writeTraceBuf(traceBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTraceBuf(TraceBuf2 tb) throws IOException {
        EarthwormEscapeOutputStream earthwormEscapeOutputStream = this.outStream;
        synchronized (earthwormEscapeOutputStream) {
            this.outStream.startTransmit();
            this.outStream.writeThreeChars(this.institution);
            this.outStream.writeThreeChars(this.module);
            this.outStream.writeThreeChars(19);
            DataOutputStream dos = new DataOutputStream(this.outStream);
            tb.write(dos);
            this.outStream.endTransmit();
            this.outStream.flush();
        }
    }

    void initSocket() throws IOException {
        logger.info("init socket on port: " + this.port);
        this.closeSocket();
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
        this.serverSocket = new ServerSocket(this.port);
        this.serverSocket.setSoTimeout(30000);
    }

    public boolean isConnected() {
        return this.outStream != null && this.getHeartbeater().getOutStream() != null;
    }

    public synchronized void waitForClient() throws IOException {
        while (!this.isConnected()) {
            try {
                this.getHeartbeater().setOutStream(null);
                if (this.serverSocket == null) {
                    this.initSocket();
                }
                logger.info("Wait for client: " + String.valueOf(this.serverSocket.getLocalSocketAddress()) + " " + this.serverSocket.getLocalPort());
                this.clientSocket = this.serverSocket.accept();
                logger.info("Connections from: " + String.valueOf(this.clientSocket.getRemoteSocketAddress()) + " " + this.clientSocket.getPort());
                this.inStream = new BufferedInputStream(this.clientSocket.getInputStream());
                this.outStream = new EarthwormEscapeOutputStream(new BufferedOutputStream(this.clientSocket.getOutputStream()));
                this.getHeartbeater().setOutStream(this.outStream);
                for (int i = 0; i < 10; ++i) {
                    this.getHeartbeater().heartbeat();
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.getHeartbeater().heartbeat();
                logger.info("initial heartbeat successful");
                if (this.verbose) {
                    System.out.println("accept connection from " + String.valueOf(this.clientSocket.getInetAddress()) + ":" + this.clientSocket.getPort());
                }
                return;
            }
            catch (SocketTimeoutException e) {
                logger.info("Socket timeout, close and try again", (Throwable)e);
                this.closeClient();
            }
        }
    }

    public byte[] readResponseBytes() throws IOException {
        if (this.inStream.available() > 0) {
            byte[] b = new byte[1024];
            int bytesRead = this.inStream.read(b);
            byte[] outBytes = new byte[bytesRead];
            System.arraycopy(b, 0, outBytes, 0, bytesRead);
            return outBytes;
        }
        return new byte[0];
    }

    public synchronized void closeClient() {
        logger.info("close client connection");
        if (this.outStream != null) {
            this.getHeartbeater().setOutStream(null);
        }
        EarthwormEscapeOutputStream.closeIfNotNull(this.outStream);
        this.outStream = null;
        EarthwormEscapeOutputStream.closeIfNotNull(this.inStream);
        this.inStream = null;
        EarthwormEscapeOutputStream.closeIfNotNull(this.clientSocket);
        this.clientSocket = null;
    }

    public void closeSocket() {
        logger.info("close socket");
        this.closeClient();
        EarthwormEscapeOutputStream.closeIfNotNull(this.serverSocket);
        this.serverSocket = null;
    }

    public int getNumTraceBufSent() {
        return this.traceBufSent;
    }

    public int getNumSplitTraceBufSent() {
        return this.splitTraceBufSent;
    }

    int getNextSeqNum() {
        if (this.seqNum == 999) {
            this.seqNum = 0;
        }
        return this.seqNum++;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public EarthwormHeartbeater getHeartbeater() {
        return this.heartbeater;
    }

    public void setHeartbeater(EarthwormHeartbeater heartbeater) {
        if (this.heartbeater != null) {
            this.heartbeater.cancel();
        }
        this.heartbeater = heartbeater;
    }
}

