/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.gson;

import edu.sc.seis.TauP.NamedVelocityDiscon;
import edu.sc.seis.TauP.NoSuchLayerException;
import edu.sc.seis.TauP.SlownessLayer;
import edu.sc.seis.TauP.VelocityLayer;
import edu.sc.seis.TauP.VelocityModel;

public class AboveBelowVelocityDiscon
extends NamedVelocityDiscon {
    VelocityLayer above = null;
    VelocityLayer below = null;
    VelocityModel vMod = null;

    public AboveBelowVelocityDiscon(double depth, VelocityModel vMod) throws NoSuchLayerException {
        super(depth);
        if (!vMod.isDisconDepth(depth)) {
            throw new NoSuchLayerException(vMod.getRadiusOfEarth() - depth, "Depth " + depth + " is not a velocity discontinuity in " + vMod.getModelName());
        }
        if (vMod.isNamedDisconDepth(depth)) {
            NamedVelocityDiscon nd = vMod.getNamedDisconForDepth(depth);
            this.name = nd.getName();
            if (nd.hasPreferredName()) {
                this.preferredName = nd.getPreferredName();
            }
        }
        if (depth != 0.0) {
            this.above = vMod.getVelocityLayer(vMod.layerNumberAbove(depth));
        }
        if (depth != vMod.getRadiusOfEarth()) {
            this.below = vMod.getVelocityLayer(vMod.layerNumberBelow(depth));
        }
        this.vMod = vMod;
    }

    public VelocityLayer getAbove() {
        return this.above;
    }

    public VelocityLayer getBelow() {
        return this.below;
    }

    public VelocityModel getVelocityModel() {
        return this.vMod;
    }

    public double getAboveSlownessP() {
        SlownessLayer p_SlowLayer = new SlownessLayer(this.above, this.vMod.getSpherical(), this.vMod.getRadiusOfEarth(), true);
        return p_SlowLayer.getBotP() / 57.29577951308232;
    }

    public double getAboveSlownessS() {
        SlownessLayer s_SlowLayer = new SlownessLayer(this.above, this.vMod.getSpherical(), this.vMod.getRadiusOfEarth(), false);
        return s_SlowLayer.getBotP() / 57.29577951308232;
    }

    public double getBelowSlownessP() {
        SlownessLayer p_SlowLayer = new SlownessLayer(this.below, this.vMod.getSpherical(), this.vMod.getRadiusOfEarth(), true);
        return p_SlowLayer.getTopP() / 57.29577951308232;
    }

    public double getBelowSlownessS() {
        SlownessLayer s_SlowLayer = new SlownessLayer(this.below, this.vMod.getSpherical(), this.vMod.getRadiusOfEarth(), false);
        return s_SlowLayer.getTopP() / 57.29577951308232;
    }
}

