/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import picocli.CommandLine;

public class GeodeticArgs {
    @CommandLine.Option(names={"--geodetic"}, description={"use geodetic latitude for distance calculations, which implies an ellipticity. Default is spherical. Note this only affects calculation of distance from lat/lon pairs, all travel time calculations are done in a purely spherical model."})
    protected boolean geodetic = false;
    @CommandLine.Option(names={"--geodeticflattening"}, paramLabel="f", description={"Inverse Elliptical flattening for distance calculations when --geodetic, defaults to WGS84 ~ 298.257. The distance calculation uses 1/x."})
    protected double geodeticFlattening = 298.257223563;
    public static final String GEODETIC = "geodetic";
    public static final String SPHERICAL = "spherical";

    public boolean isGeodetic() {
        return this.geodetic;
    }

    public double getInverseEllipFlattening() {
        return this.geodeticFlattening;
    }

    public void validateArguments() {
        if (this.getInverseEllipFlattening() <= 0.0) {
            throw new IllegalArgumentException("Inverse Elliptical flattening must be positive: " + this.getInverseEllipFlattening());
        }
    }

    public String getCalcType() {
        if (this.geodetic) {
            return GEODETIC;
        }
        return SPHERICAL;
    }
}

