/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.XYSegment;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class XYPlottingData {
    public final List<XYSegment> segmentList;
    public final String xAxisType;
    public final String yAxisType;
    public final String label;
    public final String description;
    public List<String> cssClasses;

    public XYPlottingData(List<XYSegment> segments, String xAxisType, String yAxisType, String label, List<String> cssClasses) {
        this(segments, xAxisType, yAxisType, label, "", cssClasses);
    }

    public XYPlottingData(List<XYSegment> segments, String xAxisType, String yAxisType, String label, String description, List<String> cssClasses) {
        this.segmentList = segments;
        this.xAxisType = xAxisType;
        this.yAxisType = yAxisType;
        this.label = label;
        this.description = description;
        this.cssClasses = cssClasses;
    }

    public static double[] initMinMax() {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        return new double[]{minX, maxX, minY, maxY};
    }

    public double[] minMax() {
        return this.minMax(XYPlottingData.initMinMax());
    }

    public double[] minMax(double[] priorMinMax) {
        for (XYSegment segment : this.segmentList) {
            priorMinMax = segment.minMax(priorMinMax);
        }
        return priorMinMax;
    }

    public double[] minMaxInXRange(double[] priorMinMax, double[] xRange) {
        for (XYSegment segment : this.segmentList) {
            priorMinMax = segment.minMaxInXRange(priorMinMax, xRange);
        }
        return priorMinMax;
    }

    public double[] minMaxInYRange(double[] priorMinMax, double[] yRange) {
        for (XYSegment segment : this.segmentList) {
            priorMinMax = segment.minMaxInYRange(priorMinMax, yRange);
        }
        return priorMinMax;
    }

    public XYPlottingData trimToMinMax(double[] xAxisMinMax, double[] yAxisMinMax) {
        ArrayList<XYSegment> outSeg = new ArrayList<XYSegment>();
        for (XYSegment seg : this.segmentList) {
            List<XYSegment> trimmed = seg.trimToMinMax(xAxisMinMax, yAxisMinMax);
            if (trimmed == null) continue;
            outSeg.addAll(trimmed);
        }
        XYPlottingData out = new XYPlottingData(outSeg, this.xAxisType, this.yAxisType, this.label, this.description, this.cssClasses);
        return out;
    }

    public static List<XYPlottingData> trimAllToMinMax(List<XYPlottingData> xyList, double[] xAxisMinMax, double[] yAxisMinMax) {
        if (xAxisMinMax.length == 2 || yAxisMinMax.length == 2) {
            ArrayList<XYPlottingData> trimmed = new ArrayList<XYPlottingData>();
            for (XYPlottingData xyp : xyList) {
                XYPlottingData t = xyp.trimToMinMax(xAxisMinMax, yAxisMinMax);
                if (t == null) continue;
                trimmed.add(t);
            }
            xyList = trimmed;
        }
        return xyList;
    }

    public XYPlottingData recalcForAbs(boolean xAxisAbs, boolean yAxisAbs) {
        ArrayList<XYSegment> out = new ArrayList<XYSegment>();
        for (XYSegment segment : this.segmentList) {
            out.add(segment.recalcForAbs(xAxisAbs, yAxisAbs));
        }
        Object xAxis = xAxisAbs ? "abs " + this.xAxisType : this.xAxisType;
        Object yAxis = yAxisAbs ? "abs " + this.yAxisType : this.yAxisType;
        return new XYPlottingData(out, (String)xAxis, (String)yAxis, this.label, this.description, this.cssClasses);
    }

    public XYPlottingData recalcForLog(boolean xAxisLog, boolean yAxisLog) {
        ArrayList<XYSegment> nanSplit = new ArrayList<XYSegment>();
        for (XYSegment xYSegment : this.segmentList) {
            nanSplit.addAll(xYSegment.recalcForInfinite(xAxisLog, yAxisLog));
        }
        ArrayList<XYSegment> logList = new ArrayList<XYSegment>();
        for (XYSegment segment : nanSplit) {
            logList.add(segment.recalcForLog(xAxisLog, yAxisLog));
        }
        Object object = xAxisLog ? "log " + this.xAxisType : this.xAxisType;
        Object yAxis = yAxisLog ? "log " + this.yAxisType : this.yAxisType;
        return new XYPlottingData(logList, (String)object, (String)yAxis, this.label, this.description, this.cssClasses);
    }

    public String cssClassesAsString() {
        Object cssClassParam = "";
        if (this.cssClasses != null && !this.cssClasses.isEmpty()) {
            for (String s : this.cssClasses) {
                cssClassParam = (String)cssClassParam + " " + s;
            }
        }
        return ((String)cssClassParam).trim();
    }

    public String createCSSClassParam() {
        Object cssClassParam = this.cssClassesAsString();
        if (this.cssClasses != null && !this.cssClasses.isEmpty()) {
            cssClassParam = "class=\"" + (String)cssClassParam + "\"";
        }
        return cssClassParam;
    }

    public void asSVG(PrintWriter writer) {
        String cssClassParam = this.createCSSClassParam();
        writer.println("    <g " + cssClassParam + " tauplabel=\"" + this.description + "\"  >");
        for (XYSegment segment : this.segmentList) {
            segment.asSVG(writer, "");
        }
        writer.println("    </g> <!-- end " + this.description + " -->");
    }

    public void asGMT(PrintWriter writer) {
        int idx = 1;
        for (XYSegment segment : this.segmentList) {
            segment.asGMT(writer, idx + "/" + this.segmentList.size() + " " + this.label + " " + this.description);
            ++idx;
        }
    }
}

