/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Alert;
import edu.sc.seis.TauP.AxisType;
import edu.sc.seis.TauP.ModelAxisType;
import edu.sc.seis.TauP.ReflTransAxisType;
import edu.sc.seis.TauP.cmdline.TauP_ReflTransPlot;
import java.util.Locale;
import java.util.Properties;

public class Outputs {
    public static Locale locale = Locale.ROOT;
    public static String depthFormat = "%8.1f";
    public static String distanceFormat = "%8.2f";
    public static String timeFormat = "%8.2f";
    public static String distanceFormatNoPad = "%.2f";
    public static String velocityFormat = "%5.2f";
    public static String timeFormatNoPad = "%.2f";
    public static String rayParamFormat = "%8.3f";
    public static String dpddegFormat = "%9.5f";
    public static String latLonFormat = "%8.2f";
    public static String ampFactorFormat = "%.1e";

    public static void configure(Properties props) {
        depthFormat = "%8." + props.getProperty("taup.depth.precision", "1") + "f";
        distanceFormat = "%8." + props.getProperty("taup.distance.precision", "2") + "f";
        timeFormat = "%8." + props.getProperty("taup.time.precision", "2") + "f";
        distanceFormatNoPad = "%." + props.getProperty("taup.distance.precision", "2") + "f";
        timeFormatNoPad = "%." + props.getProperty("taup.time.precision", "2") + "f";
        rayParamFormat = "%8." + props.getProperty("taup.rayparam.precision", "3") + "f";
        latLonFormat = "%8." + props.getProperty("taup.latlon.precision", "2") + "f";
        ampFactorFormat = "%." + props.getProperty("taup.amplitude.precision", "1") + "e";
    }

    public static String formatStringForAxisType(String axisType) {
        if (axisType.equals(TauP_ReflTransPlot.DegRayParam.degree.name())) {
            return "%8.3f";
        }
        if (axisType.equals(TauP_ReflTransPlot.DegRayParam.rayparam.name())) {
            return "%8.5f";
        }
        try {
            AxisType at = AxisType.valueOf(axisType);
            return Outputs.formatStringForAxisType(at);
        }
        catch (IllegalArgumentException e) {
            try {
                ModelAxisType mt = ModelAxisType.valueOf(axisType);
                return Outputs.formatStringForAxisType(mt);
            }
            catch (IllegalArgumentException ee) {
                try {
                    ReflTransAxisType mt = ReflTransAxisType.valueOf(axisType);
                    return Outputs.formatStringForAxisType(mt);
                }
                catch (IllegalArgumentException eee) {
                    Alert.warning("Unknown axis type: " + axisType);
                    return "%f";
                }
            }
        }
    }

    public static String formatStringForAxisType(ModelAxisType axisType) {
        String outFormat;
        switch (axisType) {
            case depth: 
            case radius: {
                outFormat = depthFormat;
                break;
            }
            case velocity: 
            case Vp: 
            case Vs: 
            case vpvs: 
            case vpdensity: 
            case vsdensity: 
            case velocity_density: {
                outFormat = rayParamFormat;
                break;
            }
            case youngsmodulus: 
            case poisson: 
            case shearmodulus: 
            case bulkmodulus: 
            case lambda: 
            case slownessdeg: 
            case slownessrad: 
            case slownessdeg_p: 
            case slownessdeg_s: 
            case slownessrad_p: 
            case slownessrad_s: {
                outFormat = rayParamFormat;
                break;
            }
            default: {
                outFormat = "%f";
            }
        }
        return outFormat;
    }

    public static String formatStringForAxisType(AxisType axisType) {
        String outFormat;
        switch (axisType) {
            case degree: 
            case degree180: 
            case kilometer: 
            case kilometer180: 
            case takeoffangle: 
            case incidentangle: {
                outFormat = distanceFormat;
                break;
            }
            case radian: 
            case radian180: 
            case rayparamrad: 
            case rayparamdeg: 
            case rayparamkm: 
            case theta: 
            case tau: 
            case tstar: {
                outFormat = rayParamFormat;
                break;
            }
            case time: {
                outFormat = timeFormat;
                break;
            }
            case amp: 
            case amppsv: 
            case ampsh: 
            case geospread: 
            case refltran: 
            case refltranpsv: 
            case refltransh: 
            case attenuation: {
                outFormat = ampFactorFormat;
                break;
            }
            case turndepth: {
                outFormat = distanceFormatNoPad;
                break;
            }
            case index: {
                outFormat = "%8.0f";
                break;
            }
            default: {
                outFormat = "%f";
            }
        }
        return outFormat;
    }

    public static String formatStringForAxisType(ReflTransAxisType axisType) {
        return "%f";
    }

    public static String formatDepth(double depth) {
        return String.format(locale, depthFormat, depth);
    }

    public static String formatVelocity(double velocity) {
        return String.format(locale, velocityFormat, velocity);
    }

    public static String formatDistance(double distance) {
        return String.format(locale, distanceFormat, distance);
    }

    public static String formatKilometer(double kilometers) {
        return String.format(locale, depthFormat, kilometers);
    }

    public static String formatTime(double time) {
        return String.format(locale, timeFormat, time);
    }

    public static String formatDistanceNoPad(double distance) {
        return String.format(locale, distanceFormatNoPad, distance);
    }

    public static String formatTimeNoPad(double time) {
        return String.format(locale, timeFormat, time);
    }

    public static String formatRayParam(double rayParam) {
        return String.format(locale, rayParamFormat, rayParam);
    }

    public static String formatDpDdeg(double dpddeg) {
        return String.format(locale, dpddegFormat, dpddeg);
    }

    public static String formatLatLon(double latlon) {
        return String.format(locale, latLonFormat, latlon);
    }

    public static String formatAmpFactor(double ampFactor) {
        String space = " ";
        if (ampFactor < 0.0) {
            space = "";
        }
        if (ampFactor == 0.0) {
            return space + String.format(locale, ampFactorFormat, 0.0);
        }
        return space + String.format(locale, ampFactorFormat, ampFactor);
    }
}

