/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP.cmdline.args;

import edu.sc.seis.TauP.cmdline.args.AbstractOutputTypeArgs;
import edu.sc.seis.TauP.cmdline.args.GraphicOutputTypeArgs;
import picocli.CommandLine;

public class VelPlotOutputTypeArgs
extends AbstractOutputTypeArgs {
    @CommandLine.ArgGroup(heading="Output Type:%n")
    VelPlotOutputType outputType = new VelPlotOutputType();
    public String psFile = null;
    @CommandLine.Option(names={"--mapwidth"}, description={"plot width in units from --mapwidthunit."})
    public Float mapwidth = Float.valueOf(6.0f);
    @CommandLine.Option(names={"--mapwidthunit"}, defaultValue="i", description={"plot width unit, i for inch, c for cm or p for px."})
    public String mapWidthUnit = "i";

    public VelPlotOutputTypeArgs(String defaultFormat, String filebase) {
        super(filebase);
        this.setOutputFormat(defaultFormat);
    }

    public GraphicOutputTypeArgs asGraphicOutputTypeArgs() {
        GraphicOutputTypeArgs out = new GraphicOutputTypeArgs(this.getOutputFormat(), this.getOutFileBase());
        out.mapWidthUnit = this.mapWidthUnit;
        out.mapwidth = this.mapwidth;
        return out;
    }

    @Override
    public String getOutputFormat() {
        if (this.isGMT()) {
            return "gmt";
        }
        if (this.isSVG()) {
            return "svg";
        }
        if (this.isHTML()) {
            return "html";
        }
        if (this.isJSON()) {
            return "json";
        }
        if (this.isCSV()) {
            return "csv";
        }
        if (this.isND()) {
            return "nd";
        }
        return "text";
    }

    @Override
    public String getOutFileExtension() {
        if (this.extension != null) {
            return this.extension;
        }
        String ext = "text";
        if (this.isSVG()) {
            ext = "svg";
        } else if (this.isHTML()) {
            ext = "html";
        } else if (this.isJSON()) {
            ext = "json";
        } else if (this.isGMT()) {
            ext = "gmt";
        } else if (this.isND()) {
            ext = "nd";
        } else if (this.isCSV()) {
            ext = "csv";
        }
        return ext;
    }

    @Override
    public void setOutputFormat(String oType) {
        this.outputType._isText = false;
        this.outputType._isJSON = false;
        this.outputType._isGMT = false;
        this.outputType._isSVG = false;
        this.outputType._isCsv = false;
        this.outputType._isND = false;
        if (oType.equalsIgnoreCase("text")) {
            this.outputType._isText = true;
        } else if (oType.equalsIgnoreCase("json")) {
            this.outputType._isJSON = true;
        } else if (oType.equalsIgnoreCase("gmt")) {
            this.outputType._isGMT = true;
            if (this.mapwidth == null) {
                this.mapwidth = Float.valueOf(6.0f);
            }
        } else if (oType.equalsIgnoreCase("svg")) {
            this.outputType._isSVG = true;
            if (this.mapwidth == null) {
                this.mapwidth = Float.valueOf(1000.0f);
            }
        } else if (oType.equalsIgnoreCase("csv")) {
            this.outputType._isCsv = true;
        } else if (oType.equalsIgnoreCase("nd")) {
            this.outputType._isND = true;
        } else {
            throw new IllegalArgumentException("output type " + oType + " not recognized.");
        }
    }

    public String getPsFile() {
        if (this.psFile != null) {
            return this.psFile;
        }
        return this.getOutFileBase() + ".ps";
    }

    public void setPsFile(String psFile) {
        this.psFile = psFile;
    }

    public Float getMapwidth() {
        return this.mapwidth;
    }

    public void setMapwidth(Float mapwidth) {
        this.mapwidth = mapwidth;
    }

    public String getMapWidthUnit() {
        return this.mapWidthUnit;
    }

    public void setMapWidthUnit(String mapWidthUnit) {
        this.mapWidthUnit = mapWidthUnit;
    }

    public boolean isText() {
        return this.outputType._isText;
    }

    public boolean isSVG() {
        return this.outputType._isSVG;
    }

    public boolean isHTML() {
        return this.outputType._isHTML;
    }

    public boolean isGMT() {
        return this.outputType._isGMT;
    }

    public boolean isJSON() {
        return this.outputType._isJSON;
    }

    public boolean isND() {
        return this.outputType._isND;
    }

    public boolean isCSV() {
        return this.outputType._isCsv;
    }

    public float getPixelWidth() {
        return GraphicOutputTypeArgs.getPixelWidth(this.mapwidth.floatValue(), this.mapWidthUnit);
    }

    static class VelPlotOutputType {
        @CommandLine.Option(names={"--text"}, required=true, description={"outputs as Text"})
        boolean _isText = false;
        @CommandLine.Option(names={"--json"}, required=true, description={"outputs as JSON"})
        boolean _isJSON = false;
        @CommandLine.Option(names={"--gmt"}, required=true, description={"outputs as GMT"})
        boolean _isGMT = false;
        @CommandLine.Option(names={"--svg"}, required=true, description={"outputs as SVG"})
        boolean _isSVG = false;
        @CommandLine.Option(names={"--html"}, required=true, description={"outputs as SVG inside HTML"})
        boolean _isHTML = false;
        @CommandLine.Option(names={"--csv"}, required=true, description={"outputs as CSV"})
        boolean _isCsv = false;
        @CommandLine.Option(names={"--nameddiscon"}, required=true, description={"outputs as .nd named discontinuity model file"})
        boolean _isND = false;

        VelPlotOutputType() {
        }
    }
}

