/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.NoArrivalException;
import edu.sc.seis.TauP.RayParamRay;
import edu.sc.seis.TauP.SeismicPhase;
import edu.sc.seis.TauP.ShootableRay;
import edu.sc.seis.TauP.TauPException;
import java.util.ArrayList;
import java.util.List;

public class TakeoffAngleRay
extends ShootableRay {
    Double takeoffAngle;

    public TakeoffAngleRay(Double takeoffAngle) {
        this.takeoffAngle = takeoffAngle;
        this.setDescription("Takeoff: " + takeoffAngle);
    }

    public static TakeoffAngleRay ofTakeoffAngle(Double d) {
        return new TakeoffAngleRay(d);
    }

    @Override
    public List<Arrival> calculate(SeismicPhase phase) throws TauPException {
        RayParamRay rayParamRay = this.forPhase(phase);
        if (rayParamRay == null) {
            return new ArrayList<Arrival>();
        }
        List<Arrival> arrivals = rayParamRay.calculate(phase);
        for (Arrival a : arrivals) {
            a.setSearchValue(this);
        }
        return arrivals;
    }

    public RayParamRay forPhase(SeismicPhase phase) {
        double rayParam;
        try {
            if (this.takeoffAngle > 90.0 && phase.getInitialPhaseSegment().isDownGoing) {
                return null;
            }
            if (this.takeoffAngle < 90.0 && !phase.getInitialPhaseSegment().isDownGoing) {
                return null;
            }
            rayParam = phase.calcRayParamForTakeoffAngle(this.takeoffAngle);
        }
        catch (NoArrivalException e) {
            return null;
        }
        return new RayParamRay(rayParam);
    }

    public Double getTakeoffAngle() {
        return this.takeoffAngle;
    }
}

