/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Vector;

public class SphericalCoordinate {
    double phi;
    double theta;
    double r;

    public SphericalCoordinate(double phi, double theta) {
        this(phi, theta, 1.0);
    }

    public SphericalCoordinate(double phi, double theta, double r) {
        this.phi = phi;
        this.theta = theta;
        this.r = r;
    }

    public static SphericalCoordinate fromAzTakeoffDegree(double azDeg, double takeoffDeg) {
        return new SphericalCoordinate(SphericalCoordinate.takeoffDegreeToPhiRadian(takeoffDeg), 1.5707963267948966 - azDeg * (Math.PI / 180));
    }

    public static SphericalCoordinate fromCartesian(double[] vector) {
        double r = Math.sqrt(vector[0] * vector[0] + vector[1] * vector[1] + vector[2] * vector[2]);
        double phi = Math.acos(vector[2] / r);
        double theta = Math.atan2(vector[1], vector[0]);
        return new SphericalCoordinate(phi, theta);
    }

    public Vector toCartesian() {
        return new Vector(this.r * Math.sin(this.phi) * Math.cos(this.theta), this.r * Math.sin(this.phi) * Math.sin(this.theta), this.r * Math.cos(this.phi));
    }

    public double getPhi() {
        return this.phi;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getR() {
        return this.r;
    }

    public double getAzimuthRadian() {
        return 1.5707963267948966 - this.theta;
    }

    public double getAzimuthDegree() {
        return 57.29577951308232 * this.getAzimuthRadian();
    }

    public double getTakeoffAngleDegree() {
        return SphericalCoordinate.phiToTakeoffToDegree(this.phi);
    }

    public double stereoR() {
        return Math.sin(this.phi) / (1.0 - Math.cos(this.phi));
    }

    public String toString() {
        return "Az: " + this.getAzimuthDegree() + " TO: " + this.getTakeoffAngleDegree() + " (phi:" + this.getPhi() + " theta:" + this.getTheta() + ")";
    }

    public static double takeoffDegreeToPhiRadian(double takeoffDeg) {
        return Math.PI - takeoffDeg * (Math.PI / 180);
    }

    public static double phiToTakeoffToRadian(double phi) {
        return Math.PI - phi;
    }

    public static double phiToTakeoffToDegree(double phi) {
        return SphericalCoordinate.phiToTakeoffToRadian(phi) * 57.29577951308232;
    }

    public static double[] crossProduct(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] - b[0]};
    }
}

