/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.TauP;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.ArrivalPathSegment;
import edu.sc.seis.TauP.ProtoSeismicPhase;
import edu.sc.seis.TauP.SeismicPhaseSegment;
import edu.sc.seis.TauP.SimpleContigSeismicPhase;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TimeDist;
import java.util.List;

public class FailedSeismicPhase
extends SimpleContigSeismicPhase {
    public FailedSeismicPhase(ProtoSeismicPhase proto) {
        super(proto, new double[0], new double[0], new double[0], -1.0, -1.0, -1, -1, 0.0, 0.0, false);
        this.proto.isFail = true;
    }

    public static FailedSeismicPhase failForReason(String phaseName, TauModel tMod, double receiverDepth, String failReason) {
        ProtoSeismicPhase proto = ProtoSeismicPhase.failNewPhase(tMod, true, true, receiverDepth, phaseName, failReason);
        FailedSeismicPhase fail = new FailedSeismicPhase(proto);
        return fail;
    }

    @Override
    public boolean phasesExistsInModel() {
        return false;
    }

    @Override
    public boolean isFail() {
        return !this.phasesExistsInModel();
    }

    @Override
    public String failReason() {
        if (this.isFail()) {
            return this.proto.failReason;
        }
        return "";
    }

    @Override
    public boolean hasArrivals() {
        return false;
    }

    @Override
    public Arrival createArrivalAtIndex(int rayNum) {
        return null;
    }

    @Override
    public Arrival shootRay(double rayParam) {
        return null;
    }

    @Override
    public List<ArrivalPathSegment> calcSegmentPaths(Arrival currArrival) {
        return List.of();
    }

    @Override
    public String describe() {
        return this.getName() + ":\n  Failed phase:\n  " + this.proto.failReason + "\n" + SeismicPhaseSegment.segmentListDescribe(this.getListPhaseSegments());
    }

    @Override
    public String describeShort() {
        String desc = this.getName() + (String)(this.getName().equals(this.getPuristName()) ? "" : " (" + this.getPuristName() + ")") + " source: " + this.getSourceDepth() + " km, receiver: " + this.getReceiverDepth() + " km Failed phase: " + this.proto.failReason;
        return desc;
    }

    @Override
    public double calcEnergyFluxFactorReflTranPSV(Arrival arrival) {
        return 0.0;
    }

    @Override
    public double calcEnergyFluxFactorReflTranSH(Arrival arrival) {
        return 0.0;
    }

    @Override
    public List<TimeDist> interpPierceTimeDist(Arrival arrival) {
        return List.of();
    }

    @Override
    public int getNumRays() {
        return 0;
    }
}

