/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.ControlBlockette;
import edu.sc.seis.seisFile.mseed.RecordLengthBlockette;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.PrintWriter;

public abstract class ControlRecordLengthBlockette
extends ControlBlockette
implements RecordLengthBlockette {
    public ControlRecordLengthBlockette(byte[] info) {
        super(info);
    }

    public String getVersionOfFormat() {
        return Utility.extractString(this.info, 7, 4);
    }

    @Override
    public int getLogicalRecordLengthByte() {
        return Utility.extractInteger(this.info, 11, 2);
    }

    @Override
    public int getLogicalRecordLength() {
        if (this.getLogicalRecordLengthByte() < 31) {
            return 1 << this.getLogicalRecordLengthByte();
        }
        throw new RuntimeException("Data Record Length exceeds size of int");
    }

    @Override
    public void writeASCII(PrintWriter out) {
        this.writeASCIINoNewline(out);
        out.println();
    }

    public void writeASCIINoNewline(PrintWriter out) {
        out.print("Blockette" + this.getType() + " record length=" + this.getLogicalRecordLength() + " (" + this.getLogicalRecordLengthByte() + ") " + new String(this.info));
    }
}

