/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Statistics;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerFactory;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerListener;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.freq.Cmplx;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredDataSetSeismogram
extends DataSetSeismogram
implements SeismogramContainerListener {
    private static Map filterMap = new HashMap();
    private static WorkerThreadPool filterPool = new WorkerThreadPool("FilterThread", 1, 4);
    private NamedFilter filter;
    private DataSetSeismogram wrappedDSS;
    private SeismogramContainer container;
    private List data = new ArrayList();
    private static final Logger logger = LoggerFactory.getLogger(FilteredDataSetSeismogram.class);

    private FilteredDataSetSeismogram(DataSetSeismogram dss, NamedFilter filter) {
        super(dss.getDataSet(), filter.getName());
        this.filter = filter;
        this.wrappedDSS = dss;
        this.container = SeismogramContainerFactory.create(this, this.wrappedDSS);
        this.container.getSeismograms();
    }

    public static FilteredDataSetSeismogram getFiltered(DataSetSeismogram dss, NamedFilter filter) {
        FilteredDataSetSeismogram fDSS;
        HashMap<DataSetSeismogram, FilteredDataSetSeismogram> dssMap = (HashMap<DataSetSeismogram, FilteredDataSetSeismogram>)filterMap.get(filter);
        if (dssMap != null) {
            fDSS = (FilteredDataSetSeismogram)dssMap.get(dss);
            if (fDSS != null) {
                return fDSS;
            }
        } else {
            dssMap = new HashMap<DataSetSeismogram, FilteredDataSetSeismogram>();
            filterMap.put(filter, dssMap);
        }
        fDSS = new FilteredDataSetSeismogram(dss, filter);
        dssMap.put(dss, fDSS);
        return fDSS;
    }

    @Override
    public void updateData() {
        filterPool.invokeLater(new Filterer());
    }

    public static LocalSeismogramImpl filterData(LocalSeismogramImpl seismogram, NamedFilter filter) throws FissuresException {
        float[] fdata;
        if (seismogram.can_convert_to_float()) {
            fdata = seismogram.get_as_floats();
        } else {
            int[] idata = seismogram.get_as_longs();
            fdata = new float[idata.length];
            for (int i = 0; i < idata.length; ++i) {
                fdata[i] = idata[i];
            }
            idata = null;
        }
        Statistics stats = new Statistics(fdata);
        double mean = stats.mean();
        float fmean = (float)mean;
        int i = 0;
        while (i < fdata.length) {
            int n = i++;
            fdata[n] = fdata[n] - fmean;
        }
        Cmplx[] fftdata = Cmplx.fft(fdata);
        fdata = null;
        double dt = seismogram.getSampling().getPeriod().convertTo(UnitImpl.SECOND).getValue();
        Cmplx[] filtered = filter.apply(dt, fftdata);
        fftdata = null;
        float[] outData = Cmplx.fftInverse(filtered, seismogram.getNumPoints());
        int i2 = 0;
        while (i2 < outData.length) {
            int n = i2++;
            outData[n] = outData[n] + fmean;
        }
        TimeSeriesDataSel sel = new TimeSeriesDataSel();
        sel.flt_values(outData);
        return new LocalSeismogramImpl((SeismogramAttr)seismogram, sel);
    }

    private LocalSeismogramImpl[] getFilteredSeismograms() {
        boolean someCollected = false;
        Iterator it = this.data.iterator();
        ArrayList<LocalSeismogramImpl> filteredSeis = new ArrayList<LocalSeismogramImpl>();
        while (it.hasNext()) {
            SoftReference current = (SoftReference)it.next();
            LocalSeismogramImpl curSeis = (LocalSeismogramImpl)current.get();
            if (curSeis != null) {
                filteredSeis.add(curSeis);
                continue;
            }
            it.remove();
            someCollected = true;
        }
        if (someCollected) {
            this.updateData();
        }
        return filteredSeis.toArray(new LocalSeismogramImpl[filteredSeis.size()]);
    }

    @Override
    public void retrieveData(SeisDataChangeListener dataListener) {
        this.pushData(this.getFilteredSeismograms(), dataListener);
    }

    @Override
    public boolean equals(Object other) {
        FilteredDataSetSeismogram otherFil;
        return super.equals(other) && (otherFil = (FilteredDataSetSeismogram)other).getFilter().equals(this.getFilter());
    }

    @Override
    public MicroSecondDate getBeginMicroSecondDate() {
        return this.wrappedDSS.getBeginMicroSecondDate();
    }

    @Override
    public Time getBeginTime() {
        return this.wrappedDSS.getBeginTime();
    }

    @Override
    public void setBeginTime(Time time) {
        throw new UnsupportedOperationException("Cannot set begin time on filtered seismogram.  It is entirely reliant on the wrapped dss time");
    }

    @Override
    public MicroSecondDate getEndMicroSecondDate() {
        return this.wrappedDSS.getEndMicroSecondDate();
    }

    @Override
    public Time getEndTime() {
        return this.wrappedDSS.getEndTime();
    }

    @Override
    public void setEndTime(Time time) {
        throw new UnsupportedOperationException("Cannot set end time on filtered seismogram.  It is entirely reliant on the wrapped dss time");
    }

    @Override
    public RequestFilter getRequestFilter() {
        return this.wrappedDSS.getRequestFilter();
    }

    public NamedFilter getFilter() {
        return this.filter;
    }

    private class Filterer
    implements Runnable {
        private Filterer() {
        }

        @Override
        public void run() {
            LocalSeismogramImpl[] containedSeis = FilteredDataSetSeismogram.this.container.getSeismograms();
            ArrayList<LocalSeismogramImpl> alreadyFiltered = new ArrayList<LocalSeismogramImpl>();
            Iterator it = FilteredDataSetSeismogram.this.data.iterator();
            boolean found = false;
            while (it.hasNext()) {
                SoftReference currentRef = (SoftReference)it.next();
                LocalSeismogramImpl current = (LocalSeismogramImpl)currentRef.get();
                if (current == null) {
                    it.remove();
                    break;
                }
                for (int i = 0; i < containedSeis.length && !found; ++i) {
                    if (!current.getEndTime().equals((Object)containedSeis[i].getEndTime()) || !current.getBeginTime().equals((Object)containedSeis[i].getBeginTime())) continue;
                    found = true;
                    alreadyFiltered.add(containedSeis[i]);
                }
                if (found) continue;
                it.remove();
            }
            for (int i = 0; i < containedSeis.length; ++i) {
                it = alreadyFiltered.iterator();
                found = false;
                while (it.hasNext()) {
                    Object o = it.next();
                    if (containedSeis[i] != o) continue;
                    found = true;
                }
                if (found) continue;
                try {
                    FilteredDataSetSeismogram.this.data.add(new SoftReference<LocalSeismogramImpl>(FilteredDataSetSeismogram.filterData(containedSeis[i], FilteredDataSetSeismogram.this.filter)));
                    continue;
                }
                catch (FissuresException e) {
                    GlobalExceptionHandler.handle("Problem filtering seismograms", e);
                }
            }
            if (containedSeis.length - alreadyFiltered.size() > 0) {
                FilteredDataSetSeismogram.this.pushData(FilteredDataSetSeismogram.this.getFilteredSeismograms(), null);
            }
        }
    }
}

