/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.time;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Cut;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import edu.sc.seis.fissuresUtil.hibernate.PlottableChunk;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.time.SortTool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ReduceTool {
    private static boolean contains(LocalSeismogramImpl container, LocalSeismogramImpl containee) {
        return ReduceTool.equalsOrBefore(container.getBeginTime(), containee.getBeginTime()) && ReduceTool.equalsOrAfter(container.getEndTime(), containee.getEndTime());
    }

    public static LocalSeismogramImpl[] cutOverlap(LocalSeismogramImpl[] seis) throws FissuresException {
        LocalSeismogramImpl[] tmp = new LocalSeismogramImpl[seis.length];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = seis[i];
        }
        seis = tmp;
        LSMerger merger = new LSMerger();
        for (int i = 0; i < seis.length; ++i) {
            boolean changeMade;
            if (seis[i] == null) continue;
            do {
                changeMade = false;
                for (int j = i + 1; j < seis.length; ++j) {
                    Cut cut;
                    if (seis[j] == null) continue;
                    if (ReduceTool.contains(seis[i], seis[j])) {
                        seis[j] = null;
                        changeMade = true;
                        continue;
                    }
                    if (ReduceTool.contains(seis[j], seis[i])) {
                        seis[i] = seis[j];
                        seis[j] = null;
                        changeMade = true;
                        continue;
                    }
                    if (!RangeTool.areOverlapping(seis[i], seis[j])) continue;
                    MicroSecondDate iEnd = seis[i].getEndTime();
                    MicroSecondDate iBegin = seis[i].getBeginTime();
                    TimeInterval halfSample = (TimeInterval)seis[i].getSampling().getPeriod().divideBy(2.0);
                    if (iEnd.before((Date)seis[j].getEndTime())) {
                        cut = new Cut(iEnd.add(halfSample), seis[j].getEndTime());
                        seis[j] = cut.apply(seis[j]);
                    } else {
                        cut = new Cut(seis[j].getBeginTime(), iBegin.subtract(halfSample));
                        seis[j] = cut.apply(seis[j]);
                    }
                    if (seis[j] != null) {
                        seis[i] = merger.merge(seis[i], seis[j]);
                        seis[j] = null;
                    }
                    changeMade = true;
                }
            } while (changeMade);
        }
        ArrayList<LocalSeismogramImpl> results = new ArrayList<LocalSeismogramImpl>(seis.length);
        for (int i = 0; i < seis.length; ++i) {
            if (seis[i] == null) continue;
            results.add(seis[i]);
        }
        return results.toArray(new LocalSeismogramImpl[0]);
    }

    public static LocalSeismogramImpl[] removeContained(LocalSeismogramImpl[] seis) {
        SortTool.byLengthAscending(seis);
        ArrayList<LocalSeismogramImpl> results = new ArrayList<LocalSeismogramImpl>();
        for (int i = 0; i < seis.length; ++i) {
            MicroSecondDate iEnd = seis[i].getEndTime();
            MicroSecondDate iBegin = seis[i].getBeginTime();
            boolean contained = false;
            for (int j = i + 1; j < seis.length && !contained; ++j) {
                if (!ReduceTool.equalsOrAfter(iBegin, seis[j].getBeginTime()) || !ReduceTool.equalsOrBefore(iEnd, seis[j].getEndTime())) continue;
                contained = true;
            }
            if (contained) continue;
            results.add(seis[i]);
        }
        return results.toArray(new LocalSeismogramImpl[0]);
    }

    public static LocalSeismogramImpl[] merge(LocalSeismogramImpl[] seis) {
        return new LSMerger().merge(seis);
    }

    public static RequestFilter[] merge(RequestFilter[] ranges) {
        return new RFMerger().merge(ranges);
    }

    public static List<RequestFilter> trimTo(List<RequestFilter> rfList, List<RequestFilter> windowList) {
        ArrayList<RequestFilter> out = new ArrayList<RequestFilter>();
        for (RequestFilter window : windowList) {
            MicroSecondDate windowStart = new MicroSecondDate(window.start_time);
            MicroSecondDate windowEnd = new MicroSecondDate(window.end_time);
            for (RequestFilter rf : rfList) {
                MicroSecondDate rfStart = new MicroSecondDate(rf.start_time);
                MicroSecondDate rfEnd = new MicroSecondDate(rf.end_time);
                if ((rfStart.after((Date)windowStart) || rfStart.equals((Object)windowStart)) && (rfEnd.before((Date)windowEnd) || rfEnd.equals((Object)windowEnd))) {
                    out.add(rf);
                    continue;
                }
                if (rfEnd.before((Date)windowStart) || rfEnd.equals((Object)windowStart) || rfStart.after((Date)windowEnd) || rfStart.equals((Object)windowEnd)) continue;
                if (rfStart.before((Date)windowStart)) {
                    rfStart = windowStart;
                }
                if (rfEnd.after((Date)windowEnd)) {
                    rfEnd = windowEnd;
                }
                out.add(new RequestFilter(rf.channel_id, rfStart.getFissuresTime(), rfEnd.getFissuresTime()));
            }
        }
        return out;
    }

    public static MicroSecondTimeRange[] merge(MicroSecondTimeRange[] ranges) {
        return new MSTRMerger().merge(ranges);
    }

    public static List<MicroSecondTimeRange> mergeMicroSecondTimeRange(List<MicroSecondTimeRange> ranges) {
        return new MSTRMerger().merge(ranges);
    }

    public static List<PlottableChunk> merge(List<PlottableChunk> chunks) {
        return new PlottableChunkMerger().merge(chunks);
    }

    public static RequestFilter cover(RequestFilter[] rf) {
        if (rf == null || rf.length == 0) {
            return null;
        }
        RFMerger rfm = new RFMerger();
        RequestFilter out = rf[0];
        for (int i = 1; i < rf.length; ++i) {
            out = (RequestFilter)rfm.merge(out, rf[i]);
        }
        return out;
    }

    public static boolean equalsOrAfter(MicroSecondDate first, MicroSecondDate second) {
        return first.equals((Object)second) || first.after((Date)second);
    }

    public static boolean equalsOrBefore(MicroSecondDate first, MicroSecondDate second) {
        return first.equals((Object)second) || first.before((Date)second);
    }

    private static class PlottableChunkMerger
    extends Merger {
        private PlottableChunkMerger() {
        }

        @Override
        public Object merge(Object one, Object two) {
            PlottableChunk chunk = this.cast(one);
            PlottableChunk chunk2 = this.cast(two);
            MicroSecondTimeRange fullRange = new MicroSecondTimeRange(chunk.getTimeRange(), chunk2.getTimeRange());
            int samples = (int)Math.floor((double)(chunk.getPixelsPerDay() * 2) * fullRange.getInterval().convertTo((UnitImpl)UnitImpl.DAY).value);
            int[] y = new int[samples];
            PlottableChunkMerger.fill(fullRange, y, chunk);
            PlottableChunkMerger.fill(fullRange, y, chunk2);
            Plottable mergedData = new Plottable(null, y);
            PlottableChunk earlier = chunk;
            if (chunk2.getBeginTime().before((Date)chunk.getBeginTime())) {
                earlier = chunk2;
            }
            return new PlottableChunk(mergedData, earlier.getBeginPixel(), earlier.getJDay(), earlier.getYear(), chunk.getPixelsPerDay(), chunk.getNetworkCode(), chunk.getStationCode(), chunk.getSiteCode(), chunk.getChannelCode());
        }

        @Override
        public boolean shouldMerge(Object one, Object two) {
            return RangeTool.areContiguous(this.cast(one), this.cast(two)) || RangeTool.areOverlapping(this.cast(one), this.cast(two));
        }

        private PlottableChunk cast(Object o) {
            return (PlottableChunk)o;
        }

        public List<PlottableChunk> merge(List<PlottableChunk> chunks) {
            return Arrays.asList((PlottableChunk[])this.internalMerge(chunks.toArray(), new PlottableChunk[0]));
        }

        public static int[] fill(MicroSecondTimeRange fullRange, int[] y, PlottableChunk chunk) {
            MicroSecondDate rowBeginTime = chunk.getBeginTime();
            int offsetIntoRequestSamples = SimplePlotUtil.getPixel(y.length / 2, fullRange, rowBeginTime) * 2;
            int[] dataY = chunk.getData().y_coor;
            int numSamples = dataY.length;
            int firstSampleForRequest = 0;
            if (offsetIntoRequestSamples < 0) {
                firstSampleForRequest = -1 * offsetIntoRequestSamples;
            }
            int lastSampleForRequest = numSamples;
            if (offsetIntoRequestSamples + numSamples > y.length) {
                lastSampleForRequest = y.length - offsetIntoRequestSamples;
            }
            for (int i = firstSampleForRequest; i < lastSampleForRequest; ++i) {
                y[i + offsetIntoRequestSamples] = dataY[i];
            }
            return y;
        }
    }

    private static class LSMerger
    extends Merger {
        private LSMerger() {
        }

        @Override
        public Object merge(Object one, Object two) {
            return this.merge((LocalSeismogramImpl)one, (LocalSeismogramImpl)two);
        }

        public LocalSeismogramImpl merge(LocalSeismogramImpl seis, LocalSeismogramImpl seis2) {
            MicroSecondTimeRange fullRange = new MicroSecondTimeRange(this.toMSTR(seis), this.toMSTR(seis2));
            if (fullRange.equals(this.toMSTR(seis))) {
                return seis;
            }
            LocalSeismogramImpl earlier = seis;
            LocalSeismogramImpl later = seis2;
            if (seis2.getBeginTime().before((Date)seis.getBeginTime())) {
                earlier = seis2;
                later = seis;
            }
            try {
                if (seis.is_encoded() && seis2.is_encoded()) {
                    EncodedData[] earlierED = earlier.get_as_encoded();
                    EncodedData[] laterED = later.get_as_encoded();
                    EncodedData[] outED = new EncodedData[earlierED.length + laterED.length];
                    System.arraycopy(earlierED, 0, outED, 0, earlierED.length);
                    System.arraycopy(laterED, 0, outED, earlierED.length, laterED.length);
                    TimeSeriesDataSel td = new TimeSeriesDataSel();
                    td.encoded_values(outED);
                    LocalSeismogramImpl newSeis = new LocalSeismogramImpl((SeismogramAttr)earlier, td);
                    newSeis.num_points = seis.num_points + seis2.num_points;
                    return newSeis;
                }
                int numPoints = seis.getNumPoints() + seis2.getNumPoints();
                if (seis.can_convert_to_short() && seis2.can_convert_to_short()) {
                    short[] outS = new short[numPoints];
                    System.arraycopy(earlier.get_as_shorts(), 0, outS, 0, earlier.getNumPoints());
                    System.arraycopy(later.get_as_shorts(), 0, outS, earlier.getNumPoints(), later.getNumPoints());
                    return new LocalSeismogramImpl((SeismogramAttr)earlier, outS);
                }
                if (seis.can_convert_to_long() && seis2.can_convert_to_long()) {
                    int[] outI = new int[numPoints];
                    System.arraycopy(earlier.get_as_longs(), 0, outI, 0, earlier.getNumPoints());
                    System.arraycopy(later.get_as_longs(), 0, outI, earlier.getNumPoints(), later.getNumPoints());
                    return new LocalSeismogramImpl((SeismogramAttr)earlier, outI);
                }
                if (seis.can_convert_to_float() && seis2.can_convert_to_float()) {
                    float[] outF = new float[numPoints];
                    System.arraycopy(earlier.get_as_floats(), 0, outF, 0, earlier.getNumPoints());
                    System.arraycopy(later.get_as_floats(), 0, outF, earlier.getNumPoints(), later.getNumPoints());
                    return new LocalSeismogramImpl((SeismogramAttr)earlier, outF);
                }
                double[] outD = new double[numPoints];
                System.arraycopy(earlier.get_as_doubles(), 0, outD, 0, earlier.getNumPoints());
                System.arraycopy(later.get_as_doubles(), 0, outD, earlier.getNumPoints(), later.getNumPoints());
                return new LocalSeismogramImpl((SeismogramAttr)earlier, outD);
            }
            catch (FissuresException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean shouldMerge(Object one, Object two) {
            return this.getChannelString(one).equals(this.getChannelString(two)) && (RangeTool.areContiguous((LocalSeismogramImpl)one, (LocalSeismogramImpl)two) || this.toMSTR(one).equals(this.toMSTR(two)));
        }

        protected String getChannelString(Object rf) {
            return ChannelIdUtil.toStringNoDates((ChannelId)((LocalSeismogramImpl)rf).channel_id);
        }

        protected MicroSecondTimeRange toMSTR(Object o) {
            return new MicroSecondTimeRange((LocalSeismogramImpl)o);
        }

        public LocalSeismogramImpl[] merge(LocalSeismogramImpl[] ranges) {
            return (LocalSeismogramImpl[])this.internalMerge(ranges, new LocalSeismogramImpl[0]);
        }
    }

    private static class RFMerger
    extends Merger {
        private RFMerger() {
        }

        @Override
        public Object merge(Object one, Object two) {
            RequestFilter orig = (RequestFilter)one;
            MicroSecondTimeRange tr = new MicroSecondTimeRange(this.toMSTR(one), this.toMSTR(two));
            return new RequestFilter(orig.channel_id, tr.getBeginTime().getFissuresTime(), tr.getEndTime().getFissuresTime());
        }

        protected String getChannelString(Object rf) {
            return ChannelIdUtil.toStringNoDates((ChannelId)((RequestFilter)rf).channel_id);
        }

        @Override
        public boolean shouldMerge(Object one, Object two) {
            return this.getChannelString(one).equals(this.getChannelString(two)) && (RangeTool.areOverlapping(this.toMSTR(one), this.toMSTR(two)) || RangeTool.areContiguous(this.toMSTR(one), this.toMSTR(two)));
        }

        protected MicroSecondTimeRange toMSTR(Object o) {
            return new MicroSecondTimeRange((RequestFilter)o);
        }

        public RequestFilter[] merge(RequestFilter[] ranges) {
            return (RequestFilter[])this.internalMerge(ranges, new RequestFilter[0]);
        }
    }

    private static class MSTRMerger
    extends Merger {
        private MSTRMerger() {
        }

        @Override
        public Object merge(Object one, Object two) {
            return new MicroSecondTimeRange(this.cast(one), this.cast(two));
        }

        @Override
        public boolean shouldMerge(Object one, Object two) {
            MicroSecondTimeRange o = (MicroSecondTimeRange)one;
            MicroSecondTimeRange t = (MicroSecondTimeRange)two;
            if (o.getBeginTime().before((Date)t.getBeginTime())) {
                return !o.getEndTime().before((Date)t.getBeginTime());
            }
            return !t.getEndTime().before((Date)o.getBeginTime());
        }

        public MicroSecondTimeRange cast(Object o) {
            return (MicroSecondTimeRange)o;
        }

        public MicroSecondTimeRange[] merge(MicroSecondTimeRange[] ranges) {
            return (MicroSecondTimeRange[])this.internalMerge(ranges, new MicroSecondTimeRange[0]);
        }

        public List<MicroSecondTimeRange> merge(List<MicroSecondTimeRange> chunks) {
            return Arrays.asList((MicroSecondTimeRange[])this.internalMerge(chunks.toArray(), new MicroSecondTimeRange[0]));
        }
    }

    private static abstract class Merger {
        private Merger() {
        }

        public abstract Object merge(Object var1, Object var2);

        public abstract boolean shouldMerge(Object var1, Object var2);

        public Object[] internalMerge(Object[] chunks, Object[] resultantTypeArray) {
            chunks = (Object[])chunks.clone();
            block0: for (int i = 0; i < chunks.length; ++i) {
                Object chunk = chunks[i];
                for (int j = i + 1; j < chunks.length; ++j) {
                    Object chunk2 = chunks[j];
                    if (!this.shouldMerge(chunk, chunk2)) continue;
                    chunks[j] = this.merge(chunk, chunk2);
                    chunks[i] = null;
                    continue block0;
                }
            }
            ArrayList<Object> results = new ArrayList<Object>();
            for (int i = 0; i < chunks.length; ++i) {
                if (chunks[i] == null) continue;
                results.add(chunks[i]);
            }
            return results.toArray(resultantTypeArray);
        }
    }
}

