/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.sc.seis.fissuresUtil.cache.NSEventDC;
import edu.sc.seis.fissuresUtil.cache.NSNetworkDC;
import edu.sc.seis.fissuresUtil.cache.NSSeismogramDC;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.fissuresUtil.simple.SimpleSeismogramClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameServiceWalker {
    private static Logger logger = LoggerFactory.getLogger(NameServiceWalker.class);

    public NameServiceWalker() {
        FissuresNamingService fisName = Initializer.getNS();
        NSNetworkDC[] nets = fisName.getAllNetworkDC();
        System.out.println("Got " + nets.length + " net dcs");
        NSEventDC[] eventdcs = fisName.getAllEventDC();
        System.out.println("Got " + eventdcs.length + " event dcs");
        NSSeismogramDC[] seisdcs = fisName.getAllSeismogramDC();
        System.out.println("Got " + seisdcs.length + " seis dcs");
        RequestFilter[] rf = SimpleSeismogramClient.createCurrentRF();
        rf[0].channel_id = Initializer.AMNOChannel;
        for (int i = 0; i < seisdcs.length; ++i) {
            try {
                LocalSeismogram[] seis = seisdcs[i].retrieve_seismograms(rf);
                System.out.println("Got " + seis.length + " seismograms from " + seisdcs[i].getServerName() + " server");
                continue;
            }
            catch (FissuresException e) {
                logger.error("FissuresException with " + i + " server: " + e.the_error.error_description, (Throwable)e);
                continue;
            }
            catch (Throwable e) {
                logger.error("Problem with " + i + "th seis dc", e);
            }
        }
    }

    public static void main(String[] args) {
        Initializer.init(args);
        new NameServiceWalker();
    }
}

