/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.database.seismogram.RT130Report;
import edu.sc.seis.fissuresUtil.rt130.DASChannelCreator;
import edu.sc.seis.fissuresUtil.rt130.FileNameParser;
import edu.sc.seis.fissuresUtil.rt130.LeapSecondApplier;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.PropParser;
import edu.sc.seis.fissuresUtil.rt130.RT130FileHandlerFlag;
import edu.sc.seis.fissuresUtil.rt130.RT130FileReader;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatError;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.rt130.RT130ToLocalSeismogram;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RT130FileHandler {
    private DASChannelCreator chanCreator;
    private RT130FileReader rtFileReader = new RT130FileReader();
    private RT130ToLocalSeismogram toSeismogram;
    private List flags;
    private PropParser pp;
    private RT130Report report;
    private static final Logger logger = LoggerFactory.getLogger(RT130FileHandler.class);
    private TimeInterval acceptableLengthOfData;

    public RT130FileHandler(Properties props, List rt130FileHandlerFlags, RT130Report report) throws FileNotFoundException, IOException, ParseException {
        this.report = report;
        this.pp = new PropParser(props);
        this.flags = rt130FileHandlerFlags;
        this.checkFlagsForIncompatibleSettings();
        LeapSecondApplier.addLeapSeconds(this.pp.getPath("leapSecondFile"));
        LeapSecondApplier.addCorrections(this.pp.getPath("powerUpTimes"));
        Map dataStreamToSampleRate = RT130ToLocalSeismogram.makeDataStreamToSampleRate(props, this.pp);
        this.chanCreator = new DASChannelCreator(props);
        this.toSeismogram = new RT130ToLocalSeismogram(this.chanCreator, dataStreamToSampleRate);
        double nominalLengthOfData = Double.parseDouble(this.pp.getString("nominalLengthOfData"));
        this.acceptableLengthOfData = new TimeInterval(nominalLengthOfData + nominalLengthOfData * 0.05, UnitImpl.MILLISECOND);
    }

    public boolean handle(File f) throws IOException {
        if (this.flags.contains(RT130FileHandlerFlag.SCAN)) {
            return this.scan(f);
        }
        return this.read(f);
    }

    public boolean scan(File file) throws IOException {
        Channel[] channel;
        TimeInterval lengthOfData;
        if (file.getName().endsWith("00000000")) {
            return this.read(file);
        }
        String unitIdNumber = this.getUnitId(file);
        try {
            lengthOfData = FileNameParser.getLengthOfData(file.getName());
        }
        catch (RT130FormatException e) {
            this.reportFormatException(file, e);
            return false;
        }
        if (lengthOfData.greaterThan((QuantityImpl)this.acceptableLengthOfData)) {
            this.reportBadName(file, file.getName() + " indicates more data than in a regular rt130 file. The file will be read to determine its true length.");
            return this.read(file);
        }
        MicroSecondDate beginTime = this.getBeginTime(file, unitIdNumber);
        MicroSecondDate nominalEndTime = beginTime.add(this.acceptableLengthOfData);
        MicroSecondTimeRange fileTimeWindow = new MicroSecondTimeRange(beginTime, nominalEndTime);
        try {
            channel = this.chanCreator.create(unitIdNumber, file.getCanonicalPath(), fileTimeWindow);
        }
        catch (RT130FormatError err) {
            this.reportFormatException(file, err);
            return false;
        }
        MicroSecondDate endTime = beginTime.add(lengthOfData);
        for (int i = 0; i < channel.length; ++i) {
            this.addToReport(channel[i], beginTime, endTime);
        }
        return true;
    }

    private MicroSecondDate getBeginTime(File file, String unitId) {
        MicroSecondDate begin = FileNameParser.getBeginTime(file.getParentFile().getParentFile().getParentFile().getName(), file.getName());
        return LeapSecondApplier.applyLeapSecondCorrection(unitId, begin);
    }

    public boolean read(File file) throws IOException {
        String unitIdNumber = this.getUnitId(file);
        TimeInterval seismogramTime = this.processAllChannels(file, unitIdNumber);
        if (this.flags.contains(RT130FileHandlerFlag.FULL)) {
            TimeInterval lengthOfDataFromFileName;
            try {
                lengthOfDataFromFileName = FileNameParser.getLengthOfData(file.getName());
            }
            catch (RT130FormatException e) {
                this.reportFormatException(file, e);
                return false;
            }
            if (lengthOfDataFromFileName.value != seismogramTime.value) {
                this.reportBadName(file, file.getName() + " seems to be an invalid rt130 file name. The length of data described in the file name does not match the length of data in the file.");
            }
        }
        return true;
    }

    private void reportFormatException(File file, Exception e) throws IOException {
        this.report.addFileFormatException(file.getCanonicalPath(), e.getMessage());
        logger.error(e.getMessage());
    }

    private void reportBadName(File file, String msg) throws IOException {
        this.report.addMalformedFileNameException(file.getCanonicalPath(), msg);
        logger.error(msg);
    }

    private String getUnitId(File file) {
        return file.getParentFile().getParentFile().getName();
    }

    private TimeInterval processAllChannels(File file, String unitIdNumber) throws IOException {
        LocalSeismogramImpl[] seis;
        PacketType[] seismogramDataPacketArray;
        String fileName = file.getName();
        String yearAndDay = file.getParentFile().getParentFile().getParentFile().getName();
        MicroSecondDate beginTime = FileNameParser.getBeginTime(yearAndDay, fileName);
        beginTime = LeapSecondApplier.applyLeapSecondCorrection(unitIdNumber, beginTime);
        MicroSecondDate endTime = beginTime.add(this.acceptableLengthOfData);
        MicroSecondTimeRange fileTimeWindow = new MicroSecondTimeRange(beginTime, endTime);
        TimeInterval seismogramTime = new TimeInterval(0.0, UnitImpl.MILLISECOND);
        try {
            seismogramDataPacketArray = this.rtFileReader.processRT130Data(file.getCanonicalPath(), true, fileTimeWindow);
        }
        catch (RT130FormatException e) {
            this.reportFormatException(file, e);
            return seismogramTime;
        }
        try {
            seis = this.toSeismogram.convert(seismogramDataPacketArray);
        }
        catch (RT130FormatError e) {
            this.reportFormatException(file, e);
            return seismogramTime;
        }
        Channel[] chans = this.toSeismogram.getChannels();
        for (int i = 0; i < seis.length; ++i) {
            MicroSecondDate end = seis[i].getEndTime().add(seis[i].getSampling().getPeriod());
            for (int j = 0; j < chans.length; ++j) {
                if (chans[j].get_id() != seis[i].channel_id) continue;
                this.addToReport(chans[j], seis[i].getBeginTime(), end);
                break;
            }
            if (!this.flags.contains(RT130FileHandlerFlag.FULL) || seismogramTime.value != 0.0) continue;
            seismogramTime = new TimeInterval(seis[i].getBeginTime(), end);
        }
        return (TimeInterval)seismogramTime.convertTo(UnitImpl.MILLISECOND);
    }

    private void addToReport(Channel channel, MicroSecondDate beginTime, MicroSecondDate endTime) {
        this.report.addRefTekSeismogram(channel, beginTime, endTime);
    }

    private void checkFlagsForIncompatibleSettings() {
        if (this.flags.contains(RT130FileHandlerFlag.SCAN) && this.flags.contains(RT130FileHandlerFlag.FULL)) {
            while (this.flags.contains(RT130FileHandlerFlag.FULL)) {
                this.flags.remove(RT130FileHandlerFlag.FULL);
            }
            logger.warn("Both -scan and -full flags were set.");
            logger.warn("Scan processing of RT130 data: ON");
        }
    }
}

