/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.netConnChecker;

import edu.sc.seis.fissuresUtil.netConnChecker.ConcreteConnChecker;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatus;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPChecker
extends ConcreteConnChecker {
    private String url;
    private static Logger logger = LoggerFactory.getLogger(HTTPChecker.class);

    public HTTPChecker(String description, String url) {
        super(description);
        this.url = url;
    }

    @Override
    public void run() {
        try {
            URL seis = new URL(this.url);
            URLConnection seisConnection = seis.openConnection();
            InputStreamReader buffer = new InputStreamReader(seisConnection.getInputStream());
            BufferedReader bufferread = new BufferedReader(buffer);
            this.setTrying(false);
            this.setFinished(true);
            this.setSuccessful(true);
            this.fireStatusChanged(this.getDescription(), ConnStatus.SUCCESSFUL);
        }
        catch (MalformedURLException urle) {
            this.cause = urle;
            this.setTrying(false);
            this.setFinished(true);
            this.setSuccessful(false);
            this.setUnknown(true);
            this.fireStatusChanged(this.getDescription(), ConnStatus.UNKNOWN);
        }
        catch (IOException ioe) {
            this.cause = ioe;
            this.setTrying(false);
            this.setFinished(true);
            this.setSuccessful(false);
            this.fireStatusChanged(this.getDescription(), ConnStatus.FAILED);
        }
        catch (Exception e) {
            this.cause = e;
            this.setTrying(false);
            this.setFinished(true);
            this.setSuccessful(false);
            this.fireStatusChanged(this.getDescription(), ConnStatus.FAILED);
        }
    }

    public String getURL() {
        return this.url;
    }
}

