/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.namingService;

import edu.iris.Fissures.IfEvent.EventDC;
import edu.iris.Fissures.IfEvent.EventDCHelper;
import edu.iris.Fissures.IfNetwork.NetworkDC;
import edu.iris.Fissures.IfNetwork.NetworkDCHelper;
import edu.iris.Fissures.IfPlottable.PlottableDC;
import edu.iris.Fissures.IfPlottable.PlottableDCHelper;
import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.IfSeismogramDC.DataCenterHelper;
import edu.iris.Fissures.model.AllVTFactory;
import edu.sc.seis.fissuresUtil.cache.NSEventDC;
import edu.sc.seis.fissuresUtil.cache.NSNetworkDC;
import edu.sc.seis.fissuresUtil.cache.NSPlottableDC;
import edu.sc.seis.fissuresUtil.cache.NSSeismogramDC;
import edu.sc.seis.fissuresUtil.cache.ServerNameDNS;
import edu.sc.seis.fissuresUtil.mockFissures.IfEvent.MockEventDC;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockNetworkDC;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.NamedNetDC;
import edu.sc.seis.fissuresUtil.mockFissures.IfSeismogramDC.MockDC;
import edu.sc.seis.fissuresUtil.mockFissures.IfSeismogramDC.NamedMockSeisDC;
import edu.sc.seis.fissuresUtil.namingService.NamingContextWithPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA_2_3.ORB;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.Servant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FissuresNamingService {
    private String nameServiceCorbaLoc;
    private ORB orb;
    private NamingContextExt rootNamingContext;
    protected List<String> otherNS = new LinkedList<String>();
    private static final Logger logger = LoggerFactory.getLogger(FissuresNamingService.class);
    public static final String FISSURES = "Fissures";
    public static final String NETWORKDC = "NetworkDC";
    public static final String EVENTDC = "EventDC";
    public static final String PLOTTABLEDC = "PlottableDC";
    public static final String SEISDC = "DataCenter";
    public static final String INTERFACE = "interface";
    public static final String DNS = "dns";
    public static final String MOCK_DNS = "edu/sc/seis/mock";
    public static final String CORBALOC_PROP = "edu.sc.seis.fissuresUtil.nameServiceCorbaLoc";
    public static final String ADDITIONAL_CORBALOC_PROP = "edu.sc.seis.fissuresUtil.additionalNameServiceCorbaLoc";
    public static final String OBJECT = "object_FVer1.0";

    public FissuresNamingService() {
        this(System.getProperties());
    }

    public FissuresNamingService(Properties props) {
        String[] args = new String[]{};
        this.orb = (ORB)org.omg.CORBA.ORB.init((String[])args, (Properties)props);
        AllVTFactory vt = new AllVTFactory();
        vt.register(this.orb);
    }

    public FissuresNamingService(ORB orb) {
        this.orb = orb;
    }

    public void setNameServiceCorbaLoc(String nameServiceCorbaLoc) {
        this.nameServiceCorbaLoc = nameServiceCorbaLoc;
        this.rootNamingContext = null;
    }

    public String getNameServiceCorbaLoc() {
        return this.nameServiceCorbaLoc;
    }

    public void addOtherNameServiceCorbaLoc(String otherNSCorbaLoc) {
        this.otherNS.add(otherNSCorbaLoc);
    }

    public String[] getOtherNameServices() {
        return this.otherNS.toArray(new String[0]);
    }

    public synchronized Object getRoot() {
        Object rootObj;
        if (this.nameServiceCorbaLoc != null) {
            logger.info("Using name service corba loc=" + this.nameServiceCorbaLoc);
            rootObj = this.orb.string_to_object(this.nameServiceCorbaLoc);
            if (rootObj == null) {
                throw new UNKNOWN("Got a null object back from string_to_object on " + this.nameServiceCorbaLoc + "  This probably indicates something wrong with the name server given, but it's hard to say since our orb just returned null.");
            }
            logger.debug("got root object");
        } else {
            logger.debug("resolve initial references");
            try {
                rootObj = this.orb.resolve_initial_references("NameService");
            }
            catch (org.omg.CORBA.ORBPackage.InvalidName e) {
                throw new RuntimeException("Unable to resolve from initial references", e);
            }
            if (rootObj == null) {
                throw new RuntimeException("Unable to resolve from initial references");
            }
        }
        return rootObj;
    }

    public synchronized NamingContextExt getNameService() {
        if (this.rootNamingContext == null) {
            Object rootObj = this.getRoot();
            logger.debug("now trying narrow ");
            this.rootNamingContext = NamingContextExtHelper.narrow((Object)rootObj);
        }
        return this.rootNamingContext;
    }

    public void reset() {
        if (this.rootNamingContext != null) {
            this.rootNamingContext._release();
        }
        this.rootNamingContext = null;
    }

    public Object resolveBySteps(NameComponent[] names) throws NotFound, CannotProceed, InvalidName {
        Object out = null;
        for (int i = 0; i < names.length; ++i) {
            NameComponent[] subNames = new NameComponent[i + 1];
            System.arraycopy(names, 0, subNames, 0, i + 1);
            logger.debug("trying to resolve step id='" + names[i].id + "' kind='" + names[i].kind + "'");
            out = this.getNameService().resolve(subNames);
        }
        return out;
    }

    public static String piecesToNameString(String dns, String interfacename, String objectname) {
        FissuresNamingService.checkForContents(dns, "dns must be specified");
        FissuresNamingService.checkForContents(interfacename, "Interface name must be specified.  DNS is " + dns);
        FissuresNamingService.checkForContents(objectname, "Object name must be specified.  DNS is " + dns + "and interface is " + interfacename);
        return FissuresNamingService.appendKindNames(dns) + "/" + interfacename + ".interface/" + objectname + ".object" + FissuresNamingService.getVersion();
    }

    private static void checkForContents(String toCheck, String errorMsg) {
        if (toCheck == null || toCheck.length() == 0) {
            throw new IllegalArgumentException(errorMsg);
        }
    }

    public Object resolve(String dns, String interfacename, String objectname) throws NotFound, CannotProceed, InvalidName {
        String nameString = FissuresNamingService.piecesToNameString(dns, interfacename, objectname);
        logger.info("resolved: " + nameString);
        int maxTry = 1;
        for (int i = 0; i <= maxTry; ++i) {
            try {
                NameComponent[] names = this.getNameService().to_name(nameString);
                return this.getNameService().resolve(names);
            }
            catch (SystemException e) {
                logger.info("retry=" + i + " " + (java.lang.Object)((java.lang.Object)e));
                if (i != maxTry) continue;
                throw e;
            }
            catch (NotFound nfe) {
                logger.info("retry=" + i + "NOT FOUND Exception caught while resolving name context and the name not found is " + nfe.rest_of_name[0].id + " from " + this.nameServiceCorbaLoc);
                if (i != maxTry) continue;
                throw nfe;
            }
            catch (InvalidName ine) {
                logger.info("retry=" + i + "INVALID NAME Exception caught while resolving name context", (Throwable)ine);
                if (i != maxTry) continue;
                throw ine;
            }
            catch (CannotProceed cpe) {
                logger.info("retry=" + i + "CANNOT PROCEED Exception caught while resolving dns name context");
                if (i != maxTry) continue;
                throw cpe;
            }
        }
        throw new RuntimeException("This code should never happen");
    }

    public void rebind(String dns, String objectname, Object obj) throws NotFound, CannotProceed, InvalidName {
        this.rebind(dns, objectname, obj, FissuresNamingService.getInterfaceName(obj));
    }

    public void rebind(String dns, String objectname, Object obj, String interfacename) throws NotFound, CannotProceed, InvalidName {
        String corbaloc = this.getNameServiceCorbaLoc();
        try {
            this.rebind(dns, objectname, obj, interfacename, corbaloc);
        }
        catch (SystemException e) {
            logger.warn("Unable to register with : " + corbaloc, (Throwable)e);
        }
        Iterator<String> it = this.otherNS.iterator();
        while (it.hasNext()) {
            try {
                corbaloc = it.next();
                this.rebind(dns, objectname, obj, interfacename, corbaloc);
            }
            catch (SystemException e) {
                logger.warn("Unable to register with : " + corbaloc, (Throwable)e);
            }
        }
    }

    public void rebind(String dns, String objectname, Object obj, String interfacename, String corbaLoc) throws NotFound, CannotProceed, InvalidName {
        int retries = 3;
        SystemException lastException = null;
        while (retries > 0) {
            try {
                Object ncObj = this.orb.string_to_object(corbaLoc);
                if (ncObj != null) {
                    NamingContextExt nc = NamingContextExtHelper.narrow((Object)ncObj);
                    this.rebind(dns, objectname, obj, nc, interfacename);
                    return;
                }
                throw new InvalidName("Can't string_to_object for " + corbaLoc);
            }
            catch (SystemException e) {
                logger.warn("Problem registering with: " + corbaLoc + " retries=" + --retries, (Throwable)e);
                lastException = e;
            }
        }
        throw lastException;
    }

    public void rebind(String dns, String objectname, Object obj, NamingContextExt topLevelNameContext) throws NotFound, CannotProceed, InvalidName {
        String interfaceName = FissuresNamingService.getInterfaceName(obj);
        logger.info("Rebind, as " + interfaceName + "  for classname: " + obj.getClass().getName());
        this.rebind(dns, objectname, obj, topLevelNameContext, interfaceName);
    }

    public NamingContext rebindBySteps(NameComponent[] name, NamingContextExt topLevel) throws CannotProceed, InvalidName, NotFound {
        NamingContextExt binder = topLevel;
        for (int i = 0; i < name.length - 1; ++i) {
            NamingContext temp;
            try {
                temp = NamingContextHelper.narrow((Object)binder.resolve(new NameComponent[]{name[i]}));
            }
            catch (NotFound e) {
                logger.debug("rebinding by steps: " + name[i].id + "." + name[i].kind + " due to " + e.getMessage());
                try {
                    temp = binder.bind_new_context(new NameComponent[]{name[i]});
                }
                catch (AlreadyBound ee) {
                    throw new RuntimeException("shouldn't happen as we just tried a resolve that failed", ee);
                }
            }
            binder = temp;
        }
        return binder;
    }

    public void rebind(String dns, String objectId, Object obj, NamingContextExt topLevel, String interfacename) throws NotFound, CannotProceed, InvalidName {
        if (topLevel == null) {
            throw new IllegalArgumentException("top level name context is null!");
        }
        String nameString = FissuresNamingService.piecesToNameString(dns, interfacename, objectId);
        logger.info("the object to be rebound is " + nameString);
        NameComponent[] name = topLevel.to_name(nameString);
        try {
            NamingContext lowestContext = this.rebindBySteps(name, topLevel);
            lowestContext.rebind(new NameComponent[]{name[name.length - 1]}, obj);
            try {
                topLevel.resolve(name);
            }
            catch (NotFound e) {
                logger.debug("Failure on resolve after rebinding for " + nameString, (Throwable)e);
                topLevel.rebind(name, obj);
            }
            logger.debug("Rebind successful for " + nameString);
        }
        catch (NotFound nfe) {
            logger.debug("Failure on rebund for " + nameString, (Throwable)nfe);
            switch (nfe.why.value()) {
                case 0: {
                    int numMissing = nfe.rest_of_name.length;
                    NameComponent[] contextName = new NameComponent[name.length - 1];
                    System.arraycopy(name, 0, contextName, 0, contextName.length);
                    logger.debug("Missing " + numMissing + " context nodes from a total of " + contextName.length + " in " + nameString + ".  Attempting to bind them as new contexts one by one");
                    try {
                        NamingContextExt lastContext = topLevel;
                        int curLevel = 0;
                        int i = name.length - numMissing;
                        while (i < name.length) {
                            logger.debug("Binding " + contextName[i - 1].id + "." + contextName[i - 1].kind + " as new context");
                            NameComponent[] subName = new NameComponent[i - curLevel];
                            System.arraycopy(contextName, curLevel, subName, 0, subName.length);
                            lastContext = lastContext.bind_new_context(subName);
                            curLevel = i++;
                        }
                        lastContext.bind(new NameComponent[]{name[name.length - 1]}, obj);
                    }
                    catch (AlreadyBound e) {
                        logger.error("Shouldn't be already bound, just got an exception saying it wasn't bound", (Throwable)e);
                    }
                    break;
                }
                case 1: {
                    logger.error("Not a Context");
                    logger.error(nfe.rest_of_name[0].id + "  IS PASSED AS A CONTEXT. ACTUALLY IT IS ALREADY BOUND AS AN OBJECT");
                    throw nfe;
                }
                case 2: {
                    logger.error("Not an Object");
                    logger.error(nfe.rest_of_name[0].id + "  IS PASSED AS AN OBJECT. ACTUALLY IT IS ALREADY BOUND AS A CONTEXT");
                    throw nfe;
                }
                default: {
                    logger.error("Unknown NotFound error code: " + nfe.why.value(), (Throwable)nfe);
                    throw nfe;
                }
            }
        }
    }

    public void unbind(String dns, String interfacename, String objectname) throws NotFound, CannotProceed, InvalidName {
        logger.info("unbind " + dns + "/" + interfacename + "/" + objectname);
        this.unbind(dns, interfacename, objectname, this.getNameService());
        for (String corbaloc : this.otherNS) {
            Object ncObj = this.orb.string_to_object(corbaloc);
            if (ncObj == null) continue;
            NamingContextExt nc = NamingContextExtHelper.narrow((Object)ncObj);
            this.unbind(dns, interfacename, objectname, nc);
        }
    }

    public void unbind(String dns, String interfacename, String objectname, NamingContextExt topLevelNameContext) throws NotFound, CannotProceed, InvalidName {
        String toUnbind = FissuresNamingService.piecesToNameString(dns, interfacename, objectname);
        logger.debug("Attempting to unbind " + toUnbind);
        topLevelNameContext.unbind(topLevelNameContext.to_name(toUnbind));
    }

    public void unbind(String dns, String objectname, Object obj) throws NotFound, CannotProceed, InvalidName {
        String interfacename = FissuresNamingService.getInterfaceName(obj);
        this.unbind(dns, interfacename, objectname);
    }

    public NetworkDC getNetworkDC(String dns, String objectname) throws NotFound, CannotProceed, InvalidName {
        if (FissuresNamingService.isMock(dns, objectname)) {
            if (dns.equals(MOCK_DNS)) {
                return NamedNetDC.create(objectname);
            }
            return new MockNetworkDC();
        }
        return NetworkDCHelper.narrow((Object)this.getNetworkDCObject(dns, objectname));
    }

    public Object getNetworkDCObject(String dns, String objectname) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(dns, NETWORKDC, objectname);
    }

    public DataCenter getSeismogramDC(String dns, String objectname) throws NotFound, CannotProceed, InvalidName {
        if (FissuresNamingService.isMock(dns, objectname)) {
            if (dns.equals(MOCK_DNS)) {
                return NamedMockSeisDC.create(objectname);
            }
            return new MockDC();
        }
        logger.debug("before get SeismogramDC Object");
        Object obj = this.getSeismogramDCObject(dns, objectname);
        DataCenter datacenter = DataCenterHelper.narrow((Object)obj);
        return datacenter;
    }

    public Object getSeismogramDCObject(String dns, String objectname) throws NotFound, CannotProceed, InvalidName {
        Object obj = this.resolve(dns, SEISDC, objectname);
        return obj;
    }

    public PlottableDC getPlottableDC(String dns, String objectname) throws NotFound, CannotProceed, InvalidName {
        return PlottableDCHelper.narrow((Object)this.getPlottableDCObject(dns, objectname));
    }

    public Object getPlottableDCObject(String dns, String objectname) throws NotFound, CannotProceed, InvalidName {
        Object obj = this.resolve(dns, PLOTTABLEDC, objectname);
        return obj;
    }

    public EventDC getEventDC(String dns, String objectname) throws NotFound, CannotProceed, InvalidName {
        if (FissuresNamingService.isMock(dns, objectname)) {
            return new MockEventDC();
        }
        return EventDCHelper.narrow((Object)this.getEventDCObject(dns, objectname));
    }

    public Object getEventDCObject(String dns, String objectname) throws NotFound, CannotProceed, InvalidName {
        Object obj = this.resolve(dns, EVENTDC, objectname);
        return obj;
    }

    public List getAllObjects(String interfaceName) {
        return this.getAllObjects(interfaceName, this.getRootNamingContextWithPath());
    }

    public NamingContextWithPath getRootNamingContextWithPath() {
        return new NamingContextWithPath((NamingContext)this.getNameService(), "/");
    }

    public List getAllObjects(String interfaceName, NamingContextWithPath startingBranch) {
        ArrayList<NSNetworkDC> leaves = new ArrayList<NSNetworkDC>();
        NamingContext namingContext = startingBranch.getNamingContext();
        BindingListHolder bindings = new BindingListHolder();
        BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
        namingContext.list(0, bindings, bindingIteratorHolder);
        BindingIterator bindingIterator = bindingIteratorHolder.value;
        BindingHolder bindingHolder = new BindingHolder();
        while (bindingIterator != null && bindingIterator.next_one(bindingHolder)) {
            Binding binding = bindingHolder.value;
            if (binding.binding_type == BindingType.ncontext) {
                if ((!binding.binding_name[0].kind.equals(INTERFACE) || !binding.binding_name[0].id.equals(interfaceName)) && !binding.binding_name[0].kind.equals(DNS)) continue;
                String newPath = binding.binding_name[0].kind.equals(DNS) ? startingBranch.getPath() + binding.binding_name[0].id + "/" : startingBranch.getPath();
                NamingContext newNC = null;
                try {
                    newNC = NamingContextHelper.narrow((Object)namingContext.resolve(binding.binding_name));
                }
                catch (UserException e) {
                    throw new RuntimeException("This should not happen as the naming context should have come from the server.  This probably indicates a programming error.", e);
                }
                leaves.addAll(this.getAllObjects(interfaceName, new NamingContextWithPath(newNC, newPath)));
                continue;
            }
            if (!binding.binding_name[0].kind.equals(OBJECT)) continue;
            ServerNameDNS o = null;
            if (interfaceName.equals(NETWORKDC)) {
                o = new NSNetworkDC(startingBranch.trimFissuresPath(), binding.binding_name[0].id, this);
            } else if (interfaceName.equals(EVENTDC)) {
                o = new NSEventDC(startingBranch.trimFissuresPath(), binding.binding_name[0].id, this);
            } else if (interfaceName.equals(SEISDC)) {
                o = new NSSeismogramDC(startingBranch.trimFissuresPath(), binding.binding_name[0].id, this);
            } else if (interfaceName.equals(PLOTTABLEDC)) {
                o = new NSPlottableDC(startingBranch.trimFissuresPath(), binding.binding_name[0].id, this);
            } else {
                try {
                    o = startingBranch.getNamingContext().resolve(binding.binding_name);
                }
                catch (UserException e) {
                    throw new RuntimeException("This should not happen as the naming context should have come from the server.  This probably indicates a programming error.", e);
                }
            }
            leaves.add((NSNetworkDC)o);
        }
        return leaves;
    }

    public NSNetworkDC[] getAllNetworkDC() {
        return this.getAllNetworkDC(this.getRootNamingContextWithPath());
    }

    public NSNetworkDC[] getAllNetworkDC(NamingContextWithPath nc) {
        return this.getAllObjects(NETWORKDC, nc).toArray(new NSNetworkDC[0]);
    }

    public NSEventDC[] getAllEventDC() {
        return this.getAllEventDC(this.getRootNamingContextWithPath());
    }

    public NSEventDC[] getAllEventDC(NamingContextWithPath nc) {
        return this.getAllObjects(EVENTDC, nc).toArray(new NSEventDC[0]);
    }

    public NSPlottableDC[] getAllPlottableDC() {
        return this.getAllPlottableDC(this.getRootNamingContextWithPath());
    }

    public NSPlottableDC[] getAllPlottableDC(NamingContextWithPath nc) {
        return this.getAllObjects(PLOTTABLEDC, nc).toArray(new NSPlottableDC[0]);
    }

    public NSSeismogramDC[] getAllSeismogramDC() {
        return this.getAllSeismogramDC(this.getRootNamingContextWithPath());
    }

    public NSSeismogramDC[] getAllSeismogramDC(NamingContextWithPath nc) {
        return this.getAllObjects(SEISDC, nc).toArray(new NSSeismogramDC[0]);
    }

    public String[] getInterfaceNames(String dns) throws NotFound, CannotProceed, InvalidName {
        dns = FissuresNamingService.appendKindNames(dns);
        return this.getNames(dns, INTERFACE);
    }

    public String[] getInstanceNames(String dns, String interfacename) throws NotFound, CannotProceed, InvalidName {
        FissuresNamingService.checkForContents(interfacename, interfacename + " must be defined");
        return this.getNames(FissuresNamingService.appendKindNames(dns) + "/" + this.appendInterfaceKind(interfacename), "object" + FissuresNamingService.getVersion());
    }

    public String appendInterfaceKind(String interfacename) {
        return interfacename + "." + INTERFACE;
    }

    public String[] getDNSNames(String dns) throws NotFound, CannotProceed, InvalidName {
        String tempdns = new String(dns);
        dns = FissuresNamingService.appendKindNames(dns);
        String[] rtnValues = this.getNames(dns, DNS);
        for (int counter = 0; counter < rtnValues.length; ++counter) {
            rtnValues[counter] = tempdns + "/" + rtnValues[counter];
        }
        return rtnValues;
    }

    private String[] getNames(String dns, String kind) throws NotFound, CannotProceed, InvalidName {
        ArrayList<String> bindings = new ArrayList<String>();
        NamingContextExt myNS = this.getNameService();
        NameComponent[] nameComponents = myNS.to_name(dns);
        Object dnsNamingContextObj = myNS.resolve(nameComponents);
        NamingContextExt dnsNamingContext = NamingContextExtHelper.narrow((Object)dnsNamingContextObj);
        BindingListHolder bindingList = new BindingListHolder();
        BindingIteratorHolder bindingIteratorHolder = new BindingIteratorHolder();
        dnsNamingContext.list(0, bindingList, bindingIteratorHolder);
        BindingIterator bindingIterator = bindingIteratorHolder.value;
        BindingHolder bindingHolder = new BindingHolder();
        while (bindingIterator.next_one(bindingHolder)) {
            Binding binding = bindingHolder.value;
            if (!binding.binding_name[0].kind.equals(kind)) continue;
            bindings.add(binding.binding_name[0].id);
        }
        return bindings.toArray(new String[bindings.size()]);
    }

    public static String appendKindNames(String dns) {
        dns = "Fissures/" + dns + "/";
        StringTokenizer tokenizer = new StringTokenizer(dns, "/");
        String rtnValue = new String();
        while (tokenizer.hasMoreElements()) {
            String temp = (String)tokenizer.nextElement();
            temp = temp + "." + DNS + "/";
            rtnValue = rtnValue + temp;
        }
        rtnValue = rtnValue.substring(0, rtnValue.length() - 1);
        return rtnValue;
    }

    private static String getVersion() {
        String version = "1.0";
        String rtnValue = new String();
        String prefix = new String("_FVer");
        StringTokenizer tokenizer = new StringTokenizer(version, ".");
        while (tokenizer.hasMoreElements()) {
            String temp = (String)tokenizer.nextElement();
            temp = temp + "\\.";
            rtnValue = rtnValue + temp;
        }
        rtnValue = prefix + rtnValue.substring(0, rtnValue.length() - 2);
        return rtnValue;
    }

    public static String getInterfaceName(Servant obj) {
        return FissuresNamingService.getInterfaceNameForClass(obj.getClass());
    }

    public static String getInterfaceName(Object obj) {
        return FissuresNamingService.getInterfaceNameForClass(obj.getClass());
    }

    public static Class[] getAllInterfaces(Class c) {
        ArrayList interfaces = new ArrayList();
        if (c.isInterface()) {
            interfaces.add(c);
        }
        while (c != null && !c.equals(java.lang.Object.class)) {
            interfaces.addAll(Arrays.asList(c.getInterfaces()));
            c = c.getSuperclass();
        }
        return interfaces.toArray(new Class[0]);
    }

    public static String getInterfaceNameForClass(Class cl) {
        String fissuresInterfaceName = null;
        Class[] interfaces = FissuresNamingService.getAllInterfaces(cl);
        for (int counter = 0; counter < interfaces.length; ++counter) {
            if (!interfaces[counter].getName().startsWith("edu.iris.Fissures")) continue;
            fissuresInterfaceName = interfaces[counter].getName();
            StringTokenizer tokenizer = new StringTokenizer(fissuresInterfaceName, ".");
            String rtnValue = null;
            while (tokenizer.hasMoreElements()) {
                rtnValue = (String)tokenizer.nextElement();
            }
            if (rtnValue.endsWith("Operations")) {
                rtnValue = rtnValue.substring(0, rtnValue.lastIndexOf("Operations"));
            }
            return rtnValue;
        }
        throw new IllegalArgumentException(cl.getName() + " not recognized");
    }

    public static boolean isMock(String dns, String name) {
        return dns.equals("edu/sc/seis") && (name.equals("Mock") || name.equals("Timeout")) || dns.equals(MOCK_DNS);
    }
}

